#include <manip.h>
#include "montimer.h"


#ifndef powerc
//$$#include <A4Stuff.h>
#endif




//Globals


#ifndef powerc
void montimer(void);
#else
void montimer(TMInfoPtr	recPtr);
#endif

TMInfo				myTMInfo;


TMInfoPtr setuptimer(long delai,void (*execute)(void*),void * mastructure)
{
	TMInfoPtr	myTMInfopt=malloc(sizeof(TMInfo));
	
		//This statement will work with 68K or PPC 
	
	myTMInfopt->atmTask.tmAddr =  NewTimerProc(montimer);
	myTMInfopt->atmTask.qLink = NULL;
	myTMInfopt->atmTask.qType = 0;
	myTMInfopt->atmTask.tmCount = 0L;
	myTMInfopt->atmTask.tmWakeUp = 0L;
	myTMInfopt->atmTask.tmReserved = 0L;
	myTMInfopt->mastructure = mastructure;
	myTMInfopt->delai=delai;
	myTMInfopt->execute=execute;

	
#ifdef  powerc 
		//You don't need to do anything.  We will ignore the tmRefCon field.
#else
			//Store A4 into the TMInfo struct
			//This is the best way in this situation
//$$	myTMInfopt->tmRefCon = GetCurrentA4();
	myTMInfopt->A5=SetCurrentA5();
#endif //powerc
	
	InsXTime((QElemPtr)myTMInfopt);
	PrimeTime((QElemPtr)myTMInfopt, delai);
return(myTMInfopt);
}



void supprimetimer(TMInfoPtr  myTMInfopt)
{
if(myTMInfopt)
	{
	TimerUPP tt=myTMInfopt->atmTask.tmAddr;
	DisposeRoutineDescriptor(tt);
	RmvTime((QElemPtr)myTMInfopt);
	free(myTMInfopt);
	myTMInfopt=0;
	}
}



void stoptimer(TMInfoPtr  myTMInfopt)
{
if(myTMInfopt)	myTMInfopt->delai=0;
}

void redemarretimer(TMInfoPtr  myTMInfopt,long delai)
{
if(myTMInfopt)
	{
	myTMInfopt->delai=delai;
	PrimeTime((QElemPtr)myTMInfopt,myTMInfopt->delai);
	}
}


/*-----------------   prog interruption   -----------------------*/


#ifndef powerc

	//The 68K resource needs this glue to move the TMInfo pointer from A1 to A0 where 
	//the Toolbox put it.  N.B. This is very different from the pascal glue provided in 
	//IM 6 TimeManager chapter, but then Pascal is very different from C.
	
asm  inline TMInfoPtr GetTMInfo( void )
{
	move.l A1, A0;	
	rts;
}


	//This function is being called at interrupt time so we can't move memory.  All we can
	// do is to set a global flag which our Drawing proc will detect.
void montimer(void)
{
		//Get a pointer to our TMInfo so we can prime it again
	TMInfoPtr	recPtr = GetTMInfo();
	long		myDelay = 1000; //one sec.
	
		//Sets A4 to the value in tmRefCon which was set to point to A4 at non-interrupt time.
//$$	long 		oldA4 = SetA4(recPtr->tmRefCon);
	long		oldA5 =	 SetA5(recPtr->A5);			/*A5 du programme*/

	(recPtr->execute)(recPtr->mastructure);
	PrimeTime((QElemPtr)recPtr,recPtr->delai);
	
		//Restore the register state
//$$	(void)SetA4(oldA4);
	SetA5(oldA5);					/*restore A5*/		

}
	


#else

	//The PowerPC version of a TimerUPP has the TMInfo pointer as a parameter.  Whew! No glue.
	//In fact, no need to set up global space either!
void montimer(TMInfoPtr	recPtr)
{
	
	(recPtr->execute)(recPtr->mastructure);
	if(recPtr->delai) PrimeTime((QElemPtr)recPtr,recPtr->delai);

}
#endif //powerc





