#include "manip.h"
#include "choix_acquisition.h"
#include "archeops.h"
#include "choix_param.h"
#include "structure.h"
#include "fenetres_diabolo.h"



/*
Le fichier de donnes diabolo est un fichier mac de type 'DIA2' qui contient 
	une suite d'enregistrements.
	
Il commence par une entete correspondant  la structure de type F_entete
	- cette entete contient 

On a ensuite une suite d'enregistrements comportant chacun:
	- une entete partielle avec les parametres de mesure, y compris les parametres DAC
		structure de type F_entete_part
	- une suite de valeur correspondant  chaque point mesur et contenant:
			Le temps calcul
			Les 6 signaux de synchro
			Les voies 1  7 :  5 bolometre + 1 temperature + 1 chauffage regul

*/



/*
 long_entete 	  	= 272 
 long_entete_part 	= 2128 
 long_donne 	  	= 14 

*/


/*  ancienne structure reglage de DIABOLO	 (longueur= 12 + 14 *  nb_max_bolo ) */
/*	la nouvelle structure  a une longueur de  :     4  +  8 * nb_max_bolo  + automatismes + regul */ 
/*typedef struct
	{
	long	duree;			 dure d'une periode (en unite de 4.8 sec)		
	short 	nb_mesures;		 nombre de mesures dans une periode entiere 46  92	
	short	temp_mort;		 temps mort pour la detection synchrone numerique	

	short	periode_horloge;	 dure d'une periode (en unite de 0.2 sec), 20  80	
	short	flag;			 ----------------------------------------------	

	short	gainbrut[nb_max_bolo];	 valeur du gain cod : (0,1,2,...,15) 		
	short	gain[nb_max_bolo];	 valeur du gain en vraies valeurs(1,2,4,8,10,...,100) 
	short	dac[4][nb_max_bolo];	 les valeurs des DAC 4 voies en entier (0  4095)	
	short	phase[nb_max_bolo];	 valeur du dephasage individuel : valeur  0    1	

	}
	reglage_bolo;
*/


extern   param_bolo	parametr;		// liste bolo dans le programme principal
extern   reglage_bolo	reglage_standard[8];		// liste bolo dans le programme principal


typedef struct	{
		short	version;		// 2 pour cette version du programme
						
		short	long_entete;		// longueur de l'entete	
		short	long_entete_part;	// longueur de l'entete partielle
		short	long_donne;		// longueur d'une ligne de donnes

		unsigned long tempsdebut;	// temps de debut de fichier (temps mac en sec)	
		unsigned long tempsfin;		// temps de fin de fichier   (temps mac en sec)
		char commentaires[256];		// commentaires  la main
		} F_entete;	  


typedef struct	
		{
		short	n_ligne_don;		// Nombre de lignes de donn dans cet enregistrement
						// ou    nombre d'octets du commentaire
		short	n_blok;			// numero du blok dans le fichier
		short	change;			// valeur 0 = bloc identique au precedent
						// valeur 1 = bloc modifi
						// valeur 2 = debut de prise de donnees
						// valeur 10 = le block ne contient qu'un commentaire
						// valeur 1001 et suivante : block telescope type  th
						// valeur 2001 et suivante : block telescope type  tp

		short	bololut;		//  ancien parametre: bit 0  bit 3  ==1  si les courbes bolo ont ete lues
		} F_block_desc;


typedef struct	
		{

		unsigned long 	temps_controleur_debut;		// en micro/secondes :temps du premier point dans le bloc			
		unsigned long 	temps_controleur_fin;		// en micro/secondes :temps du dernier point dans le bloc			
		
		reglage_bolo	reglage;
		
		short 	bol_per[nb_max_bolo][nb_max_mes_per];	//   courbe echantillon d'une mesure
					
		} F_block_param;	  


//__________________________   calcul des valeurs  vraies en micro/volt 

//#define	xbolbrut(j)	((1e5*(double)gg->don.don_bolo[j])/(65536.*((double)(gg->reglage.gain[j]))))		// en V
//#define	xbolbrut(jjj)	((1e7*(double)gg->don.don_bolo[jjj])/(65536.*(double)parametr.bolo_gain[jjj]*gain_ampli(gg->reglage.bolo[jjj])))		// en V
#define	xbolbrut(jjj)	bol_micro_volt(gg->don.don_bolo[jjj],(double)parametr.bolo[jjj].bolo_gain*gain_ampli(gg->reglage.bolo[jjj]))	// en V

#define	xbol(jjj)	gg->corel[jjj]



typedef struct		// structure globale gg  dans le programme principal
	{
//	param_bolo	param;					// liste bolo dans le programme principal
	reglage_bolo	reglage;				// etat bolo dans le programme principal
	
	short 		bol_per[nb_max_bolo][nb_max_mes_per];	// table une periode

	
	//  ------  donnes lues en un point:
	
	double		periode_echantillonage;
	unsigned long	temps_cntl;			//  temps courant de la lecture d'un point
	unsigned long	temps_mac;			//  temps courant de la lecture d'un point

	F_donne		don;
	
	double		corel[nb_max_bolo];		// donnes apres corellation eventuelle
	

//__________________________________________________________________________________
		// ----------  parametres generaux 
	
	int	depou_en_cours;			// la tache de fond est active
	
	int	trace_ouvert;			//  pour connaitre les fenetre de trace ouverte
						//  1 -->  trace tout  ---  n'est plus utilise
						//  2 -->  trace une periode
						//  4 -->  trace detection synchrone
						//  8 -->  trace ondelette
						//  16 --> trace carte des lobes
						//  32 ->  une synchro selectuionne
	
	int	trace_tout[8];			//  numero des 8 fenetres trace_tout si elles sont ouvertes																	
	int	fichier_dia2_ouvert;		//  pour connaitre les fichiers ouverts
	int	fichier_arch_ouvert;		//  pour connaitre les fichiers ouverts
	int 	flag_fou;			//  flag pour transform de fourier
	int 	flag_corel;			//  flag pour transform de fourier
	int 	flag_tc_reduite;		//  flag pour telecommandes reduites
	int	scan_en_cours;			// scan en cours pour autoval, sauve fichier et bip de fin de scan
	int	compte_subscan;			// compte les sub scan
	int	compte_fichiers_th;		// compte les fichiers telescopr de type th sub scan
	int	compte_fichiers_tp;		// compte les fichiers telescopr de type tp  sub scan
	int	nb_trace;
	double	temps_origine;			//  origine des temps en secondes pour trace



//  ------  pour enregistrement d'une transitoire individuel


//	int		transilut;											// un seul flag pour tous : la table a t lue
//	int		transiindice;		le// indice pour ecriture de la table transi
//	short 	transi[nb_max_bolo][max_nb_transi];// table une periode

	}
	stglob;



extern  stglob  *gg;


void	tache_rapide(void);


void    emission_telecommande(int direction,void * tc);	// telecommande une chaine de 10 mots
void	emission_tc_reduite(unsigned char mot1,unsigned char mot2,unsigned char mot3);

void	param_reglage(void);

void	montracen(int fen,int n,double x,double*y);
int 	bolo_rouge(void);		//  l'indice du bolo rouge 

void	rafraichis_fenetres(void);


void	traite_block_journal		(block_type_journal*		blk);
void	traite_block_reglage		(block_type_reglage*		blk);
void	traite_block_dilution		(block_type_dilution*		blk);
void	traite_block_gps		(block_type_gps*		blk);
void	traite_block_une_periode	(block_type_une_periode*	blk);
void	traite_block_bolo_comprime	(block_type_bolo_comprime*	blk);
void	traite_block_bolo		(block_type_bolo*		blk);
void	traite_block_sst		(block_type_sst*		blk);
void	traite_block_sst_comprime	(block_type_sst_comprime*	blk);
void	traite_block_gyro		(block_type_gyro*		blk);
void	traite_block_gyro_comprime	(block_type_gyro_comprime*	blk);
void	traite_block_synchro_sol	(block_type_synchro_sol*	blk);

#ifdef	transmet_data_brute
void	traite_block_data_brute		(block_type_data_brute*		blk);
#endif


