#include "manip.h"
#include "choix_acquisition.h"
#include "archeops.h"
#include "choix_param.h"
#include "structure.h"
#include "tm.h"
#include "simulmission.h"
#include "simulstate.h"

void ReadSimulDC()
{
  char buf[200];
  char* p;
  short frefnum;
  long count;
  short dummy;
  if (FSOpen("\psimul.datacard", 0, &frefnum)) return;
  while (1) {
    count = 200;
    FSRead(frefnum, &count, buf);
    buf[count] = 0;
    if (count == 0) break;
    p = strchr(buf, '\r');
    if (!p) break;
    SetFPos(frefnum, fsFromMark, -count + (p-buf) +1);
    if (buf[0] != '@') continue;
    p = strchr(buf, ' ');
    if (!p) continue;
    *p = 0; p++;
    if (!strcmp(buf, "@SPEED"))
      sscanf(p, "%lg", &overSpeed);
    else if (!strcmp(buf, "@WNOISE")) {
      sscanf(p, "%lg %lg %lg %lg %lg %lg", whiteNoise, whiteNoise+1, whiteNoise+2,
          whiteNoise+3, whiteNoise+4, whiteNoise+5);
    } else if (!strcmp(buf, "@FREQ")) {
      sscanf(p, "%lg %lg %lg %lg %lg %lg", bolfreq, bolfreq+1, bolfreq+2,
          bolfreq+3, bolfreq+4, bolfreq+5);
    } else if (!strcmp(buf, "@GLITCH")) {
      sscanf(p, "%lg %lg", &glitchFreq, &glitchMaxAmpl);
    } else if (!strcmp(buf, "@BOLOTCONST")) {
      sscanf(p, "%lg", &boloTimeCst);
    } else if (!strcmp(buf, "@SST2BARS")) {
      sscanf(p, "%lg", &dummy);
      sst2Bars = (dummy != 0);
    }
  }
  FSClose(frefnum);
}
