#include "diabolo.h"
#include "bolo.h"

//*********  coefficients  pour  les  mesures  bolo    ***************************************************
//													//
//	-1-	loi de reponse thermique des bolos  avec R en ohms et T en Kelvin  coef 0,1,2		//
//													//
// 	T =  coef2  *   (   ln (  R / coef1) **  ( -1 / coef0 )						//
//													//
//	-2-	fuite thermique du bolo   coef 3,4							//
//													//
//	Ptot =  coef3  *  ( Tb ** coef4    -    Tcryo  **  coef4 )					//
//													//
//	-3-	calcul empirique de Pciel et de  tau	  coef  5,6					//
//													//
//		Pciel	=	V * I -  coef5			coef5= I * Ai (tables xavier)		//
//		tau	=	- ln ( 1 +  Pciel / coef6 )	coef6= I * Bi (tables xavier)		//
//													//
//******************************************************************************************************//

#define	c(i)		(1e-4*(double)parametr.bolo[fen-1].coef[i])	


void mesures_bolo(int fen,int carr,int tri,int flag)
{
double I,V,R,T,Pelec,Tcryo,Ptot,Pciel,tau;
double a;
def_gains;

if(parametr.bolo[fen-1].bolo_diviseur)		//  BEBO normale ou MLPA
	{
	I = (double)tri / pt_micA(fen);						//	I en A
	V= (double) carr / pt_micV(fen);					//	V en Volts
	if(I>0.0000001)		R=V/I;	else	R=0;				//	R  en 
	if(R>=1e6) ecritD(fen,b_res,"%7.3fM %6.3fnA %7.3fmV",R*1e-6,I*1e3,V*1e-3);// R  en M I en nA et V en mV
	else	 ecritD(fen,b_res,"%6.2fK %6.3fnA %7.3fmV",R*1e-3,I*1e3,V*1e-3);// R  en K   I en nA et V en mV
	V=V-xbolbrut(fen-1);	//  corrige du dsquilibre  en  V
	}
else						//  pour carte BEBO modifie (mesure temperature)
	{
	I = 1e-3 * (double)carr * 2441. / parametr.bolo[fen-1].bolo_capa;	//	I en A
	V=xbolbrut(fen-1);							//	V en Volts
	if(I>0.0000001)		R=V/I;	else	R=0;				//	R  en 
	if(R>=1e3) ecritD(fen,b_res,"%7.3fK %6.3fnA %7.3fmV",R*1e-3,I*1e3,V*1e-3);// R  en K I en nA et V en mV
	else	 ecritD(fen,b_res,"%6.2f %6.3fnA %7.3fmV",R,I*1e3,V*1e-3);	// R  en    I en nA et V en mV
	}


if(!flag) return;

if(!fenetre(fenetre_mesures_bolo)) nouveauT(fenetre_mesures_bolo,mesures_bolo_id,"mesures bolos");

	//****************  tension corrige du dsquilibre     *******************

if(I<0.000001) return;
if(V<-1000000) return;
if(V>1000000) return;


Pelec=V*I;		// pW

//	-1-	loi de reponse thermique des bolos  avec R en ohms et T en Kelvin  coef 0,1,2		//
//													//
// 	T =  coef2  *   (   ln (  R / coef1) **  ( -1 / coef0 )						//

a=1;	if( (R>0) && (c(1) >0.01) )		a= log ( R / c(1) );
T=0;	if( (a>0) && (c(0)>0.01) )		T= c(2) * pow( a , -1 / c(0) );

//	-2-	fuite thermique du bolo   coef 3,4							//
//													//
//	Ptot =  coef3  *  ( (10*Tb) ** coef4    -    (10*Tcryo)  **  coef4 )				//
Tcryo=0.1;

Ptot=0;	if( (c(4)>0.01) && (T>0.01) )	Ptot = c(3) * ( pow(10.*T,c(4)) - pow(10.*Tcryo,c(4)) );

//	-3-	calcul empirique de Pciel et de  tau	  coef  5,6					//
//													//
//		Pciel	=	coef5  - V * I   		coef5= I * Ai (tables xavier)		//
//		tau	=	- ln ( 1 +  Pciel / coef6 )	coef6= I * Bi (tables xavier)		//

Pciel = 0;  if( c(5)>Pelec)	Pciel = c(5) - Pelec;
a=1;	if( c(6) >0.1 )		a =  1 - Pciel / c(6) ;
tau=0;	if( a>0 )		tau =  - log ( a );



ecritT(fenetre_mesures_bolo,fin_f,"%d %s :",fen,parametr.bolo[fen-1].bolo_nom);

//ecritT(fenetre_mesures_bolo,fin_f,"%s (b%d) :"/* bebo=%d  num=%d  gain_pa=%d   coef0=%g  coef1=%g  coef2=%g */,
//		parametr.bolo_nom[fen-1],fen,parametr.bolo[fen-1].bolo_bebo,parametr.bolo[fen-1].bolo_num,parametr.bolo_gain[fen-1]
//		,parametr.coef[fen-1][0],parametr.coef[fen-1][1],parametr.coef[fen-1][2]);


ecritT(fenetre_mesures_bolo,fin_f," R=%7.3fM  I=%6.3fnA  V=%7.3fmV   Pelec=%5.1fpW",R*1e-6,I*1e3,V*1e-3,Pelec);

if(T>0.01) ecritT(fenetre_mesures_bolo,fin_f,"  T=%6.1fmK  ", T*1e3);

if( Ptot>0.1) ecritT(fenetre_mesures_bolo,fin_f," Ptot=%5.1fpW   Pciel=%5.1fpW   tau=%5.3f  ",Ptot,Pciel,tau);


//ecritT(fenetre_mesures_bolo,fin_f,": C=%g  ptmic=%g\n",capa(fen),pt_micA(fen));

ecritT(fenetre_mesures_bolo,fin_f,"\n");
}