#include "diabolo.h"
#include "bolo.h"
#include "synchro.h"
#include "fichier.h"
#include "trace.h"
#include "alarme.h"
#include "controle.h"
#include "tm.h"

//----------------------------------  fenetre : synchro  -----------------------------------
void appel_detection_synchrone(void);


double	synchro_periode=0;			//  valeur courante mesure de la periode en nb de pts de mesure
int select_synchro=0;
int sy_flag[nb_sync];
double	sy_per;			// nombre de points de mesure dans une periode
int force_scan,force_subscan;

// ------------------  programme synchro : traite les synchro et appelle trace_DS avec argument ds_debut ou ds_suite

void exec_synchro(int fen,int item,double valeur,...) 
{
int j;

switch(item)
	{
	case ouverture	:	
	case sy_select	:	
	case sy_fixe	:	
	case sy_fixe+1000 :
	case sy_force_scan :
	case sy_force_subscan :
		
		force_scan=litD(fenetre_synchro,sy_force_scan,0L);
		force_subscan=litD(fenetre_synchro,sy_force_subscan,0L);
		
		select_synchro=litD(fenetre_synchro,sy_select,0L);	
		if(select_synchro)	gg->trace_ouvert=gg->trace_ouvert | 32 ;
		else			gg->trace_ouvert=gg->trace_ouvert & (255-32); 		// enleve le 32
		synchro_periode=litD(fenetre_synchro,sy_fixe,0L);
		if(fenetre(fenetre_trace_DS))  exec_trace_DS(fenetre_trace_DS,ds_choix_DS,0);
		break;	


	case caseferme	:	cache(fen);stop_exec(fen);	break;

                 
	case 100	:	//  appell  chaque point de mesure avec err dans valeur
   		if(force_scan)	gg->don.sync[sync_scan]=1;
   		if(force_subscan)	gg->don.sync[sync_subscan]=1;
   		
   		if(select_synchro)  appel_detection_synchrone();	
     				
		for(j=0;j<nb_sync;j++)		 // eclaire tous les voyants  
			{
			if(gg->don.sync[j])
				{
				if(!sy_flag[j]) {
						sy_flag[j]=1;
						ecritD(fenetre_synchro,sy_voyant+j,j+1);
						ecritD(fenetre_controle,con_voyant+j,j+1);
						}
				}
			else 
				{
				if(sy_flag[j])	{
						sy_flag[j]=0;
						ecritD(fenetre_synchro,sy_voyant+j,0);
						ecritD(fenetre_controle,con_voyant+j,0);
						}
				}    					
			}
		if( tt->signal_scan_immediat ou gg->don.sync[sync_scan] )		//  debut scan seulement si pas d'erreur synchro  
			{
			if(!gg->scan_en_cours)	
					{
					debut_scan_fich();
					gg->compte_subscan=0;
					ecritD(fenetre_controle,con_subscan,"debut scan");
					}
				
			gg->scan_en_cours=10;	// ou n'importe quoi >0
			if( (gg->don.sync[sync_subscan]) && (gg->compte_subscan<1) )
					{
					gg->compte_subscan=-gg->compte_subscan+1;
					ecritD(fenetre_controle,con_subscan,"subscan %d",gg->compte_subscan);
					}
			if( (!gg->don.sync[sync_subscan]) && (gg->compte_subscan>0) )
					{
					gg->compte_subscan=-gg->compte_subscan;
					ecritD(fenetre_controle,con_subscan,"fin (%d)",-gg->compte_subscan);
					}
			}
		else	
			{
			if( gg->compte_subscan>0) 
					{
					gg->compte_subscan=-gg->compte_subscan;
					}
			if(gg->scan_en_cours)
				{
				ecritD(fenetre_controle,con_subscan,"       "); 
				// affiche rien mais compte_subscan se rappelle la derniere valeur en negatif
				if(litD(fenetre_alarme,a_fin_scan,0)>0) 
						 {son(5);son(6);son(7);son(8);son(133);son(135);son(133);}
				}
			gg->scan_en_cours=0;
			}
		break;
				
	default : break;
	}

}


void appel_detection_synchrone(void)
{
int i;	
double x;
if(select_synchro==7)	// selection  valeur fixe
	{
	if(sy_per>=synchro_periode)
		{
		if(gg->trace_ouvert&2)	exec_trace_1_per(fenetre_trace_1_per,ds_debut,0);
		if(gg->trace_ouvert&4)	exec_trace_DS(fenetre_trace_DS,ds_debut,0);
		sy_per=1;
		}
	else
		{
		sy_per=sy_per+1;
		if(gg->trace_ouvert&2)	exec_trace_1_per(fenetre_trace_1_per,ds_suite,0);
		if(gg->trace_ouvert&4)	exec_trace_DS(fenetre_trace_DS,ds_suite,0);
		}
	}
else
	{
	i=gg->don.sync[select_synchro-1];
	if(i && !sy_flag[select_synchro-1]) 
		{
		x=1-2.*(double)i/(double)gg->reglage.horloge.nb_mesures;
		ecritD(fenetre_synchro,sy_phase,(int)(x*100));
		ecritD(fenetre_controle,con_phase,(int)(x*100));
		sy_per=sy_per+x;
//						printf("i=%d  x=%g  p=%6.2f  frequ=%g Hz\n",i,x,sy_per,1e6/(sy_per*gg->periode_echantillonage));
		ecritD(fenetre_synchro,sy_periode," p=%6.2f\r frequ=%g Hz",sy_per,1e6/(sy_per*gg->periode_echantillonage));
		ecritD(fenetre_controle,con_periode," p=%6.2f",sy_per);
		synchro_periode=sy_per;
		sy_per=1-x;
		if(gg->trace_ouvert&2)	exec_trace_1_per(fenetre_trace_1_per,ds_debut,0);
		if(gg->trace_ouvert&4)	exec_trace_DS(fenetre_trace_DS,ds_debut,0);
		}
	else 	
		{
		sy_per=sy_per+1;
		if(gg->trace_ouvert&2)	exec_trace_1_per(fenetre_trace_1_per,ds_suite,0);
		if(gg->trace_ouvert&4)	exec_trace_DS(fenetre_trace_DS,ds_suite,0);
		}
			
	}
}	
//					printf("\n");

