/*
 *	Interface de contrle de la carte PCI
 */

/* type des pointeurs pour le bus PCI */
typedef unsigned long * pointeur_PCI;

/* adresse de base de la carte PCI, dans le fichier  choix_acqui    */
//#define Adresse_base_PCI	0x81000000

/* pointeurs sur les diffrents ports de la carte */
static pointeur_PCI fifo_p	= (pointeur_PCI) (Adresse_base_PCI + 0x00);
static pointeur_PCI util_p	= (pointeur_PCI) (Adresse_base_PCI + 0x00);
static pointeur_PCI flags_p	= (pointeur_PCI) (Adresse_base_PCI + 0x04);
static pointeur_PCI reset_p	= (pointeur_PCI) (Adresse_base_PCI + 0x08);
static pointeur_PCI test_p	= (pointeur_PCI) (Adresse_base_PCI + 0x0c);
static pointeur_PCI set_util_p	= (pointeur_PCI) (Adresse_base_PCI + 0x10);

/* pseudo-fonctions pour contrler la carte */
#define read_fifo()	(*fifo_p)
#define write_util(x)	(*util_p = (x))
#define read_flags()	(*flags_p)
#define write_flags(x)	(*flags_p = (x))
#define reset_fifo()	((void) (*reset_p = 0))
#define read_test()	(*test_p)
#define write_test(x)	(*test_p = (x))
#define set_util(x)	(*set_util_p = (x))
#define wait_read(p)	{register unsigned long * q = (p);\
				while (!(*q = read_fifo())) {}}
#define fast_read(x)	{while (!((x) = read_fifo())) {}}

/* drapeaux */
#define POS_FIRST_FLAG	19
#define NB_FLAGS	7
#define FLAG_FIFO_FULL	0x00080000
#define FLAG_NFIFOEF	0x00100000
#define FLAG_NFIFOHF	0x00200000
#define FLAG_NFIFOFF	0x00400000
#define FLAG_PLEIN0	0x00800000
#define FLAG_PLEIN1	0x01000000
#define FLAG_MULTIPLEX	0x02000000

/* noms des drapeaux */
static char *flag_name[NB_FLAGS] = {"Fifo_full", "nFifoef", "nFifohf",
	"nFifoff", "Plein0", "Plein1", "Multiplex"};
