
/*======================================================================*/
/*                                                                      */
/* 		 archeops.h  :	structure de donnes            	*/
/*                                                                      */
/*======================================================================*/

#define		_archeops
#define		version_num		24


/*======================================================================*/
/*                                                                      */
/* 			historique des modifications            	*/
/*                                                                      */
/*                                                                      */
/*  VERSION 24:                                                         */
/*                                                                      */
/*	- utilise le fichier archeops.c					*/
/*	- nb_max_bolo=24  avec nb_bolo_util=18				*/
/*	- change la structure du block dilution				*/
/*									*/
/*									*/
/*									*/
/*									*/
/*======================================================================*/


/*======================================================================*/
/*  ---------------  parametres generaux de definition   -------------  */
/*======================================================================*/

#ifdef	_planck
#define	_archeops
#define _trapani
#define _sans_transputer
#endif

#ifdef	_archeops
/*#define _test_diabolo	 relecture des blocks fabriques avec diabolo	*/
#define _trapani		/*  configuration  prevue pour Trapani	*/
/*#define _kiruna		  block standard prevu pour kiruna	*/ 
#endif



/*======================================================================*/
/*  --------------	valeurs des parametres dans	-------------   */
/*  --------------	les diffrentes configurations	-------------   */
/*======================================================================*/
/*									*/
/*  configuration pour Trapani : 3 bebos  /  12 bolos			*/
/*									*/
/*  bebo1 :   voies  1    6	-->  bolo  1 a  6			*/
/*  bebo2 :   voies  9    14	-->  bolo  7  12			*/
/*									*/
/*  bebo6 :								*/
/*  	voies  41 42 43 44	=  carte simplifiee avec AMP01		*/
/*  	voies  45 et 46		= chauffage pour regulation		*/    
/*	on ecrira plus tard le stockage des donnees simplifiees		*/
/*									*/
/*									*/
/*======================================================================*/

/*	nb_per_block	doit etre divisible par 2						*/
/*	nb_max_bolo	doit etre divisible par 2 pour archeops   (impair pour diabolo ?? )	*/
/*	nb_bolo_util	doit etre divisible par 2 pour archeops   (impair pour diabolo ?? )	*/


#ifdef	_trapani
#define nb_max_bolo 		24	/*  nombre maxi de bolos 				*/
#define nb_bolo_util 		18	/*  nombre de bolos rellement transmis			*/
#define	nb_per_block		36	/*  nombre de periodes entieres dans un block		*/
#define	nb_max_mes_per		88	/*  nb de points maxi dans une periode complete		*/
#define	nb_photo_diodes		46	/*  nb de canaux de mesure du senseur stellaire		*/
#endif

#ifdef	_kiruna
#define nb_max_bolo 		36	/*  nombre maxi de bolos 				*/
#define nb_bolo_util 		32	/*  nombre de bolos rellement transmis			*/
#define	nb_per_block		36	/*  nombre de periodes entieres dans un block		*/
#define	nb_max_mes_per		88	/*  nb de points maxi dans une periode complete		*/
#define	nb_photo_diodes		46	/*  nb de canaux de mesure du senseur stellaire		*/
#endif


#ifdef	_diabolo
#define nb_max_bolo 		9	/*  nombre maxi de bolos 				*/
#define nb_bolo_util 		9	/*  nombre de bolos rellement transmis			*/
#define	nb_per_block		20	/*  nombre de periodes entieres dans un block		*/
#define	nb_max_mes_per		128	/*  nb de points maxi dans une periode complete		*/
#define	nb_photo_diodes		0	/*  nb de canaux de mesure du senseur stellaire		*/
#endif

#ifdef	_test_diabolo
#define nb_max_bolo 		9	/*  nombre maxi de bolos 				*/
#define nb_bolo_util 		9	/*  nombre de bolos rellement transmis			*/
#define	nb_per_block		20	/*  nombre de periodes entieres dans un block		*/
#define	nb_max_mes_per		128	/*  nb de points maxi dans une periode complete		*/
#define	nb_photo_diodes		0	/*  nb de canaux de mesure du senseur stellaire		*/
#endif


#ifdef	_sans_transputer
#define nb_byte_mot		5	/*  nombre d'octets dans un mot d'acquisition planck	*/
#else
#define nb_byte_mot		8	/*  nombre d'octets dans un mot d'acquisition archeops	*/
#endif

#define nb_sync			6	/*  nombre de signaux de synchro			*/
#define	nb_element_catalog	256	/* nombre d'lments catalog par reponse enregistreur	*/


#ifdef	transmet_data_brute
#define		taille_maxi_block_archeops	sizeof(block_type_data_brute)
#else					/* 	le plus gros des diffrents blocks de tlmesure*/
#define		taille_maxi_block_archeops	sizeof(block_type_bolo)
#endif

#define		nombre_de_regul		4
#define		nombre_de_voies		6
#define 	nb_type_blocks		20	/*  nombre de type de blocks (multiple de 4)	*/


/*======================================================================*/
/*  -------     codes  de  controle  pour  la  transmission    -----    */
/*=======================   tlcommande      ==========================*/
/*======================================================================*/


/*   --------------   codes de reconnaissance des paquets de tlcommande	--------------   */   

#define		debut_telecommande		0x23456789
#define		fin_telecommande		0x98765432

/*   ------------ codes de direction des commandes envoyes a l'EPLD Archeops	--------------   */   

#define 	tc_dir_transputer		1
#define 	tc_dir_reset_epld		3

/*  -------------  codes  des  prefix des  telecommandes traits le transputer	--------------   */

#define		tc_horloge			255	/* (-1)	*/
#define		tc_cadence1			128
#define		tc_cadence2			129
#define		tc_cadence3			130
#define		tc_regul			251	/* (-5)	*/
#define		tc_switch_dil			250
#define		tc_dac_dil			249

/*======================================================================*/
/*	telecommande reduite  sur 18 bit				*/
/*======================================================================*/

/*______________________________________________________________________________________________*/
/*	1er mot	:	code de debut de telecommande reduite					*/
#define		tc_reduite			248	
/*______________________________________________________________________________________________*/
/*	2eme mot:	4bit:	16 codes  de direction  tc2					*/
enum{tc2_reset_epld,tc2_bolo_dacV,tc2_bolo_dacI,tc2_bolo_dacT
	,tc2_bolo_dacL,tc2_bolo_gain,tc2_bolo_voie,tc2_horloge
	,tc2_regul,tc2_auto_bolo,tc2_auto_dilu,tc2_dilution};			/* 11 codes: reste 5 disponibles*/


/*______________________________________________________________________________________________*/
/*	3eme mot:	6bit:									*/

/*	code2=dac-gain-voie  	:	numero de bolo						*/

/*	code2=tc2_horloge	:								*/
/*		soit un code defini								*/
/*		soit le code tc3_vitesse+i avec i=0.. nb_type_block				*/
enum{tc3_periode,tc3_nb_mesures,tc3_temp_mort,tc3_flag,tc3_vitesse};
#define	tc3_suite	tc3_vitesse+nb_type_block


/*	code2=tc2_regul	:									*/


/*	code2=tc2_auto_bolo	:						*/


/*	code2=tc2_auto_dilu	:						*/
/* 	les valeurs des parametres d'auto_dilu ne depassent pas 128 		*/


/*	code2=tc2_dilution	:						*/


/*______________________________________________________________________________*/
/*	4eme mot:	8bit:	valeur a ecrire			*/		


/*======================================================================*/
/*  -------     codes  de  controle  pour  la  transmission    -----    */
/*=========================   tlmesure    ============================*/
/*======================================================================*/

/*   -------   codes de reconnaissance des paquets de tlmesure        */   

#define		debut_block_mesure		0x45627491	
#define		fin_block_mesure		0x83260432	





/*======================================================================*/
/*  ------------------------------------------------------------------  */
/*  ---------  	Les  formats  des  blocks  type   ARCHEOPS   	-------	*/
/*  ------------------------------------------------------------------  */
/*======================================================================*/



/*==============================================================================================*/

/*	Le tableau est lut dans le desordre par le mac en lecture de la carte pci :		*/

/*	Les entiers long sont ecrits tels quels							*/
/*	Les short sont ecrits permut 2 a 2 par le tansputer					*/
/*	Les tables char sont ecrits permut 4 / 4 par le transputer				*/
/*	A la lecture dans le mac, tout est bon							*/


/*  ---------  	 structures N 0 :   parametres de mesure des bolometres        -------------	*/
/*  -----------------------------------------------------------------------------------------	*/

typedef struct	
	{
	char		bolo_nom[32];		/*  le nom de chaque bolometre			*/
	long		bolo_code_util;		/*  le code d'utilisation du bolo		*/
	long		bolo_bebo;		/*  le type d'acquisition:  0 pour MLPA 10 pour BEBODIFF */
	long		bolo_num;		/*  l'adresse hard du bolo			*/
	long		bolo_gain;		/*  le gain du preampli				*/
	long		bolo_capa;		/*  la valeur capa du modulateur		*/
	long 		bolo_diviseur;		/*  le diviseur de la compensation		*/
	long	  	coef[7];		/*  les coef pour le calcul de la temprature	*/
	}
	param_un_bolo;
/* code_util des bolos  */
enum{bolo_hors_service,bolo_normal_transmis,bolo_normal_non_transmis,bolo_thermo_simplifie};

	
typedef struct		/*  		table des parametres de mesure bolometre 		*/
			/*	cette table ne change pas (en principe) en cours de mesure	*/
	{
	long		numero_version;			/*  numero de version du header archeops.h	*/
	long		n_max_bolo;			/*  nombre maxi de bolos  (divisible par 4)	*/
	long		n_per_block;			/*  nombre de periodes entieres dans un block	*/
	long		n_max_mes_per;			/*  nb de points maxi dans une periode complete	*/

	long		nb_bolo;			/*  nombre de bolometres effectivement lut	*/
	param_un_bolo	bolo[nb_max_bolo];
	}
	param_bolo;
	
	
	
	
/*	
	long		bolo_code_util[nb_max_bolo];	
	char		bolo_nom[nb_max_bolo][32];	

	long		bolo_bebo[nb_max_bolo];		
	long		bolo_num[nb_max_bolo];		
	long		bolo_gain[nb_max_bolo];		

	long		bolo_capa[nb_max_bolo];		
	long 		bolo_diviseur[nb_max_bolo];	
	
	long	  	coef[nb_max_bolo][7];		

	long		presence_bebo;			
	}
	param_bolo;
*/

typedef struct				/*	La structure de transfert transputer vers mac	*/  
	{
	long		debut;		/*	code de reconnaissance de debut de block	*/
	long		code1;		/*	code1 du block					*/
	long		code2;		/*	code2 du block					*/

	param_bolo	param;		/*	les parametres de mesure des bolometres		*/

	long		fin;		/* 	code de reconnaissance de fin de block		*/
	}
	block_type_param;			
	



/*  -------------------   structures N 1 :   journal de bord        ---------------------	*/
/*  -----------------------------------------------------------------------------------------	*/
#define long_page	10
typedef struct				  
	{
	long		code2;		/* 	code de la ligne du journal			*/
					/* 	code idem code2 debut de block : 		*/
					/*  	contient un code de commande			*/
					/*	et le numero du block lors de la tlcommande	*/
	char		mot[8];		/* 	contenu de la ligne du  journal			*/
	}
	ligne_journal;			


typedef struct				  
	{
	long		debut;		/*	code de reconnaissance de debut de block	*/
	long		code1;		/*	code1 du block					*/
	long		code2;		/*	code2 du block					*/

	ligne_journal	jj[long_page];	/*	block de 10 lignes de journal			*/

	long		fin;		/* 	code de reconnaissance de fin de block		*/
	}
	block_type_journal;			
	

/*  ---------   structures N 2 :  reglage_bolo , regul etc..   --------	*/
/*  ------------------------------------------------------------------------------------------	*/
#define	bol_micro_volt(val,gain)	((1e7*(double)val)/(65536.*gain))
/*  avec  gain = param.bolo_gain[bolo]*gain_ampli(reglage.bolo[bolo])				*/
		

/* gains 0 .. 15 pour MLPA  ///   gain 16..19  pour BEBO   ///   gain 20..22  pour BEDIF	*/		
#define	def_gains	double gains_reels[32]={1,2,4,8,10,20,40,80,100,200,400,800,1000,2000,4000,8000,0.5,2.5,10,50,0.93,3.777,18.974};
		/*			gain bediff    10->9.3    40->37.77     200->189.74		*/


/*  les definitions suivantes s'appliquent a une variable de type    reglage.bolo[bol]		*/
#define		gainbrut(aa)	((char)(((aa).mot1&0x1f)))		
#define		gain_ampli(aa)	gains_reels[gainbrut(aa)]		
#define		phase(aa)	((char)(((aa).mot1&0x60)>>5))		
#define		comm(aa)	((char)(((aa).mot1&0x80)>>7))		
#define		dac_V(aa)	((int)(((aa).mot1&0xfff00)>>8)	)	
#define		dac_I(aa)	((int)(((aa).mot1&0xfff00000)>>20))		

#define		voie(aa)	((char)(((aa).mot2&0xff)))		
#define		dac_T(aa)	((int)(((aa).mot2&0xfff00)>>8))		
#define		dac_L(aa)	((int)(((aa).mot2&0xfff00000)>>20))		

/*
#define		bolo_mot1(dacV,dacI,gainbrut,phase,comm)	((gainbrut)&0x1f) | (((phase)&3)<<5) | (((comm)&1)<<7) | (((dacV)&0xfff)<<8) | (((dacI)&0xfff)<<20) 
#define		bolo_mot2(dacT,dacL,voie)			((voie)&0xff) 	  | (((dacT)&0xfff)<<8) | (((dacL)&0xfff)<<20)
*/

#define		bolo_mot1(dacV,dacI,gainbrut,phase,comm)	(((long)(gainbrut))&0x1f) | ((((long)(phase))&3)<<5) | ((((long)(comm))&1)<<7) | ((((long)(dacV))&0xfff)<<8) | ((((long)(dacI))&0xfff)<<20) 
#define		bolo_mot2(dacT,dacL,voie)			(((long)(voie))&0xff) 	  | ((((long)(dacT))&0xfff)<<8) | ((((long)(dacL))&0xfff)<<20)


typedef struct	
	{
	long	mot1;		/*  dac1 = mot[11..0]; dac2=mot1[23..12]	*/
				/*  gain = mot1[27..24]; phase = mot1[31..28];	*/
	long	mot2;		/*  dac3 = mot[11..0]; dac4=mot1[23..12]	*/
				/*  voie pour reglages auto  = mot2[31..24];	*/
	}
	reglage_un_bolo;



#ifdef programme	/***********   structure normale pour le mac   ****************/

typedef struct	
	{
	char	periode;
	char	nb_mesures;
	char	temp_mort;
	char	flag;
	}
	horloge;

typedef struct
	{
	char	mode;			/*   on_off et deglitch				*/
	char	num_bolo;		/*   numero du bolo utilis,	*/
	char	voie_chauf;		/*   la voie de sortie chauffage		*/
	char	prop;			/*   zero dans prop -> chauffage=0;		*/
	char	integ;
	char 	deriv;
	short	chauffage;		/* 	valeur effective du chauffage		*/	
	}
	regul_bolo;			/*  longueur 2 entiers long			*/

typedef struct
	{
	char	mode;
	char	gain;
	char	courant;
	char	delai;
	}
	auto_bolo;			/*  longueur 1 entiers long			*/

typedef struct
	{
	char	vanne;
	char	helium;
	char	chauffage;
	char	piles;
	char	transmission;
	char	temps_max_vanne;
	char	xx7;
	char	xx8;
	}
	auto_dilu;			/*  longueur 1 entiers long		*/



#else		/***********  structure swappe pour le transputer   ****************/

typedef struct	
	{
	char	flag;
	char	temp_mort;
	char	nb_mesures;
	char	periode;
	}
	horloge;
	

typedef struct
	{
	char	prop;			/*   zero dans prop -> chauffage=0;		*/
	char	voie_chauf;		/*   la voie de sortie chauffage		*/
	char	num_bolo;		/*   numero du bolo utilis,	*/
	char	mode;			/*   on_off et deglitch				*/
	short	chauffage;		/* 	valeur effective du chauffage		*/	
	char 	deriv;
	char	integ;
	}
	regul_bolo;			/*  longueur 2 entiers long		*/


typedef struct
	{
	char	delai;
	char	courant;
	char	gain;
	char	mode;
	}
	auto_bolo;			/*  longueur 1 entiers long		*/

typedef struct
	{
	char	piles;
	char	chauffage;
	char	helium;			/* periode de mesure		*/
	char	vanne;		
	char	xx8;
	char	xx7;
	char	temps_max_vanne;
	char	transmission;
	}
	auto_dilu;			/*  longueur 1 entiers long		*/


#endif		/***********   fin des structures swappes       ****************/

enum{regul_stop,regul_chauffage_null,regul_sans_deglitch,regul_avec_deglitch};

#define bit_piles_5V	1
#define bit_piles_15V	2
#define bit_piles_auto	4

enum{vanne_rien,vanne_ferme,vanne_ouvre,vanne_auto_pression,vanne_auto_pression_piles,vanne_auto_pression_piles_temps};
enum{trans_rien,trans_normal,trans_rapide,trans_lent};


typedef struct							/*  long en mot de 32 bit   	*/
	{
	horloge			horloge;			/*			1	*/
	char			vitesse[nb_type_blocks];	/*			5	*/
	reglage_un_bolo		bolo[nb_max_bolo]; 		/*	18 * 2	= 	36	*/
	auto_bolo		autom[nombre_de_voies];		/*	6  * 1		6	*/								
	regul_bolo		regul[nombre_de_regul];		/*	4  * 2	=	8	*/									
	auto_dilu		dilu;				/*			2	*/
	}
	reglage_bolo;						/*	total 58		*/


typedef struct				  
	{
	long		debut;		/*	code de reconnaissance de debut de block	*/
	long		code1;		/*	code1 du block					*/
	long		code2;		/*	code2 du block					*/
	reglage_bolo	reglage;											
	long		fin;		/* 	code de reconnaissance de fin de block		*/
	}
	block_type_reglage;			
	
/*  ---------------------   structures N 3 :    etat de la dilution	-----------------------	*/
/*  -------------------------------------------------------------------------------------------	*/
typedef struct				  
	{
	long		debut;		/*	code de reconnaissance de debut de block	*/
	long		code1;		/*	code1 du block					*/
	long		code2;		/*	code2 du block					*/
/*	long		data_dil[50];	 data brutes de la dilution				*/
	long		switch_dil;
	long		ADC_dil[48];	/*	la lecture des 48 ADC de la carte DIL		*/
	long		DAC_dil[4];	/*	les 4 dac de la carte dilution			*/
	long		DAC_sst[4];	/*	les 4 dac de la carte sst			*/
	long		gyro_dil[3][nb_per_block*2];	/* les gyros a supprimer		*/
	long		fin;		/* 	code de reconnaissance de fin de block		*/
	}
	block_type_dilution;			


/*      signification des bit lus dans switch_dil	*/
#define	switch_EVF		0x00000080	/*	contact fin de course vanne fermee	*/
#define	switch_EVO		0x00000040	/*	contact fin de course vanne ouverte	*/

/* les bit suivants sont envoys par telecommande et relus dans switch_dil	*/
#define	switch_helium		0x00200000	/*  13: commande sond niveau helium	*/
#define switch_pile_par_5	0x00100000	/*  12: mise en parallele des piles pour le 5V	*/
#define switch_pile_par_15	0x00080000	/*  11: mise en parallele des piles pour le 15V	*/
#define vanne_EVB		0x00008000	/*  7: commande vanne brooks	*/
#define vanne_EVO		0x00010000	/*  8: commande vanne EVO	*/
#define vanne_EVV		0x00020000	/*  9: commande vanne EVV	*/
#define vanne_EVF		0x00040000	/*  10: commande vanne EVF	*/
#define chauffage1		0x00004000	/*  6: chauffage 1	*/
#define chauffage2		0x00002000	/*  6: chauffage 1	*/
#define chauffage3		0x00001000	/*  6: chauffage 1	*/
#define chauffage4		0x00000800	/*  6: chauffage 1	*/
#define chauffage5		0x00000400	/*  6: chauffage 1	*/
#define chauffage6		0x00000200	/*  6: chauffage 1	*/
#define chauffage7		0x00000100	/*  0: chauffage 7	*/

/*  position des mesures sur les multiplexeurs		*/

enum{
/* multiplex11..18:*/	mul11_	,mul12_	,p_haut	,p_memb	,t_h1	,t_h4	,t_h3	,t_h2	
/* multiplex21..28:*/,	mul21_	,mul22	,p_charb,p_R4	,mul25_	,p_C3	,p_R3	,mul28	
/* multiplex31..38:*/,	mul31_	,p_C4	,p_air	,t_a3	,t_b4	,t_b1	,t_b2	,t_a2	
/* multiplex41..48:*/,	t_b3	,d_4He	,RP_He	,mul44	,d_3He	,j_he3	,j_he7	,j_he4	
/* multiplex51..58:*/,	j_he5	,j_he1	,j_he8	,j_he2	,j_he6	,pirani	,mul57	,mul58	
/* multiplex61..68:*/,	p_m18B	,p_10B	,p_m18D	,mul64	,p_p18B	,p_10T	,p_Ch	,p_p18D		
	};
enum{t_a1,t_a4};	/* en attendant de trouver leurs places	*/
/* reste libres :  mul  11 - 12 - 21 - 22 - 25 - 28 - 31 - 44 - 57 - 58 - 64	*/



/*  ---------------------   structures N 4 :     gps           -------------------------------	*/
/*  -------------------------------------------------------------------------------------------	*/

typedef struct				  
	{
	long		debut;		/*	code de reconnaissance de debut de block	*/
	long		code1;		/*	code1 du block					*/
	long		code2;		/*	code2 du block					*/

	char		gps[80];	/*      les donnes GPS (une chaine maxi 80 cara)	*/

	long		fin;		/* 	code de reconnaissance de fin de block		*/
	}
	block_type_gps;			
	


/*  ---------------------   structures N 5 :   tous les bolos 1 periode     	---------------	*/
/*  -------------------------------------------------------------------------------------------	*/
typedef struct				  
	{
	long		debut;		/*	code de reconnaissance de debut de block	*/
	long		code1;		/*	code1 du block					*/
	long		code2;		/*	code2 du block					*/
	
	short 		bol_per[nb_max_bolo][nb_max_mes_per];		

	long		fin;		/* 	code de reconnaissance de fin de block		*/
	}
	block_type_une_periode;			

/*  ----------------   structures N 6 :  signals de synchro (pour test au sol)	---------------	*/
/*  -------------------------------------------------------------------------------------------	*/
typedef struct				  
	{
	long		debut;		/*	code de reconnaissance de debut de block	*/
	long		code1;		/*	code1 du block					*/
	long		code2;		/*	code2 du block					*/
	char		synchro[nb_sync][nb_per_block*2];	

	long		fin;		/* 	code de reconnaissance de fin de block		*/
	}
	block_type_synchro_sol;			

/*  ---------------------   structures N 7 : block de donnes de pointage sol      -----------	*/
/*  -------------------------------------------------------------------------------------------	*/
typedef struct	  
	{
	long		debut;		/*	code de reconnaissance de debut de block	*/
	long		code1;		/*	code1 du block					*/
	long		code2;		/*	code2 du block					*/
	char		comment[1024];
	long		fin;		/* 	code de reconnaissance de fin de block		*/
	}
	block_type_pointage_sol;			



/*  -------------   structures N 8 :   donnes brutes des bolometres    ----------------------	*/
/*  -------------------------------------------------------------------------------------------	*/
typedef struct				  
	{
	long		debut;		/*	code de reconnaissance de debut de block	*/
	long		code1;		/*	code1 du block					*/
	long		code2;		/*	code2 du block					*/
					/*	pour chaque bolo, un vecteur 72 points		*/
	long		data_bolo[nb_max_bolo][nb_per_block*2];	
					/*	data D.S.	(en mots de 32 bits)		*/
	long		fin;		/* 	code de reconnaissance de fin de block		*/
	}
	block_type_bolo;			

/*  ---------------------   structures N 9 :   donnes des gyroscopes et du magntometre	*/
/*  -----------------------------------------------------------------------------------------	*/
typedef struct				  
	{
	long		debut;		/*	code de reconnaissance de debut de block	*/
	long		code1;		/*	code1 du block					*/
	long		code2;		/*	code2 du block					*/
					/* chaque gyro: un vecteur tde 72 valeurs		*/
	long		gyros[3][nb_per_block*2];
	long		magneto[3];	/*	1 bit par echantillonage soit 3*32bit>72	*/
	long		fin;		/* 	code de reconnaissance de fin de block		*/
	}
	block_type_gyro;			

/*  ---------------------   structures N 10 :   donnes senseur stellaire	  -----------	*/
/*  -----------------------------------------------------------------------------------------	*/
typedef struct				  
	{
	long		debut;		/*	code de reconnaissance de debut de block	*/
	long		code1;		/*	code1 du block					*/
	long		code2;		/*	code2 du block					*/
	long		sst[nb_per_block*2][18];
					/* chaque mesure: un paquet de 18 mots de 32 bits	*/
	long		fin;		/* 	code de reconnaissance de fin de block		*/
	}
	block_type_sst;			

/*  ---------------------   structures N 11 :    rien		          -----------		*/
/*  -----------------------------------------------------------------------------------------	*/
typedef struct				  
	{
	long		debut;		/*	code de reconnaissance de debut de block	*/
	long		code1;		/*	code1 du block					*/
	long		code2;		/*	code2 du block					*/
	long		fin;		/* 	code de reconnaissance de fin de block		*/
	}
	block_type11;			

/*  ---------------------   structures N 12 :  data bolo apres compression sur 7 bit	 ------	*/
/*  -------------------------------------------------------------------------------------------	*/
typedef struct				  
	{
	long		debut;		/*	code de reconnaissance de debut de block	*/
	long		code1;		/*	code1 du block					*/
	long		code2;		/*	code2 du block					*/
					/*  	nombre de mots = nb valeurs/4 +1		*/
					/*	pour chaque bolo, un vecteur  19 mots		*/
	long		data_bolo[nb_bolo_util][ (nb_per_block/2) +1 ];

	long		fin;		/* 	code de reconnaissance de fin de block		*/
	}
	block_type_bolo_comprime;			

/*  ---------------------   structures N 13 :    block_type_gyro_comprime	-----------	*/
/*  -----------------------------------------------------------------------------------------	*/
typedef struct				  
	{
	long		debut;		/*	code de reconnaissance de debut de block	*/
	long		code1;		/*	code1 du block					*/
	long		code2;		/*	code2 du block					*/
					/*  	nombre de mots = nb valeurs/4 +1		*/
	long		gyro[3][ (nb_per_block/2) +1 ];
	long		fin;		/* 	code de reconnaissance de fin de block		*/
	}
	block_type_gyro_comprime;			

/*  ---------------------   structures N 14 :    block_type_sst_comprime	-----------	*/
/*  -----------------------------------------------------------------------------------------	*/
typedef struct				  
	{
	long		debut;		/*	code de reconnaissance de debut de block	*/
	long		code1;		/*	code1 du block					*/
	long		code2;		/*	code2 du block					*/
					/*	pour chaque diode, un vecteur  11 mots		*/
	long		sst[nb_photo_diodes] [(nb_per_block*2/7) +1 ];
	long		fin;		/* 	code de reconnaissance de fin de block		*/
	}
	block_type_sst_comprime;			



/*  ---------------------   structures N 15 : catalog_flash      -------	*/
/*  -------------------------------------------------------------------------------------------	*/

typedef struct	  			/*	etat de l'enregistreur				*/
	{
	long		nb_total_catalog;
	long		memoire_libre;
	long		nb_block_erreur;
	}status_flash;

typedef struct	  
	{
	long		debut;		/*	code de reconnaissance de debut de block	*/
	long		code1;		/*	code1 du block					*/
	long		code2;		/*	code2 du block					*/
	
	long		commande;	/*	la commande a laquelle ce catalog repond	*/
	status_flash	status;		/*	etat de l'enregistreur				*/
	long		nombre;		/*							*/
	long		code[nb_element_catalog];	/* code type et numero			*/
	long		fin;		/* 	code de reconnaissance de fin de block		*/
	}
	block_type_catalog_flash;			


/*  ---------------------   structures N 16 :    cmd_flash		    -----------		*/
/*  -----------------------------------------------------------------------------------------	*/
typedef struct				  
	{
	long		debut;		/*	code de reconnaissance de debut de block	*/
	long		code1;		/*	code1 du block					*/
	long		code2;		/*	code2 du block					*/
	long		commande;	/*	type de commande a l'enregistreur flash		*/
	long		fin;		/* 	code de reconnaissance de fin de block		*/
	}
	block_type_cmd_flash;			

enum	{flash_catalog_auto,flash_catalog_debut,flash_catalog_fin,flash_catalog_precedent,flash_catalog_suivant
		,flash_efface_tout1,flash_efface_tout2,flash_efface_tout3
		,flash_efface_util1,flash_efface_util2,flash_efface_util3};


/*  ---------------------   structures N 17 : block brut de donnes ctb pour test      -------	*/
/*  -------------------------------------------------------------------------------------------	*/
typedef struct	  
	{
	long		debut;		/*	code de reconnaissance de debut de block	*/
	long		code1;		/*	code1 du block					*/
	long		code2;		/*	code2 du block					*/
#ifdef	transmet_data_brute
	char		data[nb_per_block*nb_max_mes_per*nb_byte_mot];
#endif
	long		fin;		/* 	code de reconnaissance de fin de block		*/
	}
	block_type_data_brute;			

/*  ---------------------   structures N 18 : block  vide pour l'instant	      -------	*/
/*  -------------------------------------------------------------------------------------------	*/
typedef struct	  
	{
	long		debut;		/*	code de reconnaissance de debut de block	*/
	long		code1;		/*	code1 du block					*/
	long		code2;		/*	code2 du block					*/
	long		fin;		/* 	code de reconnaissance de fin de block		*/
	}
	block_type_18;			

/*  ---------------------   structures N 19 : block  vide pour l'instant	      -------	*/
/*  -------------------------------------------------------------------------------------------	*/
typedef struct	  
	{
	long		debut;		/*	code de reconnaissance de debut de block	*/
	long		code1;		/*	code1 du block					*/
	long		code2;		/*	code2 du block					*/
	long		fin;		/* 	code de reconnaissance de fin de block		*/
	}
	block_type_19;			



/*  ---------   block  modele  (plus gros que tous les autres pour reservation memoire)   ----  */
/*  -----------------------------------------------------------------------------------------	*/

typedef struct				/*	La structure de transfert transputer vers mac	*/  
	{
	long		debut;		/*	code de reconnaissance de debut de block	*/
	long		code1;		/*	code1 du block					*/
	long		code2;		/*	code2 du block					*/
	long		mot[(taille_maxi_block_archeops)/4];
	long		fin;		/* code de reconnaissance de fin de block		*/
	}
	block_type_modele;			





/*==============================================================================================*/
/*==============================================================================================*/
/*  --------------  dfinitions permettant de travailler sur les blocks Archeops   -----------  */
/*==============================================================================================*/
/*==============================================================================================*/



enum	{block_param,block_journal,block_reglage,block_dilution,
	block_gps,block_une_periode,block_synchro_sol,block_pointage_sol,
	block_bolo,block_gyro,block_sst,block_11,
	block_bolo_comprime,block_gyro_comprime,block_sst_comprime,block_catalog_flash,
	block_cmd_flash,block_data_brute,block_18,block_19};


#define	def_nom_block	char nom_block[nb_type_blocks][32]={"block_param","block_journal","block_reglage","block_dilution",\
					"block_gps","block_une_periode","block_synchro_sol","block_pointage_sol",\
					"block_bolo","block_gyro","block_sst","block_11",\
					"block_bolo_comprime","block_gyro_comprime","block_sst_comprime","block_catalog_flash",\
					"block_cmd_flash","block_data_brute","",""};


#define	def_long_block	int long_block[nb_type_blocks]={sizeof(block_type_param),sizeof(block_type_journal),sizeof(block_type_reglage),sizeof(block_type_dilution),\
					sizeof(block_type_gps),sizeof(block_type_une_periode),sizeof(block_type_synchro_sol),sizeof(block_type_pointage_sol),\
					sizeof(block_type_bolo),sizeof(block_type_gyro),sizeof(block_type_sst),sizeof(block_type11),\
					sizeof(block_type_bolo_comprime),sizeof(block_type_gyro_comprime),sizeof(block_type_sst_comprime),sizeof(block_type_catalog_flash),\
					sizeof(block_type_cmd_flash),sizeof(block_type_data_brute),sizeof(block_type_18),sizeof(block_type_19)};





/*   le code du block contient  8  bit de type							*/
/*				24 bit pour le numero du block(horloge locale)			*/
/*				12 bit pour la longueur du block  (en octet)			*/
/*				16 bit pour la somme de test de la validit du block		*/

/*  les define suivants doivent etre utiliss pour tester le type des blocks et les verifier	*/


#define longueur_block(_bk)	( (int) ((_bk)->code1>>16) 	& 0xffff )	
#define somme_block(_bk)	( (int)  (_bk)->code1		& 0xffff )

#define type_block(_bk)		( (int) ((_bk)->code2>>24)	& 0xff )
#define numero_block(_bk)	( (int)  (_bk)->code2		& 0xffffff )

/* ce define cree le mot de controle de somme des blocks et de les verifier a la reception	*/


/*==============================================================================================*/
/*==============================================================================================*/
/*  -----------------  fonctions utilitaires de gestion des blocks Archeops   ----------------  */
/*==============================================================================================*/
/*==============================================================================================*/


/* -------------------------------------------------------------------------------------------- */
/* les fonctions suivantes sont des utilitaires permettant la gestion des blocks archeops	*/
/* il faut inclure une seule fois le header archeops.h prcde de :				*/
/*			 #define utilitaires_de_block_archeops 					*/
/* -------------------------------------------------------------------------------------------- */


/* ----------------------------   prototypes des fonctions	 ------------------------------ */
/* -------------------------------------------------------------------------------------------- */


/* 	cette fonction calcule le code de somme pour le controle de parit des blocks		*/

int	calcul_somme_block(block_type_modele* blk,int longueur);





/* 	cette fonction est a apeller lors de la cration d'un block apres l'avoir rempli	*/
/*	elle permet de creer tous les mots de controle du block					*/

void	valide_block(block_type_modele* blk,int type,int block_num);



/* 	cette fonction est a apeller pour vrifier la validit d'un block			*/
/*	elle retourne 0 si le block est correct et sinon, un code d'erreur			*/
/*	la seconde fonction sort les erreurs a l'ecran						*/

int	verifie_block(block_type_modele* blk);
int	verifie_block_printf(block_type_modele* blk);

enum	{block_correct,block_type_inconnu,block_longueur_erreur,block_somme_erreur
		,block_debut_erreur,block_fin_erreur};

/* 	cette fonction transforme un char (sur 8 bit) en double avec une echelle logarythmique	*/
/*	elle est en particulier utilise pour calculer les coef de la regul			*/

double	val_double(char x);

/* 	cette fonction transforme un char (sur 8 bit) en entier long (echelle logarythmique)	*/
/*	elle est en particulier utilise pour fixer le courant sur les bolometres		*/

unsigned long	val_long(char x);

int	new_val_dac(int a,char  code); 


