#include "toisvr.h"

TOISvr::TOISvr()
{}

void TOISvr::SetDirectory(string d) {
  iter.directory = d;
  iter.fileName = "";
}

void TOISvr::SetFile(string f) {
  iter.directory = "";
  iter.fileName = f;
}
  
void TOISvr::SetTimeInterval(double tStart, double tEnd) {
  iter.tStart = tStart;
  iter.tEnd = tEnd;
}
  
void TOISvr::AddInfo(TOIKind kind, int index, bool triggering, bool interp) {
  TOIIter::info i;
  i.kind = kind; 
  i.index = index;
  i.triggering = triggering;
  i.interpolated= interp;
  iter.infos.push_back(i);
}

void TOISvr::AddInfo(TOIKind kind, bool triggering, bool interp) {
  AddInfo(kind,0,triggering,interp);
}
  
TOIIter TOISvr::DoQuery() {
  iter.Init();
  return iter;
}
