#include "diabolo.h"
#include "fichier.h"

#define  long_maxi_fich_tele  20000L

void renomme_fichier(int ncar,int numscan,char *nom_source);

extern	F_entete		*E;
extern	F_block_desc		*BD;
extern	F_block_param		*BP;

extern char *dossier_date;	// dossier date pour creer le dossier ou ranger les data telescope
extern char * nom_du_fichier;
extern char * message_sommaire;
extern char * fichiers_perdus;

//------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------
//----------------------         recherche  des  donnes  du  telescope           ----------------------
//------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------


//-------------------------------------------------------------------------------------
// -------------		      -0-    utilitaire commun        -------------------------
//-------------------------------------------------------------------------------------

//-----------------------  renomme le fichier    ----------------------------
//  *********************     renomme les fichier	*********************

//  fabrique le nouveau nom de fichier
//	ss[0] 		= 	longueur du string=29
//  ss[1..18]	=   heure et date
//  ss[19]		=	underscore
//	ss[20..29]	=	numscan et nom de la source


void renomme_fichier(int ncar,int numscan,char *nom_source)
{
char nom_pascal[50],ss[256];
Tfenetre ptf;
FSSpec file;
int i;

nom_source[30]=0;

ecritD(fenetre_fichier,f_comment,"scan numero %d   source : %s  ",numscan,nom_source);
//	printf("scan numero %d   source : %s  \n",numscan,nom_source);

if(nom_du_fichier[18]!='_') return;
if(ncar==4)	sprintf(nom_du_fichier+19,"%d-%s",numscan+10000,nom_source);
	else	sprintf(nom_du_fichier+19,"%d-%s",numscan+100000,nom_source);
nom_du_fichier[18]='_';nom_du_fichier[19]='s';nom_du_fichier[29]=0;
for(i=0;i<29;i++) if(nom_du_fichier[i]==' ') nom_du_fichier[i]='_';	// enleve les blancs
//	printf(" nouveau nom : .................. %s \n",nom_du_fichier);
strcpy(ss+1,nom_du_fichier);ss[0]=29;


if(fenetre(fichier_dia2_1))

	{
	ss[1]='a';
#ifdef  lire_les_data_telescope_IRAM
	ss[1]='t';
#endif			
	ptf=infos(fichier_dia2_1);
	
	strcpy(nom_pascal+1,ptf->titre);*nom_pascal=strlen(nom_pascal+1);
	FSMakeFSSpec(ptf->dossier.volume,ptf->dossier.dossier,(ConstStr255Param)nom_pascal,&file);
	FSpRename(&file,(ConstStr255Param)ss);
	position(fichier_dia2_1,0L);
	ecritF(fichier_dia2_1,(long)E->long_entete,E);

	if(fenetre(fichier_dia2_2))
		{
		ptf=infos(fichier_dia2_2);
		FSMakeFSSpec(ptf->dossier.volume,ptf->dossier.dossier,(ConstStr255Param)nom_pascal,&file);
		FSpRename(&file,(ConstStr255Param)ss);
		position(fichier_dia2_2,0L);
		ecritF(fichier_dia2_2,(long)E->long_entete,E);
		}
	}

if(fenetre(fichier_arch_1))

	{
	ss[1]='h';
	ptf=infos(fichier_arch_1);
	
	strcpy(nom_pascal+1,ptf->titre);*nom_pascal=strlen(nom_pascal+1);
	FSMakeFSSpec(ptf->dossier.volume,ptf->dossier.dossier,(ConstStr255Param)nom_pascal,&file);
	FSpRename(&file,(ConstStr255Param)ss);

	if(fenetre(fichier_arch_2))
		{
		ptf=infos(fichier_arch_2);
		FSMakeFSSpec(ptf->dossier.volume,ptf->dossier.dossier,(ConstStr255Param)nom_pascal,&file);
		FSpRename(&file,(ConstStr255Param)ss);
		}
	}

}


//-------------------------------------------------------------------------------------
// -------------		      -1-     r i e n       	      -------------------------
//-------------------------------------------------------------------------------------


#if (!defined (lire_les_donnees_POM2) && !defined (lire_les_noms_sources_IRAM)  && !defined (lire_le_numero_de_scan_iram) )
void lit_data_telescope() {}	

#endif

//-------------------------------------------------------------------------------------
// -------------		      -1-      P O M 2       	      -------------------------
//-------------------------------------------------------------------------------------


/*  lit sur la RS232  et sauve le commentaire si besoin   */ 

#ifdef lire_les_donnees_POM2



void ecrit_don_telescope(char *comment,int i);	// ecrit le commentaire de longueur i

#define temps_d_attente  20


void lit_data_telescope(void)
{
char comment[10000];
int i,numscan;					
i=0;
//	printf("cherche les commentaires sur RS232 : ");
while ( (i<8000) && (litRS(port_A,comment+i,finRS_cr,temps_d_attente,1)==1) )	i=strlen(comment);
if(i>9000)	erreur(" comment trop long dans fichier_telescope donnes POM2");
if(i)	{
		char ss[200];
		int j=0,k,q=0;
//		printf("lit commentaire  %dcara: ",i);
		while ( (j<i) && comment[j] )
			{
			while( (j<i) && (comment[j]<20) ) j++;
			k=0;
			while( (k<100) && (j<i) && (comment[j]>20) ) {ss[k]=comment[j];k++; j++;}				
			ss[k]=0;j++;
//			if(q<1) printf(" %s\n",ss);
			q++;
			}
		ecrit_don_telescope(comment,i);
		numscan=myatof(comment+1);	
		renomme_fichier(5,numscan,comment+7);
		}
//	printf("\n");
}



void ecrit_don_telescope(char *comment,int i)	// ecrit le commentaire de longueur i
{
i=(i/4+1)*4;
BD->n_ligne_don=i;
BD->change=10;
BD->bololut=0;
if(fenetre(fichier_dia2_1))
	{
	ecritF(fichier_dia2_1,sizeof(F_block_desc),BD);		// ecrit l'entete partielle
	ecritF(fichier_dia2_1,i,comment);					// ecrit le texte du block commentaire
	if(fenetre(fichier_dia2_2))
		{
		ecritF(fichier_dia2_2,sizeof(F_block_desc),BD);		// ecrit l'entete partielle
		ecritF(fichier_dia2_2,i,comment);					// ecrit le texte du block commentaire
		}
	}
}


#endif

//-------------------------------------------------------------------------------------
// -------------  -2-      IRAM  30m  juste le numero de scan			    ---------
//-------------------------------------------------------------------------------------

#ifdef lire_le_numero_de_scan_iram


void lit_data_telescope(void)		
{
static VDos data_telescope;
static int index=1;
static char nomfich[40];

char	ss[100];


//printf("lit_data_telescope et copie dans %s\n",nom_dossier);

litD(fenetre_fichier,f_don_tele,ss);
strcat(ss,":info");
if( (strlen(ss)>2) && (*ss!='/') )
	{
	data_telescope=cherchedossier(ss);
	if(!data_telescope.volume) {printf("erreur de dossier data telescope \n");return;}
	fixedossier(data_telescope);
	ouvrirT(0,0,"copied_last");
	}
}

#endif


//-------------------------------------------------------------------------------------
// -------------  -2-      IRAM  30m nom des sources + donnees eventuelles    ---------
//-------------------------------------------------------------------------------------




#ifdef lire_les_noms_sources_IRAM

void ouvre_et_lit(VDos dd,char * nomfich);	// bonfich est un string pascal termine par un zero
int deplace_un_fichier_telescope(VDos d1,char *nomfich);
int cherche_fich(VDos dd,char *nomfich);



void lit_data_telescope(void)	
{
VDos data_telescope;
char nomfich[40],ss[100];

data_telescope.volume=0;
//printf("lit_data_telescope dans %s  et les deplace dans ...%s \n",ss,dossier_date);

litD(fenetre_fichier,f_don_tele,ss);
if( (strlen(ss)>2) && (*ss!='/') )	data_telescope=cherchedossier(ss);
if(!data_telescope.volume) return;
//printf("lit_data_telescope dans %s  et les deplace dans ...%s \n",ss,dossier_date);

while(1)
	{
	if(!cherche_fich(data_telescope,nomfich))  return;	//  pas de fichier a lire
//	printf("je trouve le fichier telescope  %s  \n",nomfich+1);
	ouvre_et_lit(data_telescope,nomfich);
	if(deplace_un_fichier_telescope(data_telescope,nomfich)) 
		{printf("erreur dans deplace un fichier\n");return;} // return si erreur	
//	printf("je deplace le fichier %s \n",nomfich+1);
	}
}



// Cherche le premier fichier du dossier (index=1)
//  si oui, renvoie 1  et le nom du fichier dans nomfich (string pascal avec un zero a la fin)
//  si pas de fichier: renvoie 0

int cherche_fich(VDos dd,char * nomfich)
{
HFileParam	pb;
pb.ioCompletion=0L;
pb.ioFDirIndex=1;			// index commence  1   
pb.ioNamePtr=(StringPtr)nomfich;
pb.ioVRefNum=dd.volume;
pb.ioDirID=dd.dossier;
if(PBHGetFInfo( (HParmBlkPtr) &pb,0)) return(0);
//if( ( (pb.ioFlFndrInfo.fdType!='DATA') et (pb.ioFlFndrInfo.fdType!='TEXT') ) ou (*nomfich!=13) ) return(-1);
nomfich[*nomfich+1]=0;		//  nomfich est un string pascal avec zero  la fin
//printf("index=%d : un bon fichier : %s \n",index,nomfich+1);
return(1);
}



void ouvre_et_lit(VDos dd,char * nomfich)	// nomfich est un string pascal termine par un zero
{
short err;
short data;
FSSpec file;
char *buf;
char source[40];
int i;
long lg;
int numscan,subscan,alire;
int monscan;
char ss[255];

//--  recherche numscan et subscan
monscan=0;
if( (nom_du_fichier[18]=='_') && (nom_du_fichier[21]!='a') ) 	// un fichier scan en cours est ouvert
	{
	monscan=myatof(nom_du_fichier+20);
//	printf(" monscan=%d  \n",monscan);
	}

numscan=myatof(nomfich+1);
subscan=myatof(nomfich+11);


switch(nomfich[6])
	{
	case 'h' :	
			if(monscan && (monscan != numscan) ) 	subscan=3000;	
			else	{
				if(subscan!=gg->compte_fichiers_th+1) 
					{
					printf(" erreur fichier th: ancien=%d  lit %d \n",gg->compte_fichiers_th,subscan);
					sprintf(ss," -th%d",gg->compte_fichiers_th+1);ajoute_sommaire(ss);
					}
				gg->compte_fichiers_th=subscan;
				subscan+=1000;
				}
			
			break;
			
	case 'p' :	
			if(monscan && (monscan != numscan) )	 subscan=3000;	
			else	{
				if(subscan!=gg->compte_fichiers_tp+1) 
					{
					printf(" erreur fichier tp: ancien=%d  lit %d \n",gg->compte_fichiers_tp,subscan);
					sprintf(ss," -tp%d",gg->compte_fichiers_th+1);ajoute_sommaire(ss);
					}
				gg->compte_fichiers_tp=subscan;
				subscan+=2000;
				}
			
			break;
						
	default :	subscan=3000;
			break;
	}
			
//printf("lecture fichier type %c%c, numscan=%d  subscan=%d \n",nomfich[5],nomfich[6],numscan,subscan);

if(subscan==3000) 
	{
	ajoute_sommaire2(nomfich+1);
	printf(" fichier *s d'un autre scan \n",nomfich+1);
	return;
	}

alire=0;
if(subscan==1001) alire=1;

#ifdef lire_les_data_telescope_IRAM
alire=2;
#endif

if(alire)
	{
	FSMakeFSSpec(dd.volume,dd.dossier,(ConstStr255Param)nomfich,&file);
	if ((err=FSpOpenDF(&file,0,&data))!=0) 
			{
			son(1);		printf("\n pas possible de lire le fichier donnes telescope :");
			select(printf_ref);
			return;
			}

	lg=long_maxi_fich_tele-5;
	if(alire==1) lg=1100;	
	buf=malloc(long_maxi_fich_tele+16);
	strcpy(buf,nomfich+1);		//buff contient le nom du fichier (20 octets) suivit du contenu du fichier
	FSRead(data,&lg,buf+16);	
	FSClose(data);	// lit le fichier th ou tp  de donnees telescope
	printf("lecture fichier type %c%c, numscan=%d  subscan=%d :  lit %d caracteres \n",nomfich[5],nomfich[6],numscan,subscan,lg);

	for(i=0;i<38;i++) source[i]=buf[i+1052+16];source[38]=0;	// lit le nom de la source 
	if(subscan==1001)  renomme_fichier(4,numscan,source);		// ne renomme le fichier que pour le th.001
	
#ifdef lire_les_data_telescope_IRAM

	if(lg>long_maxi_fich_tele-10)
			{
			son(1);		
			printf("\nle fichier donnes telescope est trops gros \n");
			printf("il depasse la taille maximum de %d octets \n",long_maxi_fich_tele);
			select(printf_ref);
			}

	lg=(lg/4+1)*4 +16 ;
	BD->n_ligne_don=lg;
	BD->change=subscan;
	BD->bololut=0;
	if(fenetre(fichier_dia2_1))
		{
		position(fichier_dia2_1,fin_f);
		ecritF(fichier_dia2_1,sizeof(F_block_desc),BD);		// ecrit l'entete partielle
		ecritF(fichier_dia2_1,lg,buf);				// ecrit le texte du block data
		if(fenetre(fichier_dia2_2))
			{
			position(fichier_dia2_2,fin_f);
			ecritF(fichier_dia2_2,sizeof(F_block_desc),BD);	// ecrit l'entete partielle
			ecritF(fichier_dia2_2,lg,buf);			// ecrit le texte du block data
			}
		}
#endif

	free(buf);
	}
}




int deplace_un_fichier_telescope(VDos d1,char *nomfich)		// retourne 0 si tout va bien
{
char dossier2[100],nom_dossier_tele[100],dossier_complet[150];
FSSpec file1,file2;
VDos d2;
DateTimeRec date;

FSMakeFSSpec(d1.volume,d1.dossier,(ConstStr255Param)nomfich,&file1);	// le fichier source

// fabrique le dossier destination
GetTime(&date);

strcpy(nom_dossier_tele+1,"tele");
strcat(nom_dossier_tele+1,dossier_date);
*nom_dossier_tele=strlen(nom_dossier_tele+1);
litD(fenetre_fichier,f_d2,dossier2);			// le meme dossier que le second fichier de data DIA2
if( (strlen(dossier2)<3) ou (*dossier2=='/') )	return(1);
strcat(dossier2,":telescope");
d2=cherchedossier(dossier2);	// cree le dossier telescope s'il n'existe pas
//printf("deplace le fichier %s dans le dossier  %s //  %s  \n",nomfich+1,dossier2,nom_dossier_tele+1);

sprintf(dossier_complet,"%s:%s",dossier2,nom_dossier_tele+1);
d2=cherchedossier(dossier_complet);	// cree le dossier du jour s'il n'existe pas
//printf("dossiercomplet O.K. \n");
d2=cherchedossier(dossier2);		//  le dossier parent
if(!d2.volume) return(1);
//printf("dossier2 O.K. \n");
FSMakeFSSpec(d2.volume,d2.dossier,(ConstStr255Param)nom_dossier_tele,&file2);	// le dossier destination
//printf(" fichier %s copie dans dossier %s \n",nomfich+1,nom_dossier_tele+1);
return(FSpCatMove(&file1,&file2));
}




#endif

