#include "manip.h"
#include "choix_acquisition.h"
#include "archeops.h"
#include "choix_param.h"
#include "structure.h"
#include "tm.h"
#include "tache.h"
#include "bolo.h"
#include "carte_acqui.h"
#include "carte_pci.h"

#include "simulmission.h"

//*****************************************************************************************
//											***
#ifdef _archeopsXX		//---------   pour  Archeops    -----------------------	***
#ifndef _sans_transputer	//---------   pour  Archeops avec transputer    -------------	***
//											***
//*****************************************************************************************
//
//
//   lit directement les blocks recut sur la fifo et les envoie au programme principal
//
//



//def_long_block

#define avance_erreur  {tt->te.pos_ecrit++; if(tt->te.pos_ecrit>=long_table_err) tt->te.pos_ecrit=0;}
#define	ecrit_erreur(xx)	{avance_erreur;tt->te.err[tt->te.pos_ecrit]=900+(xx);}
void	sauve_un_block(tmtc* tt);

#define	test_val(xx)	{if(octet_a_lire!=(xx)) {if(octet_a_lire==(debut_block_mesure&0xff)) tt->vi.a=1; else tt->vi.a=0;}}
	

//*****************************************************************************************

void init_tache(void)
{
tt->vi.a=0;
tt->vi.b=0;
tt->vi.c=0;
}


#define	max_fifo  4000



void lecture_fifo(void* tx)	// appell directement pour acquisition en interruptions
{
register unsigned long RR;
tmtc* tt=(tmtc*)tx;
long lec_fifo=0;		//  compteur nombre de points lut en une fois dans la fifo
char*	t_char=(char*)(&tt->vi.btt);


if(tt->PCI_actif==2)	// simulation Archeops
	{
	static int numblock=0;
	tt->vi.a++;
	if(tt->vi.a>20)	// ecrit un block toutes les 20 interruptions (soit 0.5 sec)
		{
		int i;
		tt->vi.a=0;
		numblock++;

		for(i=0;i<(taille_maxi_block_archeops/4);i++)	tt->vi.btt.mot[i]=(int)((random(0)-0.5)*256.*256.*256.*256.);	
		valide_block(&tt->vi.btt,block_bolo,numblock);
		sauve_un_block(tt);

		for(i=0;i<(taille_maxi_block_archeops/4);i++)	tt->vi.btt.mot[i]=(int)((random(0)-0.5)*256.*256.*256.*256.);	
		valide_block(&tt->vi.btt,block_une_periode,numblock);
		sauve_un_block(tt);

		for(i=0;i<(taille_maxi_block_archeops/4);i++)	tt->vi.btt.mot[i]=(int)((random(0)-0.5)*256.*256.*256.*256.);	
		valide_block(&tt->vi.btt,block_dilution,numblock);
		sauve_un_block(tt);
		
//		if((numblock%5)==0)
			{
			for(i=0;i<(taille_maxi_block_archeops/4);i++)	tt->vi.btt.mot[i]=(int)((random(0)-0.5)*256.*256.*256.*256.);	
			valide_block(&tt->vi.btt,block_sst,numblock);
			sauve_un_block(tt);
			}

		}
	}
else if (tt->PCI_actif==3)	// simulation donnees mission
	{
		// EA + JD
		// Lecture d'un block depuis le simulateur
		
		if (SimulMissionBloc(tt)) {
		
		  // Sauvegarde du bloc dans la file d'attente
		  sauve_un_block(tt);
		}
	}
else	while(1)		//  case 1 et 4  
	{
	lit_carte;	if(rien_a_lire)		break;				//  fifo vide  ->  retour  ->  sort du while
	lec_fifo++;
	
	
//ecrit_erreur(err_sync_bebo);	

	
	if(tt->vi.b)	 // ecrit les mots pour b=[1....(sizeof(block_tm_trx)/4)-2]
		{
		t_char[tt->vi.b*4+3-tt->vi.c]=octet_a_lire;	// dans l'ordre: 3 2 1 0 7 6 5 4 11 10 9 8 ...
		
		tt->vi.c++;
		if(tt->vi.c>=4)				//  c est le compteur de cara  
			{
//			ecrit_erreur(err_recut_un_block_ok);
			tt->vi.c=0;
			tt->vi.b++;			//  b est le compteur de mot long de 4 octets
			
			if (tt->vi.b>=4)	// teste la longueur apres avoir lut 3 entiers long
				{
				int ll;
				ll=longueur_block(&tt->vi.btt);
				if(ll>sizeof(block_type_modele))  {tt->vi.a=0;tt->vi.b=0;ecrit_erreur(err_longueur_block);}
//				if(ll>sizeof(block_type_gps))  {tt->vi.a=0;tt->vi.b=0;ecrit_erreur(err_lect_pci);}
				if( tt->vi.b > ((ll/4)-1) ) 	 {tt->vi.b=0;}
				}
			}  
		}

	if(!tt->vi.b)	 // test et cherche debut
		{
		tt->vi.a++;
//		ecrit_erreur(err_lect_pci);			
		switch(tt->vi.a)
			{
			case 1	:	test_val(debut_block_mesure&0xff);		break;
			case 2	:	test_val((debut_block_mesure>>8)&0xff);		break;
			case 3	:	test_val((debut_block_mesure>>16)&0xff);	break;
			case 4	:		
					if(octet_a_lire!=((debut_block_mesure>>24)&0xff)) tt->vi.a=0;
					else 	{
						tt->vi.c=0;		//  pret pour la lecture de la suite du block
						tt->vi.b=1;		//  dja lut debut du block: commence par mot b=1;
						}
					 break;	
					 
			case 5	:	
//					ecrit_erreur(err_recut_un_block_ok);
					sauve_un_block(tt);	//  le code de debut n'a pas t ecrit dans le block
			default	:	tt->vi.a=0;break;
			}
		}
	
	if(lec_fifo>max_fifo) break;
	}
if(lec_fifo > tt->nb_lec_fofo_int)  	tt->nb_lec_fofo_int=lec_fifo;
if(!tt->val_con_fifo)  		{tt->val_con_fifo=tt->nb_lec_fofo_int;tt->nb_lec_fofo_int=0;}

}



//______________________________________________________________________________________________//
//   lit le block brut tel que recut par telemesure dans  tt->vi.btt				//
//	ce block contient  ??  periodes de mesure						// 
// 	Je rempli un block tm  en position	u=tt->tm.pos_ecrit				//
//	Le block s'ecrit: 			tt->tm.btm[u]					//
//______________________________________________________________________________________________//



void	sauve_un_block(tmtc* tt)
{
int u;
u=tt->tm.pos_ecrit;
//  le code de debut n'a pas t ecrit dans le block : il faut l'ecrire
tt->vi.btt.debut=debut_block_mesure;
tt->tm.btm[u].tmtrx=tt->vi.btt;	// recopie le block courant dans la table
u++; if(u>=longueur_table_tm) u=0;
tt->tm.pos_ecrit=u;

if(tt->tm.pos_ecrit==tt->tm.pos_lit)  ecrit_erreur(err_pile_pleine);
}

//*****************************************************************************************
//											***
#endif		//--------------------------------------------------------------------	***
#endif		//--------------------------------------------------------------------	***
//											***
//*****************************************************************************************




