#include "manip.h"
#include "choix_acquisition.h"
#include "archeops.h"
#include "choix_param.h"
#include "structure.h"
#include "tm.h"
#include "tache.h"
#include "bolo.h"
#include "carte_acqui.h"
#include "carte_pci.h"


//*****************************************************************************************
//											***
#ifdef _archeops		//---------   pour  Archeops  sans transputer  -------	***
#ifdef _sans_transputer		//---------   pour  Archeops avec ctb    -------------	***
//											***
//*****************************************************************************************
//
//
//
//  lit le tableau de donnes brute recue des bebo via le ctb
//
//  ensuite, prepare les blocs format type archeops pour les envoyer au programme principal
//

//



def_long_block
def_nom_block

#define avance_erreur  {tt->te.pos_ecrit++; if(tt->te.pos_ecrit>=long_table_err) tt->te.pos_ecrit=0;}
#define	ecrit_erreur(xx)	{avance_erreur;tt->te.err[tt->te.pos_ecrit]=900+(xx);}

void fabrique_block_type_data_brute(tmtc* tt,int num_block);
void fabrique_block_type_une_periode(tmtc* tt,int num_block);	
void fabrique_block_type_bolo(tmtc* tt,int num_block);	

void	sauve_un_block(tmtc* tt);


void init_tache(void)
{
int i,j;

tt->vi.a=0;
tt->vi.b=0;
tt->vi.c=0;


j=0;
for(i=0;i<nb_type_blocks;i++)	if (long_block[i]> j ) j=long_block[i];
printf(" taille maxi du block de telemesure = %d  //  on reserve %d octets par block \n",
		j,sizeof(block_type_modele));
if(j>sizeof(block_type_modele)) erreur("block_type_modele trops petit");
}



#define	test_val(xx)	{if(octet_a_lire!=(xx)) {if(octet_a_lire==(debut_block_mesure&0xff)) tt->vi.a=1; else tt->vi.a=0;}}
	

void lecture_fifo(void* tx)					// appell directement pour acquisition en interuptions
{
register unsigned long RR;
tmtc* tt=(tmtc*)tx;
long lec_fifo=0		//  compteur nombre de points lut en une fois dans la fifo
int max_fifo;

if(acquisition_PCI)	max_fifo=4000;	//  3000  points maxi par interruption (10ms)  soit (3.3s)
	 else		max_fifo=200;	//  ((1000)faux )  points maxi par interruption (10ms)  soit  (20s)

int max_buf=nb_byte_mot*tt->reglage.horloge.nb_mesures*nb_per_block;	
static long	num_block=0;

while(1)
	{
	if(acquisition_PCI)	{lit_carte;	if(rien_a_lire)	break;}//  fifo vide  ->  retour  ->  sort du while
	lec_fifo++;
//	tt->vi.bkb[tt->vi.a^3]=octet_a_lire;	// dans l'ordre: 3 2 1 0 7 6 5 4 11 10 9 8 ...
	tt->vi.bkb[tt->vi.a]=octet_a_lire;	// dans l'ordre: 3 2 1 0 7 6 5 4 11 10 9 8 ...
	tt->vi.a++;
	if(tt->vi.a>=max_buf)	
		{
		num_block++;
#ifdef	transmet_data_brute
		fabrique_block_type_data_brute(tt,num_block);
#endif
		fabrique_block_type_une_periode(tt,num_block);
		fabrique_block_type_bolo(tt,num_block);
		tt->vi.a=0;
		}	
	if(lec_fifo>max_fifo) break; 
	}
if(lec_fifo > tt->nb_lec_fofo_int)  	tt->nb_lec_fofo_int=lec_fifo;
if(!tt->val_con_fifo)  		{tt->val_con_fifo=tt->nb_lec_fofo_int;tt->nb_lec_fofo_int=0;}
}

//______________________________________________________________________________________________//
//   je traite le block brut tel que recut de la bebo par le ctb				//
//	ce block contient    nbper   periodes de mesure						// 
// 	Je rempli un block tm  en position	u=tt->tm.pos_ecrit				//
//	Le block s'ecrit: 			tt->tm.btm[u]					//
//______________________________________________________________________________________________//


#ifdef	transmet_data_brute
void fabrique_block_type_data_brute(tmtc* tt,int num_block)
{
int i;
block_type_data_brute  * blk	=  (block_type_data_brute*)   &(tt->vi.btt);	  

// pour 23 coups / demi-periode   et  nb_per=12  ( 2 bebo a 6 voies completes)  
//  on a 46 mesures par periode   et  276 mesures pour 6 periodes  et 552 mesures dans le block  	
for(i=0;i<nb_per_block*tt->reglage.horloge.nb_mesures*nb_byte_mot;i++)	
		{
		blk->data[i]=tt->vi.bkb[i];
		} 
		
valide_block((block_type_modele*)blk,block_data_brute,num_block);
sauve_un_block(tt);
}
#endif


void fabrique_block_type_une_periode(tmtc* tt,int num_block)
{
int i,k;
block_type_une_periode  * blk	=  (block_type_une_periode*)   &(tt->vi.btt);	  

/* pour 23 coups / demi-periode   et  nb_per=12  ( 2 bebo a 6 voies completes)  */
/*  on a 46 mesures par periode   et  276 mesures pour 6 periodes  et 552 mesures dans le block  	*/
//for(k=0;k<nb_per_block;k++)		/* boucle sur les periodes entires   */
for(k=0;k<6;k++)		/* boucle sur les periodes entires   */
	{
		/* spd vaut 1 durant les 6 premieres mesures    */
//	if( spd(k*reglage.horloge.nb_mesures) != (k<6)  )	blk->erreur_sync+=1000;
	for(i=0;i<tt->reglage.horloge.nb_mesures;i++)	
		{
		blk->bol_per[k][i]=(0xff & tt->vi.bkb[nb_byte_mot*(k*tt->reglage.horloge.nb_mesures+i)+1])
			| (0xff00 & ((tt->vi.bkb[nb_byte_mot*(k*tt->reglage.horloge.nb_mesures+i)+2])<<8));
//		if( (cpp(k*reglage.horloge.nb_mesures+i) != (i*2)/reglage.horloge.nb_mesures ) ) blk->erreur_sync++;*/
		} 
	}
//for(i=0;i<max_buf;i++)	blk->data[i]=tt->vi.bkb[i];

valide_block((block_type_modele*)blk,block_une_periode,num_block);
sauve_un_block(tt);
}


void fabrique_block_type_bolo(tmtc* tt,int num_block)
{
int i,k;
block_type_bolo  * blk	=  (block_type_bolo*)   &(tt->vi.btt);	  


for(k=0;k<nb_per_block*2;k++)		/* boucle sur les demi entires   */
	{
	for(i=0;i<nb_max_bolo;i++)	
		{
		blk->data_bolo[i][k]=
			(0xff & tt->vi.bkb[nb_byte_mot*(k*tt->reglage.horloge.nb_mesures/2+i+1)+3])
			| (0xff00 & (tt->vi.bkb[nb_byte_mot*(k*tt->reglage.horloge.nb_mesures/2+i+1)+4]<<8))
			| (0x1f0000 & (tt->vi.bkb[nb_byte_mot*(k*tt->reglage.horloge.nb_mesures/2+i+1)+5]<<16));
		} 
	}
		

valide_block((block_type_modele*)blk,block_bolo,num_block);
sauve_un_block(tt);
}



//______________________________________________________________________________________________//
//   lit le block brut tel que recut par telemesure dans  tt->vi.btt				//
//	ce block contient  ??  periodes de mesure						// 
// 	Je rempli un block tm  en position	u=tt->tm.pos_ecrit				//
//	Le block s'ecrit: 			tt->tm.btm[u]					//
//______________________________________________________________________________________________//

void	sauve_un_block(tmtc* tt)
{
int u;
u=tt->tm.pos_ecrit;
tt->tm.btm[u].tmtrx=tt->vi.btt;
u++; if(u>=longueur_table_tm) u=0;
tt->tm.pos_ecrit=u;
}

//*****************************************************************************************
//											***
#endif		//--------------------------------------------------------------------	***
#endif		//--------------------------------------------------------------------	***
//											***
//*****************************************************************************************




