#if !defined(_ECC_LIB_H_)

#define _ECC_LIB_H_

#define REED_SOLOMON

typedef unsigned char dtype;

void EccInit( int nn, int kk, int mm ) ;

/* Reed-Solomon encoding
 * data[] is the input block, parity symbols are placed in bb[]
 * bb[] may lie past the end of the data, e.g., for (255,223):
 *	encode_rs(&data[0],&data[223]);
 */
int EccEncode(dtype *data, dtype *bb );

/* Reed-Solomon erasures-and-errors decoding
 * The received block goes into data[], and a list of zero-origin
 * erasure positions, if any, goes in eras_pos[] with a count in no_eras.
 *
 * The decoder corrects the symbols in place, if possible and returns
 * the number of corrected symbols. If the codeword is illegal or
 * uncorrectible, the data array is unchanged and -1 is returned
 */
int EccDecode( dtype *data, dtype *ecc, int *eras_pos, int no_eras) ;

void SetEcc( void *bloc, unsigned char * ) ;
int UnsetEcc( void *bloc, unsigned char * ) ;

#if defined(REED_SOLOMON)
/*  defini ici que si l'on n'a pas inclu archeops.h qui contient les memes definitions */
#ifndef version_num
#define ECC_TOTAL 255
#define ECC_DATA 239       /* Nb de bytes de data encodes */
#define ECC_SIZE (ECC_TOTAL-ECC_DATA) /* Nb de bytes encodeurs */
#define SIZE_HEAD sizeof(long)*3  /* 3 mots d'entete de blocs */
#endif
#if defined(_ECCLIB_MAIN_)

int Kgood = ECC_DATA, /* Detection/correction de 8 bytes en erreur
		    On peut aller jusqu'a 16 (Kgood = 223 ) */
  Ntotal = 255 ;

#else

extern int Kgood, Ntotal ;

#endif
#endif
#endif
