#include "manip.h"
#include "choix_acquisition.h"
#include "archeops.h"
#include "choix_param.h"
#include "structure.h"
#include "tm.h"
#include "tache.h"
#include "carte_acqui.h"
#include "carte_pci.h"



// interprete la telecommande provenant du programme principal mac
// si c'est une commande directe, l'envoie directement sur le bus PCI (s'il est libre)
// sinon, appelle la fonction correspondante


//    si le bus PCI est libre : lit une telecommande et l'ecrit sur le bus PCI


//*****************************************************************************************
//											***
#ifdef _diabolo	//---------   pour  Diabolo    ------------------------------	***
//											***
//*****************************************************************************************




void	decode_telecommande(tmtc* tt)
{
int q,code,avance;
q=tt->tc.pos_ecrit-tt->tc.pos_lit;	if (q<0) q+=longueur_table_tc;
if(q) 	
	{
	avance=1;
	code=(tt->tc.btc[tt->tc.pos_lit].mot[0])&0xff;		// code de telecommande
	switch(code)
		{
		case	tc_horloge	:	avance=ecrit_commande_PCI(tt) ;		break;
		case	tc_regul	:	tache_regul(tt);					break;
		default	:				avance=ecrit_commande_PCI(tt) ;		break;
		}
	if(avance) 		
		{
		tt->tc.pos_lit++; 
		if(tt->tc.pos_lit>=longueur_table_tc) tt->tc.pos_lit=0;
		}

	}
}



int	ecrit_commande_PCI(tmtc* tt)
{
int j;
if (tt->vi.flag_ecriture_data>3)				// priorit a la regul 
		{
		char * mot;
		mot=tt->tc.btc[tt->tc.pos_lit].mot;
		for(j=0;j<10;j++)	
			{
			//			for(i=0;i<1000;i++);
//			ecrit_carte(tt->tc.btc[tt->tc.pos_lit].mot[j]);
			if(acquisition_PCI)	ecrit_carte(mot[j]);
			}
		tt->vi.flag_ecriture_data=0;
		return(1);
		}
return(0);
}


//*****************************************************************************************
//											***
#endif		//--------------------------------------------------------------------	***
//											***
//*****************************************************************************************


