#include "manip.h"
#include "choix_acquisition.h"
#include "archeops.h"
#include "choix_param.h"
#include "structure.h"
#include "tm.h"
#include "tache.h"
#include "bolo.h"
#include "carte_acqui.h"
#include "carte_pci.h"
#include "bit_block.h"


#include "simulmission.h"



//*****************************************************************************************
//											***
#ifdef _archeops		//---------   pour  Archeops    -----------------------	***
#ifndef _sans_transputer	//---------   pour  Archeops avec transputer    -------------	***
//											***
//*****************************************************************************************
//
//
//   lit directement les blocks recus sur la fifo et les envoie au programme principal
//


#define avance_erreur  {tt->te.pos_ecrit++; if(tt->te.pos_ecrit>=long_table_err) tt->te.pos_ecrit=0;}
#define	ecrit_erreur(xx)	{avance_erreur;tt->te.err[tt->te.pos_ecrit]=900+(xx);}
void	sauve_un_block(tmtc* tt);

	

//*****************************************************************************************
unsigned long	N_total_bits,M;
unsigned short	Max,Min;

void init_tache(void)
{
tt->vi.a=0;
tt->vi.b=0;
tt->vi.c=0;
}


#define	max_fifo  4000


//		un bit pour  fifo avec un seul bit (bit0) et la valeur de la periode en bit 1..6  (37 ou 38)		



char	un_bit()
{
static int i;
static unsigned long RR;
unsigned short	Val;

lit_carte;	if(rien_a_lire)		return(bit_vide);	//  fifo vide  ->  retour  ->  sort du while

N_total_bits++;
Val=((RR>>1) & 0x3f);	//permet de lire les bits de temps dans RR

//Calcul de la nouvelle moyenne glissee du temps
M=M-(M>>16)+(Val<<8);

	
//Calcul du Max
if(N_total_bits==0) Max=Val;	//initialisation au premier passage
if(Val>Max) Max=Val;	//changement de maximum
if((N_total_bits%60000)==0)
{
	Max=Max-1;	//Diminution tous les 60000 bits
	N_total_bits=0;
}
	
//Calcul du Min
if(N_total_bits==0) Min=Val;	//initialisation au premier passage
if(Val<Min) Min=Val;	//changement de minimum
if((N_total_bits%60000)==0) Min=Min+1;	//Augmentation tous les 60000 bits
//tt->nb_lec_fofo_ext=M;

#ifdef signe_inverse

if( RR & 1 )  return(bit_zero);
else		return(bit_un);

#else
	
if( RR & 1 )  	return(bit_un);
else		return(bit_zero);

#endif
}



void	ecrit_erreur_bit(int e)
{
ecrit_erreur(e+20);
}






void lecture_fifo(void* tx)	// appell directement pour acquisition en interruptions
{
tmtc* tt=(tmtc*)tx;
long lec_fifo=0;		//  compteur nombre de points lut en une fois dans la fifo
char*	t_char=(char*)(&tt->vi.btt);
int i;


if(tt->PCI_actif==2)	// simulation Archeops
	{
	static int numblock=0;
	tt->vi.a++;
	if(tt->vi.a>20)	// ecrit un block toutes les 20 interruptions (soit 0.5 sec)
		{
		int i;
		tt->vi.a=0;
		numblock++;

		for(i=0;i<(taille_maxi_block_archeops/4);i++)	tt->vi.btt.mot[i]=(int)((random(0)-0.5)*256.*256.*256.*256.);	
		valide_block(&tt->vi.btt,block_bolo,numblock);
		sauve_un_block(tt);

		for(i=0;i<(taille_maxi_block_archeops/4);i++)	tt->vi.btt.mot[i]=(int)((random(0)-0.5)*256.*256.*256.*256.);	
		valide_block(&tt->vi.btt,block_une_periode,numblock);
		sauve_un_block(tt);

		for(i=0;i<(taille_maxi_block_archeops/4);i++)	tt->vi.btt.mot[i]=(int)((random(0)-0.5)*256.*256.*256.*256.);	
		valide_block(&tt->vi.btt,block_dilution,numblock);
		sauve_un_block(tt);

		}
	}
else if (tt->PCI_actif==3)	// simulation donnees mission
	{
		// EA + JD
		// Lecture d'un block depuis le simulateur
		
		if (SimulMissionBloc(tt)) {
		
		  // Sauvegarde du bloc dans la file d'attente
		  sauve_un_block(tt);
		}
	}
else	while(1)		//  case 1 et 4
	{
	i=lit_bit(&tt->vi.btt);
	if(i==lit_bit_vide)	break;
	if(i==lit_bit_un_block)	sauve_un_block(tt);

	lec_fifo++;	
	if(lec_fifo>max_fifo*8) 	break;		// parceque compte les bit et non les octets
	}
if(lec_fifo > tt->nb_lec_fofo_int)  	tt->nb_lec_fofo_int=lec_fifo;
if(!tt->val_con_fifo)  		{tt->val_con_fifo=tt->nb_lec_fofo_int;tt->nb_lec_fofo_int=0;}

}



//______________________________________________________________________________________________//
//   lit le block brut tel que recut par telemesure dans  tt->vi.btt				//
//	ce block contient  ??  periodes de mesure						// 
// 	Je rempli un block tm  en position	u=tt->tm.pos_ecrit				//
//	Le block s'ecrit: 			tt->tm.btm[u]					//
//______________________________________________________________________________________________//



void	sauve_un_block(tmtc* tt)
{
int u;
//ecrit_erreur(err_recut_un_block_ok);

u=tt->tm.pos_ecrit;
//  le code de debut n'a pas t ecrit dans le block : il faut l'ecrire
tt->vi.btt.debut=debut_block_mesure;
tt->tm.btm[u].tmtrx=tt->vi.btt;	// recopie le block courant dans la table
u++; if(u>=longueur_table_tm) u=0;
tt->tm.pos_ecrit=u;

if(tt->tm.pos_ecrit==tt->tm.pos_lit)  ecrit_erreur(err_pile_pleine);
}

//*****************************************************************************************
//											***
#endif		//--------------------------------------------------------------------	***
#endif		//--------------------------------------------------------------------	***
//											***
//*****************************************************************************************




