#include "manip.h"
#include "choix_acquisition.h"
#include "archeops.h"
#include "choix_param.h"
#include "structure.h"
#include "tm.h"
#include "tache.h"
#include "bolo.h"
#include "carte_acqui.h"
#include "carte_pci.h"







//*****************************************************************************************
//											***
#ifdef _diabolo	//---------   pour  Diabolo    ------------------------------	***
//											***
//*****************************************************************************************

//#define test_erreur_complet



#define avance_erreur  {tt->te.pos_ecrit++; if(tt->te.pos_ecrit>=long_table_err) tt->te.pos_ecrit=0;}
#define	ecrit_erreur(xx)	{avance_erreur;tt->te.err[tt->te.pos_ecrit]=900+(xx);}


#define	SYNCHRO			fifo0
#define	EPLD_occupe		fifo12
#define	top_debut		fifo13

#define	ADC_BEBO		fifo(10)
#define	DS_BEBO			fifo(11)



void	depou_un_bit(tmtc* tt,long RR);
void	depou_un_mot_24_bit(tmtc* tt);

void	sauvedata(tmtc* tt,long * somme_ds);

//   i= position dans la periode     j=numero de bolo    k=numero de detection


void init_tache(void)
{

tt->vi.flag_ecriture_data=0;

tt->vi.i=0;
tt->vi.pos_block_tm=0;


tt->vi.reg.pid.nb_mes=0;
tt->vi.reg.pid.code=0;										
tt->vi.reg.pid.num_bolo=0;										
tt->vi.reg.pid.nb_mes=0;						  	
tt->vi.reg.pid.chauf=0;
tt->vi.reg.pid.p=0;
tt->vi.reg.pid.i=0;
tt->vi.reg.pid.d=0;


tt->vi.reg.compteur=0;	

tt->vi.reg.valeur=0;
tt->vi.reg.anc_ecart=0;
tt->vi.reg.tint=0;
tt->vi.reg.cc=0;

}



void lecture_fifo(void* tx)					// appell directement pour acquisition en interuptions
{
register unsigned long RR;
tmtc* tt=(tmtc*)tx;
long lec_fifo=0;
int max_fifo;

if(acquisition_PCI)	max_fifo=3000;	//  3000  points maxi par interruption (10ms)  soit (3.3s)
	 else		max_fifo=200;	//  ((1000)faux )  points maxi par interruption (10ms)  soit  (20s)

	
while(1)
	{
	if(acquisition_PCI)	{lit_carte;	if(rien_a_lire)	break;}//  fifo vide  ->  retour  ->  sort du while
	lec_fifo++;
	if (EPLD_occupe) tt->vi.flag_ecriture_data=0;


//----------------------    test des erreurs PCI  a mettre ou a enlever pour aller plus vite   -------------	
#ifdef test_erreur_complet
	{
	int j;
/*	j=  (RR>>30) & 3;		// ***** test bonne lecture PCI (seulement carte fife ) ******
	while (j!=5)	{
			ecrit_erreur(err_lect_pci);
			lit_carte;	if(rien_a_lire)		break;
			j=  (RR>>29) & 7;
			tt->vi.aa=0;
			}
	if(j!=5) break;		// parceque il faut sortir des deux while 	
*/
	tt->vi.aa++;	    // le aa du test d'erreur n'est pas le meme que le a du compteur de temps  

	j=  ((RR>>26) - tt->vi.aa ) & 7;				// ***** test compteur dans carte PCI ******
	if(j)	{	
		tt->vi.aa= (RR>>26) & 7;
		avance_erreur;tt->te.err[tt->te.pos_ecrit]=j;
		ecrit_erreur(err_lect_pci);
		}
	
//	j= ((RR>>15) -  tt->vi.a ) & 7 ;				// ****** test compteur dans controleur *******	
//	if(j)		{
//			avance_erreur;tt->te.err[tt->te.pos_ecrit]=j;
//			ecrit_erreur(err_lect_ctrl);
//			}
	}					// autre erreur de synchro fifo			
#endif
//_____________________   fin du test des erreurs facultatif    _____________________________________________
	

//	if(parametr.presence_bebo && (tt->vi.a==5) && 	ADC_BEBO )	ecrit_erreur(err_sync_bebo);				// erreur synchro de la BEBO

	depou_un_bit(tt,RR); 

	tt->vi.a++;

//  --------------------   avance les compteurs  a (position dans le mot de 24 bits)  et i (position dans la periode)
	if	(tt->vi.a>(bitmot-1)) 	
		{
		tt->vi.a=0;tt->vi.i++;
		if(tt->vi.i>(tt->reglage.horloge.nb_mesures-1))   tt->vi.i=0; 			// normal : fin de periode complete 
		if(SYNCHRO)			ecrit_erreur(err_sync_repart);					// erreur synchro du repartiteur
		if( RR&FLAG_FIFO_FULL )		{ecrit_erreur(err_fifo_pleine);read_flags();reset_fifo();}	// la fifo a dborde			
		if(lec_fifo > tt->nb_lec_fofo_int)  tt->nb_lec_fofo_int=lec_fifo;
		if(!tt->val_con_fifo)  	{tt->val_con_fifo=tt->nb_lec_fofo_int;tt->nb_lec_fofo_int=0;}
		if(lec_fifo>max_fifo) 
			{
			if(!(RR&FLAG_NFIFOHF))	tt->nb_lec_fofo_int=2*max_fifo;	// fifo plus qu' moiti pleine			
			break; 
			}
		}
//     -------------------	test    topdebut en mme temps que le dernier bit du mot    --------------
//    si pas de top debut: les compteurs tournent normalement et pas de diagnostique d'erreur
	if(top_debut && ( tt->vi.a ou tt->vi.i) ) 
			{
			ecrit_erreur(err_sync_ctrl);		// erreur synchro controlleur-mac
			tt->vi.a=0;tt->vi.i=0;
			}

	}
}


//_________________________________________________________________________________________________________________




void depou_un_bit(tmtc* tt,long RR)
{
int j,n,t,s;
n=tt->reglage.horloge.nb_mesures;



//___________________		 calcul detection synchrone et remplissage table courante

if(tt->vi.a ==0)			
	{
	depou_un_mot_24_bit(tt);	//  appel du programme qui somme les points pour calcul de la D.S.
						//  c'est aussi le programme qui rempli la table pour affichage d'une periode
	}

//___________________	 B.E.B.O.	 Lecture de numbol : numero du bolo de la bebo a lire
if(tt->vi.a==2) 	tt->vi.numbol=0;

if( (tt->vi.a>=2) && (tt->vi.a<=4) )	tt->vi.numbol= tt->vi.numbol | (  ADC_BEBO  << (4-tt->vi.a))  ;		// a==2, 3 et 4  ->  numero du bolo en cours de mesure  


for(j=0;j<nb_max_bolo;j++)
	{
	t=parametr.bolo[j].bolo_bebo;
	switch(t)
		{
		case 0	:			//   lecture  MLPA  direct sur fifo numero t
					if  (tt->vi.a==2)	tt->vi.mot[j]=tt->vi.mot[j] | ( fifo(parametr.bolo[j].bolo_num) << 12 );			//  a=2 : bit de phase	(ecrit pour a=0 : 2 temps de retard)		
					if( (tt->vi.a>=4) && (tt->vi.a<=15) )  tt->vi.mot[j]=tt->vi.mot[j] | ( fifo(parametr.bolo[j].bolo_num)  << (15-tt->vi.a));
					break; 

		case 2	:					// lecture beboA  :  bolo 17  22 

					t=parametr.bolo[j].bolo_num;
					if( !t ou ( t == tt->vi.numbol ) )
						{
						if(tt->vi.a==6) 	tt->vi.mot[j]=tt->vi.mot[j] | ( ADC_BEBO  << 12 );	// a=6 : bit de phase
						if( (tt->vi.a>6) && (tt->vi.a<=18) )																// a==7 ->  poid fort de l'ADC  
							tt->vi.mot[j]=tt->vi.mot[j] | ( ADC_BEBO  << (18-tt->vi.a));  // donnes de chaque bolo individuels de la bebo
						}
					if(  ( t == (7-tt->vi.i) )  &&  (tt->vi.a>0) && (tt->vi.a<=22) )  	// a==1 ->  premier bit de poid fort   --   22 bits en tout
								tt->ds.sommeA[j]=tt->ds.sommeA[j] | ( DS_BEBO  << (22-tt->vi.a));  	// valeur DS de chaque bolo individuels de la bebo
					if(  ( t == (7 + n/2 -tt->vi.i) )  &&  (tt->vi.a>0) && (tt->vi.a<=22) )  	// a==1 ->  premier bit de poid fort   --   22 bits en tout
								tt->ds.sommeB[j]=tt->ds.sommeB[j] | ( DS_BEBO  << (22-tt->vi.a));  	// valeur DS de chaque bolo individuels de la bebo

					break;
		default	:	break;
		}
	}
// ------------------- calcul des signaux de synchro (sur chaque bit de chaque mot) ------------------

s=tt->vi.a-5;
if( (s>=0) && (s<nb_sync) && !SYNCHRO ) tt->vi.synchro[s]++;

if(tt->PCI_actif==2)
//if(tt->vi.a ==0)
	{
	if(((tt->vi.temps_cntl>>19)&1)) 	tt->vi.synchro[0]=10;else tt->vi.synchro[0]=0;
	if(((tt->vi.temps_cntl>>25)&1)) 	tt->vi.synchro[1]=20;else tt->vi.synchro[1]=0;	// scan
	if(((tt->vi.temps_cntl>>21)&1)) 	tt->vi.synchro[2]=30;else tt->vi.synchro[2]=0;	// subscan
	if(((tt->vi.temps_cntl>>22)&1)) 	tt->vi.synchro[3]=40;else tt->vi.synchro[3]=0;
	}

}





void	depou_un_mot_24_bit(tmtc* tt)
{
// -----------------   traitement d'une valeur ADC lue (typique 10 kHz)  --------------------------------
//------------------   appell pour  tt->vi.a==0  avant lecture du bit correspondant   --------------
register long R1;
int j,n,p;
n=tt->reglage.horloge.nb_mesures;


if(tt->PCI_actif==2)
    for(j=0;j<nb_max_bolo;j++)  
	{
	int q;
	q=tt->vi.i-1;if(q<0) q=n-1;  // parceque tt->vi.i vaut 0 pour le dernier point
//			tt->vi.mot[j]=	0x800 -	(q-(n/2)) * (((double)j+10.) * 0.1 * (double)((tt->vi.temps_cntl>>15)&0x1f)) ;	//  sans carte : mot fini sans erreur
	tt->vi.mot[j]=	0x800 -	(q-(n/2)) * (int)(5.*((double)j+5.) * cos(0.01*(double)(tt->vi.temps_cntl>>8))) ;	//  sans carte : mot fini sans erreur
	tt->vi.mot[j]+=	((int)(random(0)*256.)&0xff) ;		//  bruit alatoire 8 bits
//			tt->vi.mot[j]=	0x800 +	((int)(random(0)*3.)&0x3f) ;		//  bruit alatoire 3 bits
	if(q>=n/2)	tt->vi.mot[j]+=0x1000;			// phase
	}



for(j=0;j<nb_max_bolo;j++)
	{
// --------------- pour   MLPA ou  BEBO voie zero: je calcule la detection synchrone par soft: ------------
	if ( ( !parametr.bolo[j].bolo_bebo ) ou ( !parametr.bolo[j].bolo_num ) ) 	
		{
		if( (  (tt->ds.ii[j]>n/2) &&  (!(tt->vi.mot[j]&0x1000)) ) ou (tt->ds.ii[j]>n) ) 
				tt->ds.ii[j]=0;		// calage de la phase sur la phase mesure
		
		R1=( tt->vi.mot[j]&0xfff ) * ( tt->ds.dstable[tt->ds.ii[j]] );	// calcul de la D.S.
		tt->ds.sommeA[j]+=R1;	tt->ds.sommeB[j]+=R1;					// somme dans les deux tables
		tt->ds.ii[j]++;				//  avance la phase propre de chaque bolometre  ii avance de 0  n-1
		}
				


//---------------------------   remplissage table affichage une periode dans block tm  --------------------

	p=tt->vi.i-1;if ( p<0)  p=n-1;
	if( ( !parametr.bolo[j].bolo_bebo ) ou ( !parametr.bolo[j].bolo_num ) ou ( parametr.bolo[j].bolo_num==tt->vi.numbol) )	
			{
			tt->tm.btm[tt->tm.pos_ecrit].bol_per[j][p]=tt->vi.mot[j]<<3;		// je lit le dernier point pour i=0,  que j'ecrit en p=n-1 
			tt->tm.btm[tt->tm.pos_ecrit].flag_bolo[j]=1;
			}
//---------------------------   reset du mot avant mesure point suivant  --------------------

	tt->vi.mot[j]=0;	

//---------------------------  pour BEBO : somme et changement de signe pour calcul D.S.  --------------------

	if( (tt->vi.i==0) &&  parametr.bolo[j].bolo_bebo  && parametr.bolo[j].bolo_num  )   
			{	tt->ds.sommeB[j] = -tt->ds.sommeB[j];tt->ds.sommeA[j] += tt->ds.sommeB[j];}

	if( (tt->vi.i==(n/2))  &&  parametr.bolo[j].bolo_bebo  && parametr.bolo[j].bolo_num  )
			tt->ds.sommeB[j] += tt->ds.sommeA[j];
	}


if(tt->vi.i==0)			sauvedata(tt,tt->ds.sommeA);			// apres lecture et sommation du dernier point		
if(tt->vi.i==(n/2))		sauvedata(tt,tt->ds.sommeB);			
}


void sauvedata(tmtc* tt,long * somme_ds)
{
int j,u;

tt->vi.temps_cntl ++;


//------------------  ecrit table telemesure  tm
u=tt->tm.pos_ecrit;


tt->tm.btm[u].temps_cntl[tt->vi.pos_block_tm]=tt->vi.temps_cntl;
GetDateTime(&tt->tm.btm[u].temps_mac[tt->vi.pos_block_tm]);

tt->tm.btm[u].chauf_regul=tt->vi.reg.cc;


for(j=0;j<nb_max_bolo;j++)
			{
			if( (!parametr.bolo[j].bolo_bebo) ou !parametr.bolo[j].bolo_num )
				{						//  pour une MLPA  ou voie 0 d'une BEBO
				tt->tm.btm[u].don[tt->vi.pos_block_tm].don_bolo[j] = (somme_ds[j]<<4) / (long)tt->ds.dsnorme;
				}
			else
				{						//  pour une BEBO
				//   donnes dans tt->tb.x -> +-22 bits  au maxi pour dsnorme= 128 ( nb total de points / periode )
				// apres division (128=7bits),  reste +-15 bit soit un entier short sign   
				tt->tm.btm[u].don[tt->vi.pos_block_tm].don_bolo[j] = somme_ds[j]  / (long)tt->ds.dsnorme;
				}						
			}

for(j=0;j<nb_sync;j++)			tt->tm.btm[u].don[tt->vi.pos_block_tm].sync[j]=tt->vi.synchro[j];		

tt->signal_scan_immediat=tt->vi.synchro[sync_scan];
tt->vi.pos_block_tm++;

if(tt->vi.pos_block_tm>=nb_per_block*2)		// a la fin d'un block de telemesure
	{
	tt->tm.btm[u].reglage=tt->reglage;						//  copie l'etat bolo courant
	
	tt->vi.pos_block_tm=0;
	
	
	
	u++; if(u>=longueur_table_tm) u=0;
	tt->tm.pos_ecrit=u;
	
	if(tt->tm.pos_ecrit==tt->tm.pos_lit)  ecrit_erreur(err_pile_pleine);
	
	}
//------------------   fin ecriture table telemesure  tm


tt->vi.reg.valeur+=somme_ds[tt->vi.reg.pid.num_bolo-1];	// integration de la valeur pour la regul


for(j=0;j<nb_max_bolo;j++)	somme_ds[j]=0;		//	raz table donnes pour la suite
for(j=0;j<nb_sync;j++)		tt->vi.synchro[j]=0;	// raz table des synchro pour la suite	
for(j=0;j<nb_max_bolo;j++)	tt->tm.btm[u].flag_bolo[j]=0;



raz_periodique(tt);
regul(tt);
decode_telecommande(tt);

tt->vi.flag_ecriture_data++;		// bon pour envoi
}


//*****************************************************************************************
//											***
#endif		//--------------------------------------------------------------------	***
//											***
//*****************************************************************************************

