#include "diabolo.h"
#include "dilution.h" 
#include "controle.h" 
#include "arcunit.h" 


//--------------------  fonction  exec  de  la  fenetre : dilution  -------------------------------

#define	bit0	0x01
#define	bit1	0x02
#define	bit2	0x04
#define	bit3	0x08
#define	bit4	0x10
#define	bit5	0x20
#define	bit6	0x40
#define	bit7	0x80


#define  cnt_temperature(i)	(20+(int)val_temperature(blk->ADC_dil[i]))

#define  ecrit_switch(val,ii,bit) {if(val) ii=ii | bit ;else ii=ii& (0xffffffff^bit) ;}
#define  calib(j)		litD(fenetre_dilution_calibration,j,0L)


void  ecrit_moteur_dilution(int valeur);	// valeur sur 10 bit: poid fort=on/off

void  ecrit_moteur_dilution(int valeur)
{
int i;
char mot_tc[10];

		i=litD(fenetre_dilution,dil_switch_1,0);
i=i<<8; 	i+=litD(fenetre_dilution,dil_switch_2,0);
i=i<<8;		i+=litD(fenetre_dilution,dil_switch_3,0);
i=i<<8;		// les 3 octets en poid fort, rien dans le dernier octet
i=i& 0x003fffff;
i = i| ( (valeur & 0x3ff)<<22);
ecritD(fenetre_dilution,dil_switch_1,(i>>24)&0xff);
ecritD(fenetre_dilution,dil_switch_2,(i>>16)&0xff);
ecritD(fenetre_dilution,dil_switch_3,(i>>8 )&0xff);

mot_tc[0]=tc_switch_dil;
mot_tc[1]=0;
mot_tc[2]=0;
mot_tc[3]=0;
mot_tc[4]=(i>>8 )&0xff;
mot_tc[5]=(i>>16)&0xff;
mot_tc[6]=(i>>24)&0xff;
mot_tc[7]=0;	
emission_telecommande(tc_dir_transputer,mot_tc);
}


//   fonction ecrit un bit des switch dilution
//  c'est une telecommande normale 64 bit  a supprimer
// la telecommande passe a travers le transputer sans etre traitee par lui
//  elle arrive directement sur l'EPLD
/*
void  ecrit_bit_dilution(int valeur,int bit);

void  ecrit_bit_dilution(int valeur,int bit)
{
int i;
char mot_tc[10];

		i=litD(fenetre_dilution,dil_switch_1,0);
i=i<<8; 	i+=litD(fenetre_dilution,dil_switch_2,0);
i=i<<8;		i+=litD(fenetre_dilution,dil_switch_3,0);
i=i<<8;		// les 3 octets en poid fort, rien dans le dernier octet
ecrit_switch(valeur,i,bit);
ecritD(fenetre_dilution,dil_switch_1,(i>>24)&0xff);
ecritD(fenetre_dilution,dil_switch_2,(i>>16)&0xff);
ecritD(fenetre_dilution,dil_switch_3,(i>>8 )&0xff);

mot_tc[0]=tc_switch_dil;
mot_tc[1]=0;
mot_tc[2]=0;
mot_tc[3]=0;
mot_tc[4]=(i>>8 )&0xff;
mot_tc[5]=(i>>16)&0xff;
mot_tc[6]=(i>>24)&0xff;
mot_tc[7]=0;	
emission_telecommande(tc_dir_transputer,mot_tc);
}
*/
//   fonction ecrit un  des dac dilution
//  c'est une telecommande normale 64 bit  a supprimer
// la telecommande passe a travers le transputer sans etre traitee par lui
//  elle arrive directement sur l'EPLD

void  ecrit_dac_dilution(void);

void  ecrit_dac_dilution(void)
{
char mot_tc[10];
int k;
unsigned long i,j;
i=litD(fenetre_dilution,dil_dac_1,0); // les 2 bits adresse du dac
i=i<<14; i+=litD(fenetre_dilution,dil_dac_2,0);	// les 12 bits valeur du dac
// ranger les bits a l'envers;
j=0; for(k=0;k<16;k++)	{j=(j<<1) | (i&1);i=i>>1;}
mot_tc[0]=tc_dac_dil;
mot_tc[1]=(j)&0xff;
mot_tc[2]=(j>>8)&0xff;
mot_tc[3]=0;
mot_tc[4]=0;
mot_tc[5]=0;
mot_tc[6]=0;
mot_tc[7]=0;	
emission_telecommande(tc_dir_transputer,mot_tc);
}




void exec_dilution(int fen,int item,double valeur,...) 
{
int i;

if(item>1000) item-=1000;		// pour appeler le case pour tous les cara d'un edit texte

switch(item)
	 {
	 case dil_switch_helium :	emission_tc_reduite(tc2_dilution,(valeur==1),nbit_switch_helium);	break;
   	 case dil_EVB :		emission_tc_reduite(tc2_dilution,(valeur==1),nbit_vanne_EVB);	break;
   	 case dil_EVO :		emission_tc_reduite(tc2_dilution,(valeur==1),nbit_vanne_EVO);	break;
    	case dil_EVF :		emission_tc_reduite(tc2_dilution,(valeur==1),nbit_vanne_EVF);	break;
    	case dil_EVV :		emission_tc_reduite(tc2_dilution,(valeur==1),nbit_vanne_EVV);	break;
    	case dil_sw_pp5 :		emission_tc_reduite(tc2_dilution,(valeur==1),nbit_switch_pile_par_5);	break;
    	case dil_sw_pp15 :		emission_tc_reduite(tc2_dilution,(valeur==1),nbit_switch_pile_par_15);	break;

  /*  
    
    case dil_switch_helium :	ecrit_bit_dilution((int)valeur,switch_helium);	break;
    case dil_EVB :		ecrit_bit_dilution((int)valeur,vanne_EVB);	break;
    case dil_EVO :		ecrit_bit_dilution((int)valeur,vanne_EVO);	break;
    case dil_EVF :		ecrit_bit_dilution((int)valeur,vanne_EVF);	break;
    case dil_EVV :		ecrit_bit_dilution((int)valeur,vanne_EVV);	break;
    case dil_sw_pp5 :		ecrit_bit_dilution((int)valeur,switch_pile_par_5);	break;
    case dil_sw_pp15 :		ecrit_bit_dilution((int)valeur,switch_pile_par_15);	break;
*/
//  ----   commande directe d'un mot avec les 3 case de codage hexadecimales

  //  case dil_switch_1 :
 //   case dil_switch_2 :
  //  case dil_switch_3 :		ecrit_bit_dilution(0,0);	break;

//  ----   telecommande du raz periodique des fets 
    case dil_raz_modul :
    case dil_fet_raz :	
  		 i =0;
 		if(litD(fen,dil_fet_raz,0)==2)	i+=1;
		if(litD(fen,dil_fet_raz,0)==3)	i+=7;
     		emission_tc_reduite(tc2_raz_fet,0,i);
/*
    		{
    		char mot_tc[10];
		mot_tc[0]=7;		//  commande la premiere bebo directe -> il faut ecrire tc reduite
		i=litD(fen,dil_raz_modul,0);
		i=i<<3;
		if(litD(fen,dil_fet_raz,0)==2)	i+=1;
		if(litD(fen,dil_fet_raz,0)==3)	i+=7;
		i=i<<4;
		mot_tc[1]=i;
		for(i=2;i<8;i++)	mot_tc[i]=0;
		emission_telecommande(tc_dir_transputer,mot_tc);
		}
*/
                 break;
                 
    case dil_ch1 :		emission_tc_reduite(tc2_dilution,(valeur==1),nbit_chauffage1);	break;
    case dil_ch2 :		emission_tc_reduite(tc2_dilution,(valeur==1),nbit_chauffage2);	break;
    case dil_ch3 :		emission_tc_reduite(tc2_dilution,(valeur==1),nbit_chauffage3);	break;
    case dil_ch4 :		emission_tc_reduite(tc2_dilution,(valeur==1),nbit_chauffage4);	break;
    case dil_ch5 :		emission_tc_reduite(tc2_dilution,(valeur==1),nbit_chauffage5);	break;
    case dil_ch6 :		emission_tc_reduite(tc2_dilution,(valeur==1),nbit_chauffage6);	break;
    case dil_ch7 :		emission_tc_reduite(tc2_dilution,(valeur==1),nbit_chauffage7);	break;
    
//    case dil_dac_1 :
//   case dil_dac_2 :
//   case dil_envoi_dac :	ecrit_dac_dilution(); 	break;
   	case dil_envoi_dac :	ecrit_moteur_dilution((int)litD(fenetre_dilution,dil_dac_2,0));	// les 12 bits
				break;

    default  :   break;
    }
}




void	traite_block_dilution(block_type_dilution*	blk)
{
int i;

//  ouvre la fenetre de calibration
if(!fenetre(fenetre_dilution_calibration)) 
	nouveauD(fenetre_dilution_calibration,dilution_calibrations_id,"dilution_calibration",exec_cache);

if( (blk->switch_dil&0x3f ) != 6 )	{
//					printf("****************   affiche erreur \n");
					changecontrole(fenetre_dilution,dil_erreur,idem,idem,idem,idem,idem,"erreur");
					}
else					{
					static int q;
					char ss[10]="____";
					q=(q+1)&3;
					ss[q]='/'; 
					changecontrole(fenetre_dilution,dil_erreur,idem,idem,idem,idem,idem,ss);
//					printf("****************   pas d' erreur \n");
					}


// lit les switchs
//  --  les voyants de fin de course vanne principale  (logique negative)
ecritD(fenetre_dilution,dil_voyant_EVO,((blk->switch_dil&switch_EVO)?0:1));
ecritD(fenetre_dilution,dil_voyant_EVF,((blk->switch_dil&switch_EVF)?0:1));

// les retour de commande des electrovannes
ecritD(fenetre_dilution,dil_EVB_retour,((blk->switch_dil&vanne_EVB)?1:0));
ecritD(fenetre_dilution,dil_EVO_retour,((blk->switch_dil&vanne_EVO)?1:0));
ecritD(fenetre_dilution,dil_EVF_retour,((blk->switch_dil&vanne_EVF)?1:0));
ecritD(fenetre_dilution,dil_EVV_retour,((blk->switch_dil&vanne_EVV)?1:0));


#define	c(j,i)		(1e-4*(double)parametr.nom_coef[parametr.bolo[j].numero_nom_coef].coef[i])	

// les temperatures sur les cartes modifies
{
double I,V,R[8],llR;
int j,k;
def_gains;
k=0;

for(j=0;(j<nb_max_bolo) && (k<4);j++)
	{
	if(parametr.bolo[j].bolo_code_util==bolo_thermo_simplifie)
		{
		I = 1e-3 * (double)dac_V(gg->reglage.bolo[j]) * 2441. / parametr.bolo[j].bolo_capa;	//	I en A
		V=0.001*bol_micro_volt(blk->temperature[k],(double)parametr.bolo[j].bolo_gain*gain_ampli(gg->reglage.bolo[j]));
		if(I>0.0000001)		R[k]=V/I;	else	R[k]=0;				//	R  en 
 //------  calcul de l'etalonnage en temperature des cartes temperature simplifies  
 // j=numero de bebo	T[k] = R[k+4] en Kelvin
		if ((R[k]-c(j,6))>1.) 
			{if((log(R[k]-c(j,6))-c(j,0))>0.001) llR= log(log(R[k]-c(j,6))-c(j,0)) ; else llR=0; 
//			printf("\nk=%d j=%d R=%g c2=%g c3=%g llR=%g",k,j,R[k],c(j,2),c(j,3),llR);
			} 
		else llR=0;
		R[k+4]	= exp( 	c(j,1) + c(j,2)* llR + c(j,3)* llR* llR + c(j,4)* llR* llR* llR + c(j,5)* llR* llR* llR* llR) ; 
		if(R[k+4]>9999) R[k+4]=9999;
		k++;		
		}
	}

gg->temperature_cryo=R[4];     // Charge la temperature_cryo (0.1K) pour les calculs futurs avec les bolos 
/* La germanium doit toujours etre en premier par rapport aux autres thermos absolus */

if(R[0]<90.)	ecritD(fenetre_dilution,dil_temp
	, "ge=%6.2f 4K=%6.2f 1.6K=%6.2f 10K=%6.2f\rge= %6.3fK  4K=%6.2fK 1.6K=%6.2fK 10K=%6.2fK "
		,R[0],R[1],R[2],R[3],R[4],R[5],R[6],R[7]);
else	ecritD(fenetre_dilution,dil_temp
	,"ge=%6.3fk 4K=%6.2f 1.6K=%6.2f 10K=%6.2f\rge= %6.3fmK 4K=%6.2fK 1.6K=%6.2fK 10K=%6.2fK "
	,R[0]*0.001,R[1],R[2],R[3],R[4]*1000.,R[5],R[6],R[7]);


if(litD(fenetre_dilution,dil_trace_tempe,0))// trace les sondes de niveau helium
	{
	int temps_cntl=numero_block(blk)*nb_per_block*2;
	double secondes,minutes;
	secondes=gg->periode_echantillonage*(double)temps_cntl;
	minutes=secondes/60.;
	if(!fenetre(fenetre_temperature_dil)) 
			{
			nouveauD(fenetre_temperature_dil,0,"temperature_dil",0);
			selectgra(fenetre_temperature_dil);
			strcpy(graph->xtitre,"minutes");
			}
	tracen(fenetre_temperature_dil,8,minutes,R);
	}
}

// les pressions et debits metres des injections de la dilution
ecritD(fenetre_dilution,dil_p_d_3He,"3He: %4.1fb -> %5.2fm/s -> %4.1fb"
	,40. 	*	val_multiplex(blk->ADC_dil[ p_R3])  -1.6	//	200 bars pour 5V et 1.6 bar d'offset
	,2. 	* 	val_multiplex(blk->ADC_dil[ d_3He])		//  10 MICRO MOLES  pour  5V
	,20. 	*	val_multiplex(blk->ADC_dil[ p_C3])		//	100 bars pour 5V
	);
ecritD(fenetre_dilution,dil_p_d_4He,"4He: %4.1fb -> %5.2fm/s -> %4.1fb"
	,40. 	*	val_multiplex(blk->ADC_dil[ p_R4])		//	200 bars pour 5V
	,8. 	* 	val_multiplex(blk->ADC_dil[ d_4He])		//  40 MICRO MOLES  pour  5V
//	,4. 	* 	val_multiplex(blk->ADC_dil[ d_4He])		//  20 MICRO MOLES  pour  5V
	,20. 	*	val_multiplex(blk->ADC_dil[ p_C4])		//	100 bars pour 5V
	);

ecritD(fenetre_dilution,dil_p_air,"Van=%4.1fb  charb=%4.1fb  mmb=%4.3fb  haut=%4.3fb"
	,20.*val_multiplex(blk->ADC_dil[ p_air]),20.*val_multiplex(blk->ADC_dil[ p_charb])
	,0.2*val_multiplex(blk->ADC_dil[ p_memb]),0.2*val_multiplex(blk->ADC_dil[ p_haut])	);
			
ecritD(fenetre_dilution,dil_piles," Trp=%4.1fV   Dil=%4.1fV / %4.1fV  \rBebo=%4.1fV   /   %4.1fV / %4.1fV  Ch=%4.1fV"
	,2.03*val_multiplex(blk->ADC_dil[ p_10T]),3.90*val_multiplex(blk->ADC_dil[ p_p18D]),3.90*val_multiplex(blk->ADC_dil[ p_m18D])
	,2.03*val_multiplex(blk->ADC_dil[ p_10B]),3.90*val_multiplex(blk->ADC_dil[ p_p18B]),3.90*val_multiplex(blk->ADC_dil[ p_m18B])
	,3.8*val_multiplex(blk->ADC_dil[ p_Ch]));

/* valeur seuil au mini (5.3 ou 15.3V) , *17 =  +5.9 V au maxi	*/


ecritD(fenetre_dilution,dil_p_10T,(int)(17*(2.03*val_multiplex(blk->ADC_dil[ p_10T])-5.3)));
ecritD(fenetre_dilution,dil_p_p18D,(int)(17*(3.90*val_multiplex(blk->ADC_dil[ p_p18D])-15.3)));
ecritD(fenetre_dilution,dil_p_m18D,(int)(17*(-3.90*val_multiplex(blk->ADC_dil[ p_m18D])-15.3)));
ecritD(fenetre_dilution,dil_p_10B,(int)(17*(2.03*val_multiplex(blk->ADC_dil[ p_10B])-5.3)));
ecritD(fenetre_dilution,dil_p_p18B,(int)(17*(3.93*val_multiplex(blk->ADC_dil[ p_p18B])-15.3)));
ecritD(fenetre_dilution,dil_p_m18B,(int)(17*(-3.93*val_multiplex(blk->ADC_dil[ p_m18B])-15.3)));
ecritD(fenetre_dilution,dil_p_Ch,(int)(10*(3.8*val_multiplex(blk->ADC_dil[ p_Ch])-25)));	/* 25 a 35 V  */

//  --  les voyants de switch de piles
ecritD(fenetre_dilution,dil_voyant_pp5,((blk->switch_dil&switch_pile_par_5)?1:0));
ecritD(fenetre_dilution,dil_voyant_pp15,((blk->switch_dil&switch_pile_par_15)?1:0));


ecritD(fenetre_dilution,dil_temperatures,"temp-Haut =  %4.1f  %4.1f Base  =  %4.1f  %4.1f \r tube He: %4.1f piles %4.1f driver %4.1f"
	,val_temperature(blk->ADC_dil[ t_h2]),val_temperature(blk->ADC_dil[ t_h4])
	,val_temperature(blk->ADC_dil[ t_b1]),val_temperature(blk->ADC_dil[ t_b2]),val_temperature(blk->ADC_dil[ t_b3])	
	,val_temperature(blk->ADC_dil[ t_pile]),val_temperature(blk->ADC_dil[ t_a1])
	);

ecritD(fenetre_dilution,dil_t_h1,cnt_temperature(t_h2));
ecritD(fenetre_dilution,dil_t_h2,cnt_temperature(t_h4));
ecritD(fenetre_dilution,dil_t_h3,cnt_temperature(t_b1));
ecritD(fenetre_dilution,dil_t_h4,cnt_temperature(t_b2));
ecritD(fenetre_dilution,dil_t_a1,cnt_temperature(t_b3));
ecritD(fenetre_dilution,dil_t_a2,cnt_temperature(t_pile));
ecritD(fenetre_dilution,dil_t_a3,cnt_temperature(t_a1));


//  les afficheurs analogiques de pression helium et pirani  

ecritD(fenetre_dilution,dil_RP_He,(int)(2500*val_multiplex(blk->ADC_dil[ RP_He])-7500));
//  je veux 10000 pour 0.8 bars  soit    alors que l'on a 5V pour 1 bar ou 1V = 0.2 bar
//  soit multiplier par 2500
// puis j'enleve 0.6 bars soit 7500 
ecritD(fenetre_dilution,dil_pirani,(int)(1000*val_multiplex(blk->ADC_dil[ pirani])));






//  ecriture des valeurs brutes de la dilution
if(litD(fenetre_dilution,dil_sortie_brute,0))
	{
	if(!fenetre(fenetre_dilution_lecture_brute)) nouveauT(fenetre_dilution_lecture_brute,0,"lecture dilution");

	ecritT(fenetre_dilution_lecture_brute,fin_f,"dil_switch= %x  \n",blk->switch_dil);

	for(i=0;i<16;i++)	ecritT(fenetre_dilution_lecture_brute,fin_f,"%2d=%6.3f ",i<8?i+11:i+13,val_multiplex(blk->ADC_dil[ i]));
	ecritT(fenetre_dilution_lecture_brute,fin_f,"\n");
	for(i=16;i<32;i++)	ecritT(fenetre_dilution_lecture_brute,fin_f,"%2d=%6.3f ",i<24?i+15:i+17,val_multiplex(blk->ADC_dil[ i]));
	ecritT(fenetre_dilution_lecture_brute,fin_f,"\n");
	for(i=32;i<48;i++)	ecritT(fenetre_dilution_lecture_brute,fin_f,"%2d=%6.3f ",i<40?i+19:i+21,val_multiplex(blk->ADC_dil[ i]));
	ecritT(fenetre_dilution_lecture_brute,fin_f,"\n");
	}
// lecture des sondes de niveau helium


	{
	double y[8];
	static int niveau_pre;
	int niveau,fin;
//	printf("dilution :  numero de block = %d  \n",numero_block(blk));
	changecontrole(fenetre_dilution,dil_niveau_helium,idem,idem,idem,idem,calrefcon(0,0,rouge,blanc,blanc),"");
	y[0]=val_multiplex(blk->ADC_dil[ j_he1])-calib(dil_j_he1);
	y[1]=val_multiplex(blk->ADC_dil[ j_he2])-calib(dil_j_he2);
	y[2]=val_multiplex(blk->ADC_dil[ j_he3])-calib(dil_j_he3);
	y[3]=val_multiplex(blk->ADC_dil[ j_he4])-calib(dil_j_he4);
	y[4]=val_multiplex(blk->ADC_dil[ j_he5])-calib(dil_j_he5);
	y[5]=val_multiplex(blk->ADC_dil[ j_he6])-calib(dil_j_he6);
	y[6]=val_multiplex(blk->ADC_dil[ j_he7])-calib(dil_j_he7);
	y[7]=val_multiplex(blk->ADC_dil[ j_he8])-calib(dil_j_he8);
	if(blk->switch_dil & switch_helium)
		{
		changecontrole(fenetre_dilution,dil_niveau_helium,idem,idem,idem,idem,calrefcon(0,0,rouge,blanc,blanc),"");
		niveau=0;fin=0;
		for(i=0;i<8;i++)
			{
			if(y[i]>0.1) 	{
					niveau++;
					if(fin) 	niveau=9;
					}
			else		fin=1;
			}
//		if(niveau==9)	changecontrole(fenetre_dilution,dil_niveau_helium,idem,idem,idem,idem
//					,calrefcon(0,0,jaune,blanc,blanc),"");
		if(niveau<niveau_pre)	niveau_pre=0;
		else	{niveau_pre=niveau;	ecritD(fenetre_dilution,dil_niveau_helium,niveau);}
//		printf("niveau=%d \n",niveau);
		}
	else	changecontrole(fenetre_dilution,dil_niveau_helium,idem,idem,idem,idem,calrefcon(0,0,vert,blanc,blanc),"");

	if(litD(fenetre_dilution,dil_trace_helium,0))// trace les sondes de niveau helium
		{
		int temps_cntl=numero_block(blk)*nb_per_block*2;
		double secondes,minutes;
		secondes=gg->periode_echantillonage*(double)temps_cntl;
		minutes=secondes/60.;
		if(!fenetre(fenetre_niveau_helium)) 
			{
			nouveauD(fenetre_niveau_helium,0,"niveau_helium",0);
			selectgra(fenetre_niveau_helium);
			strcpy(graph->xtitre,"minutes");
			}
		tracen(fenetre_niveau_helium,8,minutes,y);
		}
	}

}


