
/*======================================================================*/
/*                                                                      */
/* 		 arcunit.h  :	conversion en mesure physique               	*/
/*                                                                      */
/*======================================================================*/



/* ----------------------------   prototypes des fonctions	 ------------------------------ */
/* -------------------------------------------------------------------------------------------- */


double		bolo_muV	(param_bolo*	param_pt,	reglage_bolo*	reglage_pt, int valbrut,int indice_bolo);											
double		bolo_temp	(param_bolo*	param_pt,	reglage_bolo*	reglage_pt, double R,int indice_bolo);

double		DAC_muV		(param_bolo*	param_pt,	reglage_bolo*	reglage_pt, int indice_bolo);
double		DAC_muA		(param_bolo*	param_pt,	reglage_bolo*	reglage_pt, int indice_bolo);

int	voyant_EVO(block_type_dilution*	blk);
int	voyant_EVF(block_type_dilution*	blk);
int	commande_EVO(block_type_dilution*	blk);
int	commande_EVF(block_type_dilution*	blk);
int	commande_EVB(block_type_dilution*	blk);
int	commande_EVV(block_type_dilution*	blk);


double pression_entree_3He(block_type_dilution*	blk);	
double debit_3He(block_type_dilution*	blk)	;
double pression_sortie_3He(block_type_dilution*	blk)	;
double pression_entree_4He(block_type_dilution*	blk)	;
double debit_4He(block_type_dilution*	blk)	;
double pression_sortie_4He(block_type_dilution*	blk)	;
double pression_air_vanne(block_type_dilution*	blk)	;
double pression_pompe_charbon(block_type_dilution*	blk);	
double pression_membranne(block_type_dilution*	blk)	;
double pression_externe(block_type_dilution*	blk)	;
double tension_pile_10T(block_type_dilution*	blk)	;
double tension_pile_p18D(block_type_dilution*	blk)	;
double tension_pile_m18D(block_type_dilution*	blk)	;
double tension_pile_10B(block_type_dilution*	blk)	;
double tension_pile_p18B(block_type_dilution*	blk)	;
double tension_pile_m18B(block_type_dilution*	blk)	;
double tension_pile_Ch(block_type_dilution*	blk)	;
int switch_pile_5(block_type_dilution*	blk)	;
int switch_pile_15(block_type_dilution*	blk)	;
double	temperature_caisson_haut1(block_type_dilution*	blk)	;
double	temperature_caisson_haut2(block_type_dilution*	blk)	;
double	temperature_caisson_bas1(block_type_dilution*	blk)	;
double	temperature_caisson_bas2(block_type_dilution*	blk)	;
double	temperature_caisson_tube_helium(block_type_dilution*	blk)	;
double	temperature_caisson_piles(block_type_dilution*	blk)	;
double	temperature_caisson_driver_moteur(block_type_dilution*	blk)	;
double	pression_helium_bain(block_type_dilution*	blk)	;
double	pression_pirani(block_type_dilution*	blk)	;

double	resistance_service(param_bolo*	param_pt,	reglage_bolo*	reglage_pt, block_type_dilution*	blk, int indice_tempe);
double	temperature_service(param_bolo*	param_pt,	reglage_bolo*	reglage_pt, block_type_dilution*	blk, int indice_tempe);


/* 	cette fonction transforme un char (sur 8 bit) en double avec une echelle logarythmique	*/
/*	elle est en particulier utilise pour calculer les coef de la regul			*/

double		val_double(char x);

/* 	cette fonction transforme un char (sur 8 bit) en entier int4 (echelle logarythmique)	*/
/*	elle est en particulier utilise pour fixer le courant sur les bolometres		*/

unsigned 	int4	val_long(char x);

int			new_val_dac(int a,char  code); 



/* ----------------------------   define utilise pour les calculs	 ------------------------------ */


#define	bol_micro_volt(val,gain)	((1e7*(double)val)/(65536.*gain))
/*  avec  gain = (double)parametr.bolo[bolo].bolo_gain*gain_ampli(reglage.bolo[bolo])				*/
		

/* gains 0 .. 15 pour MLPA  ///   gain 16..19  pour BEBO   ///   gain 20..22  pour BEDIF	*/		
#define	def_gains	double gains_reels[32]={1,2,4,8,10,20,40,80,100,200,400,800,1000,2000,4000,8000,0.5,2.5,10,50,0.93,3.777,18.974};
		/*			gain bediff    10->9.3    40->37.77     200->189.74		*/

#define		gain_ampli(aa)	gains_reels[gainbrut(aa)]		



#define bit_piles_5V	1
#define bit_piles_15V	2
#define bit_piles_auto	4


/*      signification des bit lus dans switch_dil	*/
#define	switch_EVF		0x00000080	/*	contact fin de course vanne fermee	*/
#define	switch_EVO		0x00000040	/*	contact fin de course vanne ouverte	*/

/* les bit suivants sont envoys par telecommande et relus dans switch_dil	*/
#define	switch_helium		0x00200000	/*  13: commande sond niveau helium	*/
#define switch_pile_par_5	0x00100000	/*  12: mise en parallele des piles pour le 5V	*/
#define switch_pile_par_15	0x00080000	/*  11: mise en parallele des piles pour le 15V	*/
#define vanne_EVB		0x00008000	/*  7: commande vanne brooks	*/
#define vanne_EVO		0x00010000	/*  8: commande vanne EVO	*/
#define vanne_EVV		0x00020000	/*  9: commande vanne EVV	*/
#define vanne_EVF		0x00040000	/*  10: commande vanne EVF	*/
#define chauffage1		0x00004000	/*  6: chauffage 1	*/
#define chauffage2		0x00002000	/*  5: chauffage 1	*/
#define chauffage3		0x00001000	/*  4: chauffage 1	*/
#define chauffage4		0x00000800	/*  3: chauffage 1	*/
#define chauffage5		0x00000400	/*  2: chauffage 1	*/
#define chauffage6		0x00000200	/*  1: chauffage 1	*/
#define chauffage7		0x00000100	/*  0: chauffage 7	*/

enum{nbit_chauffage7,nbit_chauffage6,nbit_chauffage5,nbit_chauffage4,nbit_chauffage3
	,nbit_chauffage2,nbit_chauffage1,nbit_vanne_EVB,nbit_vanne_EVO
	,nbit_vanne_EVV,nbit_vanne_EVF,nbit_switch_pile_par_15,nbit_switch_pile_par_5,nbit_switch_helium};

/*  position des mesures sur les multiplexeurs		*/
/* J10A  ->  temperatures basses t_b1 t_b2,t_b3 t_b4 36 37 41 35	*/ 
/* J10B  ->  temperatures basses t_a1 t_a2,t_a3 t_a4 38 11 34 28	*/ 
/* J1??	 ->  temperatures hautes t_h1 t_h2,t_h3 t_h4	*/ 

enum{
/* multiplex11..18:*/	mul11_	,mul12_	,p_haut	,p_memb	,t_h1	,t_h4	,t_h3	,t_h2	
/* multiplex21..28:*/,	mul21_	,mul22_	,p_charb,p_R4	,mul25_	,p_C3	,p_R3	,t_a4	
/* multiplex31..38:*/,	mul31_	,p_C4	,p_air	,t_a3	,t_b4	,t_b1	,t_b2	,t_a1	
/* multiplex41..48:*/,	t_b3	,d_4He	,RP_He	,t_pile	,d_3He	,j_he3	,j_he7	,j_he4	
/* multiplex51..58:*/,	j_he5	,j_he1	,j_he8	,j_he2	,j_he6	,pirani	,mul57	,mul58	
/* multiplex61..68:*/,	p_m18B	,p_10B	,p_m18D	,mul64	,p_p18B	,p_10T	,p_Ch	,p_p18D		
	};
	
/* mul 11 , 12 , 21 , 31 , 25  sont les pins inutilises  4  , 9 , 8 , 7 , 6  du connecteur pression hautes		*/
/* mul 22  est la pin 9 inutilises  du connecteur pression basses		*/
/* mul 57 et 58  sont les lesctures des deux amplis mesure sur la prise gyroscope    */
/*  mul 64 est non cablee  (entree en l'air)  		*/
/* reste libres :  mul   11 - 12 - 21 - 22 - 25 -  31 - 57 - 58 - 64	*/

/*  t_a2   n'est pas cable (que 3 thermometres sur connecteur ta (J10A)  )*/
/*  t_a1   est cable sur J10A mais est aussi  la temperature du driver de moteur de pivot   */

#define  val_multiplex(qq)	(0.0003052*(double)((qq)-0x8000))	
#define  val_temperature(qq)	((val_multiplex(qq)<0.2)?-99:((1146.3/(val_multiplex(qq)-0.1)) - 245.13))


