
#include "manip.h"      
#include "archeops.h"
#include "arcunit.h"

/**************************************************************************************/
/*                                                                                    */
/*          programme  contenant les conversions en mesure physique                   */
/*                                                                                    */
/*                                                                                    */
/*                                                                                    */
/**************************************************************************************/


/* ----------------   block  dilution     ---------------------------------------------  */


int	voyant_EVO(block_type_dilution*	blk)	{return((blk->switch_dil&switch_EVO)?0:1);}
int	voyant_EVF(block_type_dilution*	blk)	{return((blk->switch_dil&switch_EVF)?0:1);}
int	commande_EVO(block_type_dilution*	blk)	{return((blk->switch_dil&vanne_EVO)?0:1);}
int	commande_EVF(block_type_dilution*	blk)	{return((blk->switch_dil&vanne_EVF)?0:1);}
int	commande_EVB(block_type_dilution*	blk)	{return((blk->switch_dil&vanne_EVB)?0:1);}
int	commande_EVV(block_type_dilution*	blk)	{return((blk->switch_dil&vanne_EVV)?0:1);}


// les pressions et debits metres des injections de la dilution
double pression_entree_3He(block_type_dilution*	blk)	
		{return(40. *	val_multiplex(blk->ADC_dil[ p_R3])  -1.6);}	//	200 bars pour 5V et 1.6 bar d'offset

double debit_3He(block_type_dilution*	blk)	
		{return(2. 	* 	val_multiplex(blk->ADC_dil[ d_3He]) );}		//  10 MICRO MOLES  pour  5V

double pression_sortie_3He(block_type_dilution*	blk)	
		{return(20. 	*	val_multiplex(blk->ADC_dil[ p_C3]) );}		//	100 bars pour 5V
	
double pression_entree_4He(block_type_dilution*	blk)	
		{return(40. 	*	val_multiplex(blk->ADC_dil[ p_R4])) ;}		//	200 bars pour 5V

double debit_4He(block_type_dilution*	blk)	
		{return(8. 	* 	val_multiplex(blk->ADC_dil[ d_4He]))	 ;}	//  40 MICRO MOLES  pour  5V
//	,4. 	* 	val_multiplex(blk->ADC_dil[ d_4He])		//  20 MICRO MOLES  pour  5V

double pression_sortie_4He(block_type_dilution*	blk)	
		{return(20. 	*	val_multiplex(blk->ADC_dil[ p_C4]) );}		//	100 bars pour 5V
	


double pression_air_vanne(block_type_dilution*	blk)	
		{return(20.*val_multiplex(blk->ADC_dil[ p_air]));}
		
double pression_pompe_charbon(block_type_dilution*	blk)	
		{return(20.*val_multiplex(blk->ADC_dil[ p_charb]));}
		

double pression_membranne(block_type_dilution*	blk)	
		{return(0.2*val_multiplex(blk->ADC_dil[ p_memb]));}
		
		
double pression_externe(block_type_dilution*	blk)	
		{return(0.2*val_multiplex(blk->ADC_dil[ p_haut]));}

			
		
double tension_pile_10T(block_type_dilution*	blk)	
		{return(2.03*val_multiplex(blk->ADC_dil[ p_10T]));}
				
double tension_pile_p18D(block_type_dilution*	blk)	
		{return(3.90*val_multiplex(blk->ADC_dil[ p_p18D]));}
				
double tension_pile_m18D(block_type_dilution*	blk)	
		{return(3.90*val_multiplex(blk->ADC_dil[ p_m18D]));}
				
double tension_pile_10B(block_type_dilution*	blk)	
		{return(2.03*val_multiplex(blk->ADC_dil[ p_10B]));}
				
double tension_pile_p18B(block_type_dilution*	blk)	
		{return(3.90*val_multiplex(blk->ADC_dil[ p_p18B]));}
				
double tension_pile_m18B(block_type_dilution*	blk)	
		{return(3.90*val_multiplex(blk->ADC_dil[ p_m18B]));}
				
double tension_pile_Ch(block_type_dilution*	blk)	
		{return(3.8*val_multiplex(blk->ADC_dil[ p_Ch]));}


				
int switch_pile_5(block_type_dilution*	blk)	
		{return((blk->switch_dil&switch_pile_par_5)?1:0);}
int switch_pile_15(block_type_dilution*	blk)	
		{return((blk->switch_dil&switch_pile_par_15)?1:0);}


double	temperature_caisson_haut1(block_type_dilution*	blk)
		{return(val_temperature(blk->ADC_dil[ t_h2]));}
		
double	temperature_caisson_haut2(block_type_dilution*	blk)
		{return(val_temperature(blk->ADC_dil[ t_h4]));}
		
double	temperature_caisson_bas1(block_type_dilution*	blk)
		{return(val_temperature(blk->ADC_dil[ t_b1]));}
		
double	temperature_caisson_bas2(block_type_dilution*	blk)
		{return(val_temperature(blk->ADC_dil[ t_b2]));}
		
double	temperature_caisson_tube_helium(block_type_dilution*	blk)
		{return(val_temperature(blk->ADC_dil[ t_b3]));}
		
double	temperature_caisson_piles(block_type_dilution*	blk)
		{return(val_temperature(blk->ADC_dil[ t_pile]));}
		
double	temperature_caisson_driver_moteur(block_type_dilution*	blk)
		{return(val_temperature(blk->ADC_dil[ t_a1]));}
		
double	pression_helium_bain(block_type_dilution*	blk)
		{return( 0.2*val_multiplex(blk->ADC_dil[ RP_He]));}
		
double	pression_pirani(block_type_dilution*	blk)
		{return(val_multiplex(blk->ADC_dil[ pirani]));}



#define	c(j,i)		(1e-4*(double)param_pt->nom_coef[param_pt->bolo[j].numero_nom_coef].coef[i])	

// les temperatures sur les cartes modifies

double	resistance_service(param_bolo*	param_pt,	reglage_bolo*	reglage_pt, block_type_dilution*	blk, int indice_tempe)
{
double I,V,R;
int j,k;
def_gains;
k=0;

for(j=0;(j<nb_max_bolo) && (k<4);j++)
	{
	if(param_pt->bolo[j].bolo_code_util==bolo_thermo_simplifie)
		{
		if(k==indice_tempe)
			{
			I = 1e-3 * (double)dac_V(reglage_pt->bolo[j]) * 2441. / param_pt->bolo[j].bolo_capa;	//	I en A
			V=0.001*bol_micro_volt(blk->temperature[k],(double)param_pt->bolo[j].bolo_gain*gain_ampli(reglage_pt->bolo[j]));
			if(I>0.0000001)		R=V/I;	else	R=0;				//	R  en 
			return(R);
			}
		k++;		
		}
	}
return(0);
}



double	temperature_service(param_bolo*	param_pt,	reglage_bolo*	reglage_pt, block_type_dilution*	blk, int indice_tempe)
{
double I,V,R,T,llR;
int j,k;
def_gains;
k=0;

for(j=0;(j<nb_max_bolo) && (k<4);j++)
	{
	if(param_pt->bolo[j].bolo_code_util==bolo_thermo_simplifie)
		{
		if(k==indice_tempe)
			{
			I = 1e-3 * (double)dac_V(reglage_pt->bolo[j]) * 2441. / param_pt->bolo[j].bolo_capa;	//	I en A
			V=0.001*bol_micro_volt(blk->temperature[k],(double)param_pt->bolo[j].bolo_gain*gain_ampli(reglage_pt->bolo[j]));
			if(I>0.0000001)		R=V/I;	else	R=0;				//	R  en 
 //------  calcul de l'etalonnage en temperature des cartes temperature simplifies  
 // j=numero de bebo	T[k] = R[k+4] en Kelvin
			if ((R-c(j,6))>1.) 
				{if((log(R-c(j,6))-c(j,0))>0.001) llR= log(log(R-c(j,6))-c(j,0)) ; else llR=0; 
//				printf("\nk=%d j=%d R=%g c2=%g c3=%g llR=%g",k,j,R[k],c(j,2),c(j,3),llR);
				} 
			else llR=0;
			T	= exp( 	c(j,1) + c(j,2)* llR + c(j,3)* llR* llR + c(j,4)* llR* llR* llR + c(j,5)* llR* llR* llR* llR) ; 
			if(T>9999) T=9999;
			return(T);
			}
		k++;		
		}
	}
return(0);
}

#undef c



/**********  coefficients  pour  les  mesures  bolo    **********************************/
/*                         toutes les puissances en pW                                  */
/*	-1-	loi de reponse thermique des bolos  avec R en ohms et T en Kelvin               */
/*                                                                                      */
/* 	T =  coef2  *   (   ln (  R / coef1) **  ( -1 / coef0 )                             */
/*                                                                                      */
/*	-2-	fuite thermique du bolo   coef 3,4                                              */
/*                                                                                      */
/*	Ptot =  coef3  *  ( (10*Tb) ** coef4    -    (10*Tcryo)  **  coef4 )                */
/*                                                                                      */
/*	-3-	calcul empirique de Pciel et de  tau	  coef  5,6                             */
/*                                                                                      */
/*	Pciel	=	coef5	- Pelec		coef5= I * Ai (tables xavier) 	                    */
/*	tau	=	- ln ( 1 +  Pciel / coef6 )	coef6= I * Bi (tables xavier)                   */
/*   										                                            */
/* Pour les thermometres 1  4 (germanium et carbone Allan-Bradley) 		            */
/* les coefficients sont utiliss differemment, ils permettent de convertir	            */
/* R vers T		( c(6) est un offset sur la mesure de R par rapport  aux mesures 4 fils)*/
/*   llR= log(log(R - c(6))-c(0))  						                                */
/*    T	= exp(c(1) + c(2)* llR + c(3)* llR* llR + c(4)* llR* llR* llR +                 */
/*            c(5)* llR* llR* llR* llR)                                                 */
/*										                                                */
/*	version vol Trapani									                                */
/*	on corrige le biais de temperature coef2=1.1 old,  coef3=old/1.1^coef4	            */
/*										                                                */
/*										                                                */
/*										                                                */
/*										                                                */
/*										                                                */
/****************************************************************************************/




/* ------------------------------------   corps  des fonctions	 ------------------------------ */
/* -------------------------------------------------------------------------------------------- */




double		DAC_muV		(param_bolo*	param_pt,	reglage_bolo*	reglage_pt, int indice_bolo)
{
double div,car;
car= (double)dac_V(reglage_pt->bolo[indice_bolo])  ;
div=(double)param_pt->bolo[indice_bolo].bolo_diviseur;
if(div) return (car *2441. /  div );					
else	return(0);
}



double		DAC_muA		(param_bolo*	param_pt,	reglage_bolo*	reglage_pt, int indice_bolo)
{
double capa,tri;
tri= (double)dac_I(reglage_pt->bolo[indice_bolo])  ;
capa=((param_pt->bolo[indice_bolo].bolo_bebo==10)?0.000868 * (double)param_pt->bolo[indice_bolo].bolo_capa:0.001 * (double)param_pt->bolo[indice_bolo].bolo_capa);
		/* capa en pF	*/
return (tri * capa / (4096. * 22. * 20.) );					
}


double		bolo_muV	(param_bolo*	param_pt,	reglage_bolo*	reglage_pt, int valbrut,int indice_bolo)										
{
double x;
int nb_coups;
int aa;
def_gains

nb_coups= reglage_pt->horloge.nb_mesures/2 - reglage_pt->horloge.temp_mort;

aa = (nb_coups<<14) + (nb_coups*190) ;
x=((double)((valbrut-aa)<<1))/(double)nb_coups;
x=	bol_micro_volt(x,(double)param_pt->bolo[indice_bolo].bolo_gain*gain_ampli(reglage_pt->bolo[indice_bolo]));
return(x);
}




#define	c(i)		(1e-4*(double)param_pt->nom_coef[param_pt->bolo[indice_bolo].numero_nom_coef].coef[i])	

double		bolo_temp	(param_bolo*	param_pt,	reglage_bolo*	reglage_pt, double R,int indice_bolo)
{
double a,T;
a=1;	if( (R>0) && (c(1) >0.01) )		a= log ( R / c(1) );
T=0;	if( (a>0) && (c(0)>0.01) )		T= c(2) * pow( a , -1 / c(0) );
return(T);
}

#undef c




/* -------------------------------------------------------------  */


unsigned int4	val_long(char x)
{
unsigned long a,xl;
char aa;
aa=x-2;
a=aa;
if(x<3)  xl=x;	else	xl=((a&1) + 2)<<(a>>1);
return(xl);
}


double	val_double(char x)
{
unsigned long a,xl;
if(x<0) x=-x;	a=x;	if(!a)  xl=0;	else	xl=((a&1) + 2)<<(a>>1);
if(x>0)	return(1e-4*(double)xl);	else	return(-1e-4*(double)xl);
}

int	new_val_dac(int a,char  code)
{
if(code&0x80)	a=(code&0x7f) <<5 ;
else	{
	if(code&0x40)	a+=code&0x3f;	
	else		a-=code&0x3f;	
	}
return(a);
}

