
/************************************************************************/
/*******   							*********/
/*******   	compresseur de donnes ranges en ligne		*********/
/*******  			 				*********/
/************************************************************************/




/*  	comprime une suite de n valeures  (dans des mots de 32 bit)	*/
/*  		valeures  codes sur 22 bit maximum			*/
/*	resultat de la compression cod sur 7 bit + exposant		*/
/*	n doit etre multiple de  4					*/
/*	le fichier resultat a pour longueur   n/4 + 1 mot de 32 bit	*/
/*		4 * n  octets   ==>	n + 4 octets			*/
/*	pour 	n = 72	  en sortie	19 mots = 76 octets		*/

void compress_7_1(unsigned long* in,unsigned long*out,int n,int pasin);
void decompress_7_1(long* in,long*out,int n);


/*  	comprime une suite de n valeures  (dans des mots de 32 bit)	*/
/*  		valeures  codes sur 16 bit maximum			*/
/*	resultat de la compression cod sur 4 bit + exposant		*/
/*	n doit etre  ( multiple de  7 )  + 2				*/
/*	le fichier resultat a pour longueur   (n-2)/7 + 1 mot de 32 bit	*/
/*		4 * n  octets   ==>	4 * (n-2) / 7 + 4  octets	*/
/*	pour 	n = 72	  en sortie	11 mots = 44 octets		*/

void compress_4_1(unsigned long* in,unsigned long*out,int n,int pasin);
void decompress_4_1(long* in,long*out,int n);


/*  	comprime une suite de n valeures  (dans des mots de 32 bit)	*/
/*  		valeures  codes sur 16 bit maximum			*/
/*	resultat de la compression cod sur 3 bit + exposant		*/
/*	n doit etre  ( multiple de  9 )					*/
/*	le fichier resultat a pour longueur   n/9 + 1 mot de 32 bit	*/
/*		4 * n  octets   ==>	4 * n / 9 + 4  octets		*/
/*	pour 	n = 72	  en sortie	9 mots = 36 octets		*/


void compress_3_1(unsigned long* in,unsigned long*out,int n,int pasin);
void decompress_3_1(long* in,long*out,int n);

/************************************************************************/
/***********   							*********/
/***********   compresseur de donnes ranges par paires	*********/
/***********		(data bolo par exemple)			*********/
/***********   			 				*********/
/************************************************************************/



/*  	comprime une suite de n valeures  (dans des mots de 32 bit)	*/
/*  		valeures  codes sur 21 bit maximum			*/
/*	resultat de la compression cod sur 7 bit + exposant		*/
/*	n doit etre multiple de  4					*/
/*	le fichier resultat a pour longueur   n/4 + 1 mot de 32 bit	*/
/*		4 * n  octets   ==>	n + 4 octets			*/
/*	pour 	n = 72	  en sortie	19 mots = 76 octets		*/


void compress_7_2(unsigned long* in,unsigned long*out,int n,int pasin);
void decompress_7_2(long* in,long*out,int n);



/*  	comprime une suite de n valeures  (dans des mots de 32 bit)	*/
/*  		valeures  codes sur 32 bit maximum			*/
/*	resultat de la compression cod sur 4 bit + exposant		*/
/*	n doit etre  ( multiple de  7 )  + 2				*/
/*	le fichier resultat a pour longueur   (n-2)/7 + 2 mot de 32 bit	*/
/*		4 * n  octets   ==>	4 * (n-2) / 7 + 8  octets	*/
/*	pour 	n = 72	  en sortie	12 mots = 48 octets		*/



void compress_4_2(unsigned long* in,unsigned long*out,int n,int pasin);
void decompress_4_2(long* in,long*out,int n);


																						
/************************************************************************/
/***********   							*********/
/***********   	definitions communes pour les compresseurs	*********/
/***********   			 				*********/
/************************************************************************/

/*	tous les nombres sont des entiers unsigned long pour compress				*/
/*Les valeures de la table d'entree sont consideres comme toujours positives et sur 21 bits	*/
/*  les valeurs de reference pour le calcul des ecarts sont augmentees de ecart_bit=0x10000000	*/
/*	LES ECARTS SONT DES ENTIERS POSITIFS (ecart_bit +  valeur courante - valeur precedente) */

/*  pour tous les compresseurs	*/
#define kmax_	15		/*  valeur maximum de l'exposant	*/
#define	ecart_bit	0x10000000
#define	shif(ec,k,q)	{while(ec>(q|ecart_bit))if(k<kmax_){k++;q<<=1;}else ec=(q|ecart_bit);while(ec<ecart_bit-q)if(k<kmax_){k++;q<<=1;}else ec=ecart_bit-q;}
#define	arrondi(ec,k)	((ec &  filtre[k]) +( (ec & test[k]) <<1 ) ) /* resultat sur 28 bit  */	
#define new_val(val,ec,k)	((val + arrondi(ec,k))&data_mask);

/* pour les decompresseurs	*/
#define	recup(ec,sss,k) {ec=((R>>sss)&ecart_mask);if(ec & sgbi_ ) ec|= sign_ ; ec<<=k;}

