#include "manip.h"
#include "compress.h"


/*******************************************************************************************/
/****************   			 					************/
/****************   			 		compress_3		************/
/****************   			 					************/
/*******************************************************************************************/

static int filtre[16]={0xfffffff,0xffffffe,0xffffffc,0xffffff8,
		0xffffff0,0xfffffe0,0xfffffc0,0xfffff80,
		0xfffff00,0xffffe00,0xffffc00,0xffff800,
		0xffff000,0xfffe000,0xfffc000,0xfff8000};
int test[16]=  {0x00000000,0x00000001,0x00000002,0x00000004,
		0x00000008,0x00000010,0x00000020,0x00000040,
		0x00000080,0x00000100,0x00000200,0x00000400,
		0x00000800,0x00001000,0x00002000,0x00004000};


void  com_3(unsigned long val,unsigned long* in,unsigned long*out,int n,int pasin);

#define	data_mask	0xffff	/* masque pour les donnes en entree	*/
#define	ecart_(i,n,val)		(( (in[(i*9+n)*pasin]&data_mask) | ecart_bit )-val);

#define	ecart_mask		0x7	/*	masque pour l'ecart		*/		



/*  compress un tableau in de n*9 points dispos avec un pas pasin	*/
/*  les data compresses sont ecrites dans le tableau out de n points	*/
/*  la valeur val est la valeur de reference du point origine		*/


/*  comprime	9*n points  : 1er point dans 1er mot			*/
/*			      tous les ecarts dans les n mots suivants	*/ 
/*	9*n	==>	n+1	    pour  72 points :   9 mots		*/

void compress_3_1(unsigned long* in,unsigned long*out,int n,int pasin)
{
unsigned long val;
val=in[0]; out[0]=val;
com_3(val,in,out+1,n/9,pasin);
}




void  com_3(unsigned long val,unsigned long* in,unsigned long*out,int n,int pasin)
{
unsigned long val1;
unsigned long ec1,ec2,ec3,ec4,ec5,ec6,ec7,ec8,ec9;
int i,k,k1;unsigned long q;


for(i=0;i<n;i++)
	{
	k=0;q=3;	/* 3 bit = 7 = +-3	*/

	ec1=ecart_(i,0,val);
	shif(ec1,k,q);
	val1=new_val(val,ec1,k);
	
	k1=k;
	ec2=ecart_(i,1,val1);
	shif(ec2,k,q);
	
	if(k>k1)	{k1=k;val1=new_val(val,ec1,k);}
	val1=new_val(val1,ec2,k);

	ec3=ecart_(i,2,val1);
	shif(ec3,k,q);

	if(k>k1)	{k1=k;val1=(val + arrondi(ec1,k) + arrondi(ec2,k))&data_mask;}
	val1=new_val(val1,ec3,k);

	ec4=ecart_(i,3,val1);
	shif(ec4,k,q);

	if(k>k1)	{k1=k;val1=(val + arrondi(ec1,k) + arrondi(ec2,k) + arrondi(ec3,k))&data_mask;}
	val1=new_val(val1,ec4,k);

	ec5=ecart_(i,4,val1);
	shif(ec5,k,q);

	if(k>k1)	{k1=k;val1=(val + arrondi(ec1,k) + arrondi(ec2,k) + arrondi(ec3,k) 
				+ arrondi(ec4,k))&data_mask;}
	val1=new_val(val1,ec5,k);
	
	ec6=ecart_(i,5,val1);
	shif(ec6,k,q);

	if(k>k1)	{k1=k;val1=(val + arrondi(ec1,k) + arrondi(ec2,k) + arrondi(ec3,k)
					+ arrondi(ec4,k) + arrondi(ec5,k))&data_mask;}
	val1=new_val(val1,ec6,k);
	
	ec7=ecart_(i,6,val1);
	shif(ec7,k,q);

	if(k>k1)	{k1=k;val1=(val + arrondi(ec1,k) + arrondi(ec2,k) 
				+ arrondi(ec3,k) + arrondi(ec4,k) + arrondi(ec5,k) + arrondi(ec6,k))&data_mask;}
	val1=new_val(val1,ec7,k);
	
	ec8=ecart_(i,7,val1);
	shif(ec8,k,q);

	if(k>k1)	{k1=k;val1=(val + arrondi(ec1,k) + arrondi(ec2,k) + arrondi(ec3,k)
					 + arrondi(ec4,k) + arrondi(ec5,k) + arrondi(ec6,k) + arrondi(ec7,k))&data_mask;}
	val1=new_val(val1,ec8,k);
	
	ec9=ecart_(i,8,val1);
	shif(ec9,k,q);
	
/*printf("i=%d  k=%d  ec= %d %d %d \n",i,k,ec1,ec2,ec3,out[(i+8)/7]);	*/

	ec1 =  arrondi(ec1,k) >> k;
	ec2 =  arrondi(ec2,k) >> k;
	ec3 =  arrondi(ec3,k) >> k;
	ec4 =  arrondi(ec4,k) >> k;
	ec5 =  arrondi(ec5,k) >> k;
	ec6 =  arrondi(ec6,k) >> k;
	ec7 =  arrondi(ec7,k) >> k;
	ec8 =  arrondi(ec8,k) >> k;
	ec9 =  arrondi(ec9,k) >> k;

	out[i]= ((ec1&ecart_mask)<<29) | ((ec2&ecart_mask)<<26) | ((ec3&ecart_mask)<<23) 
		| ((ec4&ecart_mask)<<20) | ((ec5&ecart_mask)<<17) | ((ec6&ecart_mask)<<14)
		| ((ec7&ecart_mask)<<11)  | ((ec8&ecart_mask)<<8) | ((ec9&ecart_mask)<<5) | k ;


/*	if(i<30)  printf("i=%d  k=%d  ec= %d %d %d \n",i,k,ec1,ec2,ec3,out[(i+8)/7]);*/

	val=(val + ( (ec1 + ec2 + ec3 + ec4 + ec5 + ec6 + ec7 + ec8 + ec9 ) << k )) & data_mask;
	}
}



/*******************************************************************************************/
/****************   			 											*****************/
/****************   			 		compress_4							*****************/
/****************   			 											*****************/
/*******************************************************************************************/

void  com_4(unsigned long val,unsigned long* in,unsigned long*out,int n,int pasin);
void  com_4_paire(unsigned long val1,unsigned long val2,unsigned long* in,unsigned long*out,int n,int pasin);


#undef	ecart_mask		
#define	ecart_mask	0xf		/*	masque pour l'ecart		*/		

#undef	data_mask
#define	data_mask	0xffff	/* masque pour les donnes en entree	*/
#undef	ecart_
#define	ecart_(i,n,val)		(( (in[(i*7+n)*pasin]&data_mask) | ecart_bit )-val);


/*  compress un tableau in de n*7 points dispos avec un pas pasin	*/
/*  les data compresses sont ecrites dans le tableau out de n points*/
/*  la valeur val est la valeur de reference du point origine*/


/*  comprime	7*n + 2  points  (de 16 bit chacun)  					*/
/*	1er et 2 eme point dans 1er mot, les ecarts dans les n mots suivants*/ 
/*	7*n + 2	==>	n+1	     ==>   pour  72 points :   11 mots  			*/

void compress_4_1(unsigned long* in,unsigned long*out,int n,int pasin)
{
unsigned long val1,val2;
val1=in[0];val2=in[1];
*out=( (val1<<16) & 0xffff0000 )	|	( ( val2 ) & 0xffff ) ;

com_4(val2,in+2,out+1,n/7,pasin);
}



void  com_4(unsigned long val,unsigned long* in,unsigned long*out,int n,int pasin)
{
unsigned long val1;
unsigned long ec1,ec2,ec3,ec4,ec5,ec6,ec7;
int i,k,k1;unsigned long q;


for(i=0;i<n;i++)
	{
	k=0;q=7;	/* 4 bit = 15 = +-7	*/

	ec1=ecart_(i,0,val);
	shif(ec1,k,q);
	val1=new_val(val,ec1,k);
	
	k1=k;
	ec2=ecart_(i,1,val1);
	shif(ec2,k,q);
	
	if(k>k1)	{k1=k;val1=(val + arrondi(ec1,k))&data_mask;}
	val1=new_val(val1,ec2,k);

	ec3=ecart_(i,2,val1);
	shif(ec3,k,q);

	if(k>k1)	{k1=k;val1=(val + arrondi(ec1,k) + arrondi(ec2,k))&data_mask;}
	val1=new_val(val1,ec3,k);

	ec4=ecart_(i,3,val1);
	shif(ec4,k,q);

	if(k>k1)	{k1=k;val1=(val + arrondi(ec1,k) + arrondi(ec2,k) + arrondi(ec3,k))&data_mask;}
	val1=new_val(val1,ec4,k);

	ec5=ecart_(i,4,val1);
	shif(ec5,k,q);

	if(k>k1)	{k1=k;val1=(val + arrondi(ec1,k) + arrondi(ec2,k) + arrondi(ec3,k) + arrondi(ec4,k))&data_mask;}
	val1=new_val(val1,ec5,k);
	
	ec6=ecart_(i,5,val1);
	shif(ec6,k,q);

	if(k>k1)	{k1=k;val1=(val + arrondi(ec1,k) + arrondi(ec2,k) + arrondi(ec3,k)
					 + arrondi(ec4,k) + arrondi(ec5,k))&data_mask;}
	val1=new_val(val1,ec6,k);
	
	ec7=ecart_(i,6,val1);
	shif(ec7,k,q);
	
/*printf("i=%d  k=%d  ec= %d %d %d \n",i,k,ec1,ec2,ec3,out[(i+8)/7]);*/

	ec1 =  arrondi(ec1,k) >> k;
	ec2 =  arrondi(ec2,k) >> k;
	ec3 =  arrondi(ec3,k) >> k;
	ec4 =  arrondi(ec4,k) >> k;
	ec5 =  arrondi(ec5,k) >> k;
	ec6 =  arrondi(ec6,k) >> k;
	ec7 =  arrondi(ec7,k) >> k;

	out[i]= ((ec1&ecart_mask)<<28) | ((ec2&ecart_mask)<<24) | ((ec3&ecart_mask)<<20) 
				| ((ec4&ecart_mask)<<16) | ((ec5&ecart_mask)<<12) | ((ec6&ecart_mask)<<8) | ((ec7&ecart_mask)<<4) | k ;


/*	if(i<30)  printf("i=%d  k=%d  ec= %d %d %d \n",i,k,ec1,ec2,ec3,out[(i+8)/7]);*/

	val=(val+ ( (ec1 + ec2 + ec3 + ec4 + ec5 + ec6 + ec7 ) << k ))&data_mask;
	}
}

/********************************************************************************************/

/*  compresse en 4 bit mais par paire (pour data provenant de la detection synchrone)		*/

/*     21 bit maleur maximum			*/
/*  comprime	7*n+2 points  : 1er et 2eme point dans 1er et 2eme mot, suite dans n mots	*/
/*		diffrences entre valeures paires  et entre valeures impaires uniquement			*/ 
/*	7*n+2	==>	n+2			==>  pour 72 points :		12 mots								*/

#undef	data_mask
#define	data_mask	0x1fffff	/* masque pour les donnes en entree 21 bit	*/
#undef	ecart_
#define	ecart_(i,n,val)		(( (in[(i*7+n)*pasin]&data_mask) | ecart_bit )-val);

void compress_4_2(unsigned long* in,unsigned long*out,int n,int pasin)
{
unsigned long val1,val2;
val1=in[0]&data_mask;		val2=in[1]&data_mask;
out[0]=val1;	out[1]=val2;
com_4_paire(val1,val2,in+2,out+2,n/7,pasin);
}


void  com_4_paire(unsigned long val1,unsigned long val2,unsigned long* in,unsigned long*out,int n,int pasin)
{
unsigned long val1p,val2p;
unsigned long ec1,ec2,ec3,ec4,ec5,ec6,ec7;
int i,k,k1;unsigned long q;


for(i=0;i<n;i++)
	{
	k=0;q=7;	/* 4 bit = 15 = +-7	*/

	ec1=ecart_(i,0,val1);
	shif(ec1,k,q);
	
	ec2=ecart_(i,1,val2);
	shif(ec2,k,q);
	
	k1=k;
	val1p=new_val(val1,ec1,k);


	ec3=ecart_(i,2,val1p);
	shif(ec3,k,q);

	val2p=new_val(val2,ec2,k);

	ec4=ecart_(i,3,val2p);
	shif(ec4,k,q);

	if(k>k1)	{k1=k;val1p=new_val(val1,ec1,k);val2p=new_val(val2,ec2,k);}
	
	val1p=new_val(val1p,ec3,k);		

	ec5=ecart_(i,4,val1p);
	shif(ec5,k,q);

	if(k>k1)	{	k1=k;
				val1p=(val1 + arrondi(ec1,k) + arrondi(ec3,k))&data_mask;
				val2p=(val2 + arrondi(ec2,k))&data_mask;
				}
	val2p=new_val(val2p,ec4,k);		
	
	ec6=ecart_(i,5,val2p);
	shif(ec6,k,q);

	if(k>k1)	{	k1=k;
				val1p=(val1 + arrondi(ec1,k) + arrondi(ec3,k))&data_mask;
				val2p=(val2 + arrondi(ec2,k) + arrondi(ec4,k))&data_mask;
				}
	val1p=new_val(val1p,ec5,k);		
	
	ec7=ecart_(i,6,val1p);
	shif(ec7,k,q);
	
/*printf("i=%d  k=%d  ec= %d %d %d \n",i,k,ec1,ec2,ec3,out[(i+8)/7]);*/

	ec1 =  arrondi(ec1,k) >> k;
	ec2 =  arrondi(ec2,k) >> k;
	ec3 =  arrondi(ec3,k) >> k;
	ec4 =  arrondi(ec4,k) >> k;
	ec5 =  arrondi(ec5,k) >> k;
	ec6 =  arrondi(ec6,k) >> k;
	ec7 =  arrondi(ec7,k) >> k;

	out[i]= ((ec1&ecart_mask)<<28) | ((ec2&ecart_mask)<<24) | ((ec3&ecart_mask)<<20) 
				| ((ec4&ecart_mask)<<16) | ((ec5&ecart_mask)<<12) | ((ec6&ecart_mask)<<8) | ((ec7&ecart_mask)<<4) | k ;


/*	if(i<30)  printf("i=%d  k=%d  ec= %d %d %d \n",i,k,ec1,ec2,ec3,out[(i+8)/7]);*/

	val1p = (val1 + ( (ec1 + ec3 + ec5 + ec7 ) << k ))&data_mask;
	val1= (val2 + ( (ec2 + ec4	+ ec6 ) << k ))&data_mask;
	val2 = val1p;
	}
}





/*******************************************************************************************/
/****************   			 											*****************/
/****************   			 		compress_7							*****************/
/****************   			 											*****************/
/*******************************************************************************************/

/*******************************************************************************************/

/*  compresse en 7 bit mais par paire (pour data provenant de la detection synchrone      */

/* ne prend que les 21 bit de poid faible dans le mot en entree			*/
/*  comprime	4*n points  : 1er et 2eme point dans 1er mot (16 bit chacun),  suite dans n mots		*/
/*		diffrences entre valeures paires  et entre valeures impaires uniquement			*/ 
/*	4*n	==>	n+1	*/



void  compress_7_paire(unsigned long val1,unsigned long val2,unsigned long* in,unsigned long*out,int n,int pasin);

#undef	data_mask
#define	data_mask	0x1fffff	/* masque pour les donnes en entree 21 bit	*/
#undef	ecart_mask		
#define	ecart_mask		0x7f		/*	masque pour l'ecart 7 bits		*/		

#undef	 ecart_
#define	ecart_(i,n,val)		(( (in[(i*4+n)*pasin]&data_mask) | ecart_bit )-val);


void compress_7_2(unsigned long* in,unsigned long*out,int n,int pasin)
{
unsigned long val1,val2;
val1=in[0]&0x1fffe0;val2=in[pasin]&0x1fffe0;
*out=( (val1<<11) & 0xffff0000 )	|	( (val2 >> 5) & 0xffff ) ;

/*printf("in[0]=%x  val1=%x        in[1]=%x   val2=%x  \n",in[0],val1,in[1],val2);
printf("in[2]=%x    in[3]=%x   \n",in[2],in[3]);*/
compress_7_paire(val1,val2,in,out+1,n/4,pasin);
}


void  compress_7_paire(unsigned long val1,unsigned long val2,unsigned long* in,unsigned long*out,int n,int pasin)
{

unsigned long val1p,val2p;
unsigned long ec1,ec2,ec3,ec4;
int i,k;unsigned long q;


for(i=0;i<n;i++)
	{
	k=0;q=63;		/* 7 bit ->  127  ->   +-63	*/

	ec1=ecart_(i,0,val1);	shif(ec1,k,q);	
	
	ec2=ecart_(i,1,val2);	shif(ec2,k,q);
	val1p =new_val(val1,ec1,k);

	ec3=ecart_(i,2,val1p);	shif(ec3,k,q);
	val2p=new_val(val2,ec2,k);

	ec4=ecart_(i,3,val2p);	shif(ec4,k,q);
	
	ec1 =  arrondi(ec1,k) >> k;
	ec2 =  arrondi(ec2,k) >> k;
	ec3 =  arrondi(ec3,k) >> k;
	ec4 =  arrondi(ec4,k) >> k;

	out[i]= ((ec1&ecart_mask)<<25) | ((ec2&ecart_mask)<<18) | ((ec3&ecart_mask)<<11) | ((ec4&ecart_mask)<<4) | k ;

	/*if(i<5)  printf("i=%d  k=%d  ec= %x %x %x %x  out=%x \n",i,k,ec1,ec2,ec3,ec4,out[i]);	*/

	val1=(val1+ ( (ec1 + ec3 ) << k ))&data_mask;
	val2=(val2+ ( (ec2 + ec4 ) << k ))&data_mask;
	}
}




