#define BZ_GENERATE_GLOBAL_INSTANCES

/*
 * This module contains instances of global variables and objects.
 * The preprocessor symbol _bz_global normally expands to "extern",
 * but the declaration of BZ_GENERATE_GLOBAL_INSTANCES causes it
 * to expand to "" for this source file.  This ensures that globals
 * will have one unique instance, in libblitz.a.
 */

#include <blitz/indexexpr.h>      // Tensor index objects
#include <blitz/bzdebug.h>        // Test suite globals
#include <blitz/array.h>          // Dummy array object (_dummyArray)

// NEEDS_WORK: after switch from RCS to CVS, get a version identifier.
char* _blitz_id = "@(#) Blitz++ class library";

// Instatiation explicite de vecteurs et matrices

using namespace blitz ;

void tst_instance_arrays_forlibs()
{
Array<int,1> iv(3), iv2(3);
Array<long,1> lv(3), lv2(3);
Array<float,1> fv(3), fv2(3);
Array<double,1> dv(3), dv2(3);
Array<int,2> im(3,3);
Array<long,2> lm(3,3);
Array<float,2> fm(3,3);
Array<double,2> dm(3,3);
dv = 1.5, 22.66, 333.777;
dm = 9.1, 88.22, 777.333,
     8.2, 77.33, 666.444,
     7.3, 66.44, 555.333;
firstIndex i;
secondIndex j;
dv2 = sum(dm(i,j)*dv(j),j);
iv = lv = fv = dv;
im = lm = fm = dm;
fv2 = sum(fm(i,j)*fv(j),j);
iv2 = sum(im(i,j)*iv(j),j);
lv2 = sum(lm(i,j)*lv(j),j);
}
