/* Pour integration par la methode "higher order gaussian terms" */
/*                                                cmv   23/06/94 */

#ifndef NBINTEG_H_SEEN
#define NBINTEG_H_SEEN

#ifdef __cplusplus
extern "C" {
#endif

/*=============================================================*/
static int mIhoq2 = 2;
static double Ihoq2X[2] =
   { -0.288675135, 0.288675135 };
static double Ihoq2W[2] =
   {  0.500000000, 0.500000000 };
/*=============================================================*/
static int mIhoq3 = 3;
static double Ihoq3X[3] =
   { -0.387298335, 0.000000000, 0.387298335 };
static double Ihoq3W[3] =
   {  0.277777778, 0.444444444, 0.277777778 };
/*=============================================================*/
static int mIhoq4 = 4;
static double Ihoq4X[4] =
   { -0.430568156,-0.169990522, 0.169990522, 0.430568156 };
static double Ihoq4W[4] =
   {  0.173927423, 0.326072577, 0.326072577, 0.173927423 };
/*=============================================================*/
static int mIhoq5 = 5;
static double Ihoq5X[5] =
   { -0.453089923,-0.269234655, 0.000000000, 0.269234655,
      0.453089923 };
static double Ihoq5W[5] =
   {  0.118463443, 0.239314335, 0.284444444, 0.239314335,
      0.118463443 };
/*=============================================================*/
static int mIhoq6 = 6;
static double Ihoq6X[6] =
   { -0.466234757,-0.330604693,-0.119309593, 0.119309593,
      0.330604693, 0.466234757 };
static double Ihoq6W[6] =
   {  0.085662246, 0.180380787, 0.233956967, 0.233956967,
      0.180380787, 0.085662246 };
/*=============================================================*/
static int mIhoq7 = 7;
static double Ihoq7X[7] =
   { -0.474553956,-0.370765593,-0.202922576, 0.000000000,
      0.202922576, 0.370765593, 0.474553956 };
static double Ihoq7W[7] =
   {  0.064742483, 0.139852696, 0.190915025, 0.208979592,
      0.190915025, 0.139852696, 0.064742483 };
/*=============================================================*/
static int mIhoq8 = 8;
static double Ihoq8X[8] =
   { -0.480144928,-0.398333239,-0.262766205,-0.091717321,
      0.091717321, 0.262766205, 0.398333239, 0.480144928 };
static double Ihoq8W[8] =
   {  0.050614268, 0.111190517, 0.156853323, 0.181341892,
      0.181341892, 0.156853323, 0.111190517, 0.050614268 };
/*=============================================================*/
static int mIhoq9 = 9;
static double Ihoq9X[9] =
   { -0.484080120,-0.418015554,-0.306685716,-0.162126712,
      0.000000000, 0.162126712, 0.306685716, 0.418015554,
      0.484080120 };
static double Ihoq9W[9] =
   {  0.040637194, 0.090324080, 0.130305348, 0.156173539,
      0.165119678, 0.156173539, 0.130305348, 0.090324080,
      0.040637194 };
/*=============================================================*/
static int mIhoq10 = 10;
static double Ihoq10X[10] =
   { -0.486953264,-0.432531683,-0.339704784,-0.216697697,
     -0.074437169, 0.074437169, 0.216697697, 0.339704784,
      0.432531683, 0.486953264 };
static double Ihoq10W[10] =
   {  0.033335672, 0.074725675, 0.109543181, 0.134633360,
      0.147762112, 0.147762112, 0.134633360, 0.109543181,
      0.074725675, 0.033335672 };
/*=============================================================*/
static int mIhoq16 = 16;
static double Ihoq16X[16] =
   { -0.494700467,-0.472287512,-0.432815601,-0.377702204,
     -0.308938122,-0.229008389,-0.140801775,-0.047506255,
      0.047506255, 0.140801775, 0.229008389, 0.308938122,
      0.377702204, 0.432815601, 0.472287512, 0.494700467 };
static double Ihoq16W[16] =
   {  0.013576230, 0.031126762, 0.047579256, 0.062314486,
      0.074797994, 0.084578260, 0.091301708, 0.094725305,
      0.094725305, 0.091301708, 0.084578260, 0.074797994,
      0.062314486, 0.047579256, 0.031126762, 0.013576230 };
/*=============================================================*/


/* Integration 2D domaine carre */
/* Selon Abramowitz p892-893 formule 25.462, residu ordre 0.5**6 */
/* 0.387298=0.5*sqrt(3/5)  0.197531=16/81  0.123457=10/81  0.077160=25/324 */
/*  */
#if defined(SIMPSON9)
  static int   nd2d = 9;
  static float dx2d[9] = { 0.000000 ,  0.000000 ,  0.000000
                         ,-0.387298 ,  0.387298 , -0.387298
                         , 0.387298 , -0.387298 ,  0.387298 };
  static float dy2d[9] = { 0.000000 , -0.387298 ,  0.387298
                         , 0.000000 ,  0.000000 , -0.387298
                         , 0.387298 ,  0.387298 , -0.387298 };
  static float  w2d[9] = { 0.197531 ,  0.123457 ,  0.123457
                         , 0.123457 ,  0.123457 ,  0.077157
                         , 0.0771605,  0.0771605,  0.0771605};
#elif defined(SIMPSON4)
  static int   nd2d = 4;
  static float dx2d[4] = { 0.288675, 0.288675,-0.288675,-0.288675 };
  static float dy2d[4] = { 0.288675,-0.288675, 0.288675,-0.288675 };
  static float  w2d[4] = { 0.250000, 0.250000, 0.250000, 0.250000 };
#elif defined(INTEG5)
  static int   nd2d = 5;
  static float dx2d[5] = { 0. , -0.3, -0.3,  0.3, 0.3 };
  static float dy2d[5] = { 0. , -0.3,  0.3, -0.3, 0.3 };
  static float  w2d[5] = { 0.2,  0.2,  0.2,  0.2, 0.2 };
#elif  defined(NOINTEG)
  static int   nd2d = 1;
  static float dx2d[1] = { 0. };
  static float dy2d[1] = { 0. };
  static float  w2d[1] = { 1. };
#else
  static int   nd2d = 0;
  static float dx2d[1] = { 999999. };
  static float dy2d[1] = { 999999. };
  static float  w2d[1] = { 0. };
#endif


/* Coeff pour le calcul du volume de f(x,y,z) dans des cubes 3D */
static int   nd3d = 6;
static float dx3d[6] = { 0.5, -0.5, 0.0,  0.0, 0.0,  0.0  };
static float dy3d[6] = { 0.0,  0.0, 0.5, -0.5, 0.0,  0.0  };
static float dz3d[6] = { 0.0,  0.0, 0.0,  0.0, 0.5, -0.5  };
static float  w3d[6] = { 0.166667, 0.166667, 0.166667, 
                         0.166667, 0.166667, 0.166667 };
#ifdef __cplusplus
}
#endif

#endif

