/*  Macro pour faire des bytes-swap        */
/*                   CMV+Reza Fev 98       */

#ifndef  SWAPBYTES_H_SEEN
#define  SWAPBYTES_H_SEEN

/*  Les arguments des define sont consideres comme pointeur */

#define  Swap_Bytes8(_x8_)                                 \
{                                                          \
  uint_8 _tmp_ = *(uint_8*)(_x8_);                         \
  *(uint_8*)(_x8_) = ((_tmp_ >> (7*8)) & 0x000000FF) |     \
                     ((_tmp_ >> (5*8)) & 0x0000FF00) |     \
                     ((_tmp_ >> (3*8)) & 0x00FF0000) |     \
                     ((_tmp_ >> (1*8)) & 0xFF000000) |     \
                     ((_tmp_ & 0xFF000000) << (1*8))  |    \
                     ((_tmp_ & 0x00FF0000) << (3*8))  |    \
                     ((_tmp_ & 0x0000FF00) << (5*8))  |    \
                     ((_tmp_ & 0x000000FF) << (7*8));      \
}


#define  Swap_Bytes4(_x4_)                                 \
{                                                          \
  uint_4 _tmp_ = *(uint_4*)(_x4_);                         \
  *(uint_4*)(_x4_) = ((_tmp_ >> 24) & 0x000000FF) |        \
                     ((_tmp_ >> 8)  & 0x0000FF00) |        \
                     ((_tmp_ & 0x0000FF00) << 8)  |        \
                     ((_tmp_ & 0x000000FF) << 24);         \
}


#define  Swap_Bytes2(_x2_)                                 \
{                                                          \
  uint_2 _tmp_ = *(uint_2*)(_x2_);                         \
  *(uint_2*)(_x2_) = ((_tmp_ >> 8) & 0x00FF) |             \
                     ((_tmp_ & 0x00FF) << 8);              \
}

#endif
