// This may look like C code, but it is really -*- C++ -*-
// Classe de services destinee a NamedObjMgr pour piapp
// Reza                             Aout 98
// CEA-DAPNIA      LAL-IN2P3/CNRS

#ifndef SERVNOBJM_H_SEEN
#define SERVNOBJM_H_SEEN

#include "machdefs.h"
#include <string>

#include "ctimer.h"

#include "pdlmgr.h"
#include "dlftypes.h"

class NTuple;
class Histo;
class Histo2D;
class HProf;
class PIStdImgApp;

class Services2NObjMgr {
public:
         	Services2NObjMgr(PIStdImgApp* app, string& tmpdir);
		~Services2NObjMgr();

  inline void   SetImgApp(PIStdImgApp* app) {mImgapp = app; }

  void 		Nobj_ComputeExpressions(PPersist* obj, string& expx, string& expy, string& expz, 
                                        string& expwt, string& expcut,
                                        NTuple* nt=NULL, Histo* h1=NULL,
                                        Histo2D* h2=NULL, HProf* hp=NULL);
  PlotExprFunc  LinkExprFunc(string& vardec, string& expx, string& expy, string& expz, 
                             string& wt, string& cut);
  DlFunction    LinkFunctionFromFile(string& fnamer, char* funcname);
  void 		CloseDLL();  

  char* 	PClassIdToClassName(int cid);
  char* 	PClassIdToShortClassName(int cid);
  string 	FileName2Name(string const & fn);
  int 		DecodeDispOption(string& dopt, bool& fgsrgr);

  void 		InitGrAttNames();

//   Variables membre , en public pour le moment
  struct gratt_item {
    int a1, a2;
  };
  typedef map<string, gratt_item, less<string> > GrAttNames;

//  Pour les changements d'attributs graphiques / de visualisation
  GrAttNames GrAcolors;
  GrAttNames GrAlines;
  GrAttNames GrAmarkers;
  GrAttNames GrAfonts;
  GrAttNames GrAcmap;  
  GrAttNames GrAzoom;  
  GrAttNames GrAaxes;  

  PDynLinkMgr * dynlink;  // shared-lib lib.so
  string TmpDir;          // Pour fichiers temporaires

  PIStdImgApp* mImgapp;
  
};


#endif
