//  Adaptateurs et Drawers divers pour Outils PEIDA++
//                             R. Ansari  06-08/98
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#include "pipodrw.h"
#include "generalfit.h"


//================================================================
// PIGFFDrawer
//================================================================

PIGFFDrawer::PIGFFDrawer(GeneralFunction* f)
: mFunc(f), mNParms(f->NPar()), mParms(new double[mNParms])
{
  ASSERT(f->NVar() == 1);
}

PIGFFDrawer::~PIGFFDrawer()
{
  delete[] mParms;
}

void
PIGFFDrawer::SetParms(double const* p)
{
  for (int i=0; i<mNParms; i++)
    mParms[i] = p[i];
}


void
PIGFFDrawer::Draw(PIGraphicUC* g, double /*xmin*/, double/*ymin*/, double/*xmax*/, double/*ymax*/)
{
  PIGrCoord x1, x2, y1, y2;
  g->GetGrSpace(x1, x2, y1, y2);
  double xMax = x2;
  double xMin = x1;
  double yMax = y2;
  double yMin = y1;
  double xStep = (xMax - xMin)/100;
  double xOld = xMin;
  double yOld = 0;
//  double yOld = f->Value(&xMin, mParms);
  for (double x = xMin+xStep; x<xMax; x+=xStep) {
   double y = 0; // $CHECK$
//    double y = f->Value(&x, mParms);
    if (y>yMin && yOld>yMin && 
        y<yMax && yOld<yMax) 
           g->DrawLine(xOld, yOld, x, y);
    xOld = x;
    yOld = y;
  }
}

// ----------------------------------------------------------
// Adaptateur de vecteurs Peida++ a P1DArrayAdapter
// ----------------------------------------------------------

/* --Methode-- */
POVectorAdapter::POVectorAdapter(Vector* v, bool ad)
        : P1DArrayAdapter(v->NElts())
{
aDel = ad; mVec = v;
}

/* --Methode-- */
POVectorAdapter::~POVectorAdapter()
{
if (aDel) delete mVec;
}

/* --Methode-- */
double POVectorAdapter::Value(int i)
{ 
return((*mVec)(i)); 
}

// ----------------------------------------------------------
// Adaptateur d'Histo-2D Peida++ a P2DArrayAdapter
// ----------------------------------------------------------

/* --Methode-- */
POH2DAdapter::POH2DAdapter(Histo2D* h2d, bool ad)
        : P2DArrayAdapter(h2d->NBinX(), h2d->NBinY())
{
aDel = ad; mH2d = h2d;
DefineXYCoordinates(h2d->XMin(), h2d->YMin(), h2d->WBinX(), h2d->WBinY() );
}

/* --Methode-- */
POH2DAdapter::~POH2DAdapter()
{
if (aDel)  delete mH2d;
}

/* --Methode-- */
double POH2DAdapter::Value(int ix, int iy)
{
return((*mH2d)(ix, iy));
}

// ----------------------------------------------------------
// Adaptateur de matrice Peida++ a P2DArrayAdapter
// Attention  Y: Lignes (rows)  X: Colonnes
// ----------------------------------------------------------

/* --Methode-- */
POMatrixAdapter::POMatrixAdapter(Matrix* mtx, bool ad)
        : P2DArrayAdapter(mtx->NCol(), mtx->NRows())
{
aDel = ad; mMtx = mtx;
}

/* --Methode-- */
POMatrixAdapter::~POMatrixAdapter()
{
if (aDel)  delete mMtx;
}

/* --Methode-- */
double POMatrixAdapter::Value(int ix, int iy)
{
// Attention MatrixAdapter(X=Colonne, Y= Row) = Matrix(row, col)  
return((*mMtx)(iy, ix));
}


