#ifndef PISTLIST_H
#define PISTLIST_H

#include "stlist.h"
#include "pidrawer.h"

class PIStarList : public PIDrawer {
public:
                     PIStarList(StarList* stl, bool ad);
  virtual           ~PIStarList();
  
  virtual void       Draw(PIGraphicUC* g, double xmin, double ymin, double xmax, double ymax);
  virtual void       UpdateLimits();
  
  void               SetFluxLimits(float min=1., float max=-1., int nl=5, bool dispflx=false, bool refr=false);

  inline StarList*   StList()  { return(mStL); }  
  inline float       FluxMin() { return(mFmin); }       
  inline float       FluxMax() { return(mFmax); }
       
protected:
  StarList* mStL;
  bool mAdDO;
  float mFmin, mFmax;
  int mNLev;
  double mF0, mDLgF;
  bool mDspFV;
};

#endif
