#include <stdio.h>
#include <stdlib.h>
#include <typeinfo>
#include <iostream.h>
#include <string>

#include "ppersist.h"
#include "anydataobj.h"
#include "sambainit.h"

int main(int narg, char* arg[])
{
SambaInitiator smbinit;

if (narg < 2) {
  cerr << " Usage: scanppf filename [s]\n " <<  endl;
  exit(0);
  }

try {
  string flnm = arg[1];
  bool seq=false;
  if (narg > 2) seq=true;
  PPersist* op = NULL;
  cout << " Opening PPF file " << flnm << endl; 
  PInPersist s(flnm);
  int nt = s.NbTags();
  cout << " Number of tags in file = " << nt << endl;
  if (nt < 1) { 
    op = s.ReadObject();
    cout << " Object Type " << typeid(*op).name() << endl;
    if (op) delete op;
  }
  else if (!seq) {
    for(int i=0; i<nt; i++) {
      cout << ">>> TagNum= " << i << " TagName= " << s.GetTagName(i) << endl;
      s.GotoTagNum(i);
      op = s.ReadObject();
      cout << " Object Type " << typeid(*op).name() << endl;
      if (op) delete op;
    }
  } else {
    while (1) {
      op = s.ReadObject();
      cout << " Object Type " << typeid(*op).name() << endl;
      if (op) delete op;
    }
  }
}
catch (PThrowable pex) {
  cerr << " scanppf/Error - Exception catched " << pex.Msg() << endl;
}

cout << " ----------- End of scanppf ------------- " << endl;
}
