// This may look like C code, but it is really -*- C++ -*-
// Module PI : Peida Interactive      PIWdgX
//                                    Reza 10/95            
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#ifndef PIWDG_X_SEEN
#define PIWDG_X_SEEN

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>

#include "piwdggen.h"

typedef Widget SysDWdg;
typedef WidgetClass SysDWdgClass;


class PIWdgX : public PIWdgGen 
{
public:
// Les methodes ...
  		  PIWdgX(int narg=0, char *arg[]=NULL);
  		  PIWdgX(PIContainerGen *par, char *nom, 
         		 int sx=10, int sy=10, int px=0, int py=0);

  virtual 	 ~PIWdgX();

  virtual void	 FinishCreate(); // apres avoir installe les sous-vues

  virtual void   SetSize(int sx, int sy);
  virtual void   SetPos(int px, int py);
  virtual void   SetLabel(string const & lab);


  virtual void   SetBinding(PIBindingKind left, PIBindingKind top, 
                            PIBindingKind right, PIBindingKind bottom);
  virtual bool   GetBinding(PIBindingKind& left, PIBindingKind& top, 
                            PIBindingKind& right, PIBindingKind& bottom);

  virtual int    XSize();
  virtual int    YSize();
  virtual int    XPos();
  virtual int    YPos();

  virtual string Nom();  
  virtual void   GetScreenPos(int & spx, int & spy);

  virtual void   Manage();
  virtual void   UnManage();
  virtual bool   IfManaged();
  virtual bool   IsVisible();

//  Fonction qui doit etre appelee pour rafraichir la fenetre 
  virtual void       	 Refresh();

//  Pour rendre un composant graphique (PIWdg) sensible/insensible 
  virtual void           SetSensitive();
  virtual void           SetUnSensitive();
  virtual bool           IfSensitive();

//  Gestion de copier-coller
  virtual bool           ClaimSelection(unsigned int typ=PICP_string);
  virtual void           SelectionLost();
  virtual unsigned int   RequestSelection(unsigned int typ=PICP_string);
  virtual void*          ProvideSelection(unsigned int& typ, unsigned int& len);
  virtual void           SelectionTransferEnd();
  virtual void           PasteSelection(unsigned int typ, void *, unsigned int l);

//  Copie depuis un PIWdgGen
  virtual void		 CopyFrom(PIWdgGen* wdg, int ox, int oy, int dx, int dy, int x, int y);

//  Gestion des EventHandler
  virtual void		 AddDrawHandler(PIEventHandler* drwh, bool ad=false);
  virtual void		 RemoveDrawHandler(PIEventHandler* drwh);
  virtual void		 AddEventHandler(PIEventHandler* evh, unsigned long evtmask, bool ad=false);
  virtual void		 RemoveEventHandler(PIEventHandler* evh);

// En public, pour permettre l'acces depuis call-back Xt
  virtual void		 CallDrawHandlers(int x0, int y0, int dx, int dy); 
  virtual void		 CallEventHandlers(unsigned long evt, int px, int py,
                                           int k, int km, unsigned long tm);

//  Usage limite a a la version X11
  inline SysDWdg XtWdg() const {return(sdw); }; 
  inline SysDWdg& XtWdg() {return(sdw); }; 
  int 		CreateXtWdg(char *nom, SysDWdgClass wdgcl=NULL, SysDWdg pwdg=NULL,
                  int sx=10, int sy=10, int px=0, int py=0, Arg* oarg=NULL, int na=0);
  int   	BorderWidth();
  void  	SetBorderWidth(int bw);

protected:
// Definit le type de Widget, en particulier pour la gestion des feneteres de haut niveau
// k_wmi_cascade : Widget cree en cascade d'un autre (Exemple pour PIWIndowX)
  enum WmIntState { k_wmi_unknown=0,
                    k_wmi_normal=1, k_wmi_toplevel=2, 
                    k_wmi_transient=3, k_wmi_override=4,
                    k_wmi_appshell=5, k_wmi_cascade=6 };

  int 		InitXt(int narg=0, char *arg[]=NULL); 

  SysDWdg sdw;
  WmIntState wmis;
  bool stmng;
  PIBindingKind mBKleft, mBKright, mBKtop, mBKbottom;
};

typedef PIWdgX PIWdg;

// -------- La classe PIScreenBuffer ----------
class PIScreenBuffer {
public :
  			PIScreenBuffer(int sx, int sy);
  virtual		~PIScreenBuffer();

  virtual int         	XSize();
  virtual int         	YSize();
  virtual  void 	CopyFromWdg(PIWdg* wdg, int ox, int oy, int dx, int dy, int x, int y);
  virtual  void 	CopyToWdg(PIWdg* wdg, int ox, int oy, int dx, int dy, int x, int y);
  virtual  void 	CopyFrom(PIScreenBuffer* grb, int ox, int oy, int dx, int dy, int x, int y);

//  Acces au Drawable X 
  inline Pixmap		XScrBuffer() { return(xScrbuff); }
protected :
  Pixmap xScrbuff;
  int mSx, mSy;
};


// Utile pour avoir acces au Display et Screen X ...
SysDWdg   PIXtTopWdg();
XtAppContext* PIXtAppCtx(int& szx, int& szy, int& szf);
Display * PIXDisplay();
#define  PIXScreen()  DefaultScreen(PIXDisplay()) 
Time PIXGetLastEventTime();
unsigned long PIXGetLastEventSerial();
void PIXSetLastEventTimeSerial(Time t, unsigned long ser);
void PIXGetLastEventInfo(unsigned int& st, Time& t);


#endif/* PIWDGX_SEEN */



