#ifndef SYNGEN_H_SEEN
#define SYNGEN_H_SEEN

#include <complex>
#include <vector>
#include "tvector.h"
#include "sphericalmap.h"

void alm2mapgen(const int nsmax,const int nlmax,const int nmmax,
	     const vector< vector< complex<double> > >&alm,
	     SphericalMap<double>& map,
	     vector< complex<long double> > b_north,
	     vector< complex<long double> > b_south,
	     vector< complex<long double> > bw,
	     vector< complex<long double> > data,
	     vector< complex<long double> > work);

void syn_phasgen(const int nsmax,const int nlmax,const int nmmax,
	      const vector< complex<long double> >& datain,
	      int nph, Vector& dataout, double phi0,
	      vector< complex<long double> >& bw);

void create_almgen(const int nsmax,const int nlmax,const int nmmax,
		vector< vector< complex<double> > >& alm,
		vector<float>& cls_tt,int& iseed,const float fwhm,
		vector<float> lread);
#endif
