/*    ------ 1)  Declaration de structure temps et date  ----- */
/*                            Reza 92/93                       */

#ifndef DATIME_H_SEEN
#define DATIME_H_SEEN

#ifdef __cplusplus
extern "C" {
#endif


typedef struct 
  {
  int Jour;
  int Mois;
  int Annee;
  }  JMA ;


typedef struct 
  {
  int  Heures;
  int Minutes;
  double Secondes;
  } HMS ;

/*   ----------    2) Donnees constantes  ---------- */
#ifdef  DATIMEPRIVEE
/*   Noms des jours de la semaine - des mois  */
char *NomJo[7] =  {"Lundi","Mardi","Mercredi","Jeudi","Vendredi","Samedi","Dimanche"};
char *NomMo[12] = 
  {"Janvier","Fevrier","Mars","Avril","Mai","Juin","Juillet",
  "Aout","Septembre","Octobre","Novembre","Decembre"};

/*   Nombre de jours des mois   */
static int NbJoMois[12] = {31,28,31,30,31,30,31,31,30,31,30,31};

#else

extern char *NomJo[7];
extern char *NomMo[12];

#endif

/*    ------ 3) Macro de manipulation de date et heure  -------  */

#define  NomJour(d)      (NomJo[NumJour(d)-1])
#define  NomMois(d)      (NomMo[d.Mois-1])

/*   Chaine de forme  hh:mm:sec  <->  structure HMS   */
#define  StrgtoHMS(s,h)  ( sscanf(s,"%d:%d:%lf", &(h.Heures),&(h.Minutes),&(h.Secondes)) )
#define  HMStoStrg(h,s)  ( sprintf(s,"%02d:%02d:%02.0f", h.Heures,h.Minutes,h.Secondes) )

/*    Chaine de forme jj/mm/aa  <-> structure JMA     */
/* EA 140998, machin infame pour que ca marche pour 1998/09/14... Pourquoi avoir fait */
/* des macros ??????????????????????????????????????????????????????????????????????? */
#define  StrgtoJMA(strg,j)  ( sscanf(strg,"%d/%d/%d", &(j.Jour),&(j.Mois),&(j.Annee)),\
    (j.Jour>1900 ? sscanf(strg,"%d/%d/%d", &(j.Annee),&(j.Mois),&(j.Jour)) : 1) ) 

#define  JMAtoStrg(j,strg)  ( sprintf(strg,"%02d/%02d/%4d", j.Jour,j.Mois,j.Annee) )
#define  JMAtoStrgLong(j,strg)   ( sprintf(strg,"%s , %d %s %d", NomJo[NumJour(j)-1], j.Jour, NomMo[j.Mois-1], j.Annee) )

#define  HtoSec(h)        (h*3600.) 
#define  SectoHMS(s)      ( HtoHMS(s/3600.) )


#define  TLegtoTSolM(d,h)    ( TUtoTSolM(TLegtoTU(d,h)) )

/*  -------  4)  Declaration des fonctions    ----------  */

void StrtoHMS(char *s,HMS* hms);
void HMStoStr(HMS hms,char *s);

int NbJourMois(int a, int m);
long JMAtoJ(JMA jma);
JMA JtoJMA(long j);
int NumJour(JMA jma);
JMA JsmmaatoJMA(int jj, int mm, int aa);
JMA JApmmaatoJMA(int nj, int mm, int aa);

double HMStoH(HMS hms);
double HMStoSec(HMS hms);

long DatetoSec(char const* date, char const* heure);
long DatetoSecOff(char const* date, char const* heure);

HMS HtoHMS(double h);
HMS DtoDMS(double h);
HMS DoubletoHMS(double h);

void SetTSolMOff(double tsmoff, char *name);
void PrtTSolMOff(void);
int  SetTLegOff(char *dtz, char* dhz);
void PrtTLegInfo(int aa);
int  TLegOffset(JMA date, HMS heure);

HMS TLegtoTU(JMA date, HMS TLeg);
HMS TUtoTLeg(JMA date, HMS TLeg);
HMS TUtoTSolM(HMS TU);
HMS TLegtoTSid(JMA date, HMS TLeg);
HMS GMST_at_0h_UT(JMA date);
HMS TUtoTSid(JMA date, HMS TU);
int TSidtoTU(JMA date, HMS TS, HMS *TU1, HMS *TU2);
void TSidSetupLaSilla(void);

double ToJulianDay(JMA dateTU, HMS hmsTU);
int FromJulianDay(double JD,JMA* dateTU, HMS* hmsTU);

double StrgtoDegDec(char *strg);   
char * DegDectoStrg(double deg, char *strg);

double EccEarth(JMA dateTU);
double ObliqEarth(JMA dateTU);
double LongEcPerihelie(JMA dateTU);
void EquatToEclip(double alpha,double delta,double* l,double *b,JMA dateTU);

/*   -------------------------------------------------------  */

#ifdef __cplusplus
}
#endif

#endif


