// This may look like C code, but it is really -*- C++ -*-
//--------------------------------------------------------------------------
// File and Version Information:
//
// Description:
//
// History (add to end):
//      Sophie   Oct, 1999  - creation
//
//------------------------------------------------------------------------

#ifndef RADSPECTRAVEC_H_SEEN
#define RADSPECTRAVEC_H_SEEN
#include "machdefs.h"
#include <iostream.h>

#include "radspec.h"
#include "tvector.h"

//              ---------------------
//              -- Class Interface --
//              ---------------------

// ***IMPORTANT*** All frequencies are expressed in GHz  (10^9 Hz)
//                 and flux in Watt/m^2/sr

class RadSpectraVec : public RadSpectra
{

public:
  //Constructor
  RadSpectraVec (Vector const & nu, Vector const & fdenu, double numin=0., double numax=9.e49);

  // destructor
  virtual ~RadSpectraVec();

  //
  //  Member Functions
  //

  //  The flux() function is virtual: 
  //  It computes the flux per units of W/m^2/Hz/st
  // implemented in the subclasses
  virtual double flux(double nu) const;

  // Acces to Nu and F(nu) vectors 
  inline Vector& getNuVec() { return _vecOfNu; }
  inline Vector& getFNuVec() { return _vecOfFDeNu; }

  virtual void   Print(ostream& os)  const;

protected:
  Vector _vecOfNu;
  Vector _vecOfFDeNu;
  
};

#endif
