// This may look like C code, but it is really -*- C++ -*-
//--------------------------------------------------------------------------
// File and Version Information:
//      $Id: specrespvector.h,v 1.2 1999-11-20 21:00:53 ansari Exp $
//
// Description:
//
// History (add to end):
//      Sophie   Oct, 1999  - creation
//
//------------------------------------------------------------------------
#ifndef SPECRESPVEC_H_SEEN
#define SPECRESPVEC_H_SEEN

#include "machdefs.h"
#include <iostream.h>

#include "specresp.h"
#include "tvector.h"

//------------------------------------
// Collaborating Class Declarations --
//------------------------------------

//              ---------------------
//              -- Class Interface --
//              ---------------------

// ***IMPORTANT*** All frequencies are expressed in GHz  (10^9 Hz)

class SpecRespVec :  public SpectralResponse
{

public:
  //Constructor
  SpecRespVec(Vector const & nu, Vector const & fdenu, double numin=0., double numax=1.);

  // destructor
  virtual ~SpecRespVec();

  //
  //  Member Functions
  //

  //  The transmission() function is virtual: 
  virtual double transmission(double nu) const; 

  // Acces to Nu and T(nu) vectors 
  inline Vector& getNuVec() { return _vecOfNu; }
  inline Vector& getTNuVec() { return _vecOfFDeNu; }

  virtual void      Print(ostream& os)  const;


protected:
  Vector _vecOfNu;
  Vector _vecOfFDeNu;
};


#endif
