// This may look like C code, but it is really -*- C++ -*-
//--------------------------------------------------------------------------
// File and Version Information:
//      $Id: specrespvector.h,v 1.3 1999-11-29 14:16:09 ansari Exp $
//
// Description:
//
// History (add to end):
//      Sophie   Oct, 1999  - creation
//
//------------------------------------------------------------------------
#ifndef SPECRESPVEC_H_SEEN
#define SPECRESPVEC_H_SEEN

#include "machdefs.h"
#include <iostream.h>

#include "specresp.h"
#include "tvector.h"
#include "objfio.h"

//------------------------------------
// Collaborating Class Declarations --
//------------------------------------

//              ---------------------
//              -- Class Interface --
//              ---------------------

// ***IMPORTANT*** All frequencies are expressed in GHz  (10^9 Hz)

namespace SOPHYA {
  
  class SpecRespVec :  public SpectralResponse
  {

public:
  //Constructor
  SpecRespVec();
  SpecRespVec(Vector const & nu, Vector const & fdenu, double numin=0., double numax=1.);

  // destructor
  virtual ~SpecRespVec();

  //
  //  Member Functions
  //

  //  The transmission() function is virtual: 
  virtual double transmission(double nu) const; 

  // Acces to Nu and T(nu) vectors 
  inline Vector&  getNuVec()  { return _vecOfNu; } ;
  inline Vector& getTNuVec()  { return _vecOfFDeNu; }
  inline double getNuVec(int i) const { return _vecOfNu(i); }
  inline double getTNuVec(int i) const { return _vecOfFDeNu(i); }
  inline int NbElts() const { return _size;}
  
  virtual void      Print(ostream& os)  const;

protected:
  Vector _vecOfNu;
  Vector _vecOfFDeNu;
  int _size;
};

  // ObjFileIO<SpecRespVec> pour les PPersist 
  inline POutPersist& operator << (POutPersist& os, SpecRespVec & obj)
    { ObjFileIO<SpecRespVec> fio(&obj); fio.Write(os); return(os);}
  
  inline PInPersist& operator >> (PInPersist& os, SpecRespVec & obj)
    { ObjFileIO<SpecRespVec> fio(&obj); fio.Read(os); return(os);}

};  // End of namespace 
#endif
