// This may look like C code, but it is really -*- C++ -*-
//--------------------------------------------------------------------------
// File and Version Information:
//      $Id: blackbody.h,v 1.3 1999-11-29 14:16:03 ansari Exp $
//
// Description:
//
// History (add to end):
//      Sophie   Oct, 1999  - creation
//
//------------------------------------------------------------------------

#ifndef BLACKBODY_H_SEEN
#define BLACKBODY_H_SEEN

#include "radspec.h"
#include "convtools.h"

class BlackBody : public RadSpectra
{
public:   //Constructor
  //Constructor
  BlackBody (double temp = ConvTools::tcmb);

  virtual ~BlackBody();

  virtual double flux(double nu) const;

  // returns the value of the temperature
  inline double getTemperature() const {return _temperature;} 

  // reset the value of the temperature with a new value
  inline void setTemperature(double newtemp) { _temperature = newtemp; }

  virtual void ReadSelf(PInPersist& s);
  virtual void WriteSelf(POutPersist& s);
  // Redefintion of the Print function
  virtual void      Print(ostream& os)  const;

protected:
  double _temperature;

};

#endif
