#include <iostream.h>
#include "blackbody.h"
#include "radspecvector.h"
#include "specrespvector.h"
#include "tvector.h"
#include "squarefilt.h"
#include "trianglefilt.h"

#include "iobjspecresp.cc"

int
main() 
{ 
//   PInPersist in("out");
//   SR_ReadSelf(in);
//   cout << " " << endl;

    PInPersist in2("outTF");
    SR_ReadSelf(in2);
    cout << " " << endl;

  cout << "BlackBody!" << endl;
  BlackBody myBB(2.73);
  double freqmin =  230.;
  double freqmax = 500;
  double logIF = myBB.logIntegratedFlux(freqmin,freqmax);
  double IF    = myBB.integratedFlux(freqmin,freqmax);
  cout << "log   " << logIF << endl;
  cout << "nolog " << IF    << endl;
  cout << "min et max " << myBB.minFreq() << " :: " << myBB.maxFreq() << endl;
  cout << "full integration no log  " << myBB.integratedFlux(freqmin,freqmax) << endl;
  cout << "full integration log     " << myBB.logIntegratedFlux(freqmin,freqmax) << endl;
  cout << "full integration no log nolimit " << myBB.integratedFlux() << endl;
  cout << "full integration log  nolimit  " << myBB.logIntegratedFlux() << endl;

  cout << "squareFilter " << endl;
  SquareFilter mySF(200,600);
  double logSF = mySF.logIntegratedSpect(freqmin,freqmax);
  double SF    = mySF.IntegratedSpect(freqmin,freqmax);
  cout << "log   " << logSF << endl;
  cout << "nolog " << SF    << endl;
  cout << "min et max " << mySF.minFreq() << " :: " << mySF.maxFreq() << endl;
  cout << "full integration no log  " << mySF.IntegratedSpect(200,700) << endl;
  cout << "full integration log     " << mySF.logIntegratedSpect(200,700) << endl;
  cout << "full integration no log nolimit  " << mySF.IntegratedSpect() << endl;
  cout << "full integration log  nolimit   " << mySF.logIntegratedSpect() << endl;


  cout << "triangleFilter" << endl;
  TriangleFilter myTF(200,500,120,40);
  double logTF = myTF.logIntegratedSpect(10.,freqmax);
  double TF    = myTF.IntegratedSpect(10.,freqmax);
  cout << "log   " << logTF << endl;
  cout << "nolog " << TF    << endl;
  cout << "min et max " << myTF.minFreq() << " :: " << myTF.maxFreq() << endl;
  cout << "full integration no log  " << myTF.IntegratedSpect() << endl;
  cout << "full integration log     " << myTF.logIntegratedSpect() << endl;
  
  cout << "....Testing RadSpectraVec..." << endl;
  int maxVal = 10;
  Vector vecOfNu(maxVal);
  Vector vecOfFDeNu(maxVal);
  for (int i=0; i<maxVal; i++)
    {
      vecOfNu(i) = (double)i+230.;
      vecOfFDeNu(i) = 1.; //*(double)i+1;
      cout << "entry values  " <<  vecOfNu(i) << " " << vecOfFDeNu(i) << endl;
    }
  freqmin = 200.;
  freqmax = 259.;
  RadSpectraVec myRSV(vecOfNu, vecOfFDeNu);
  double RSV    = myRSV.integratedFlux(freqmin,freqmax);
 
  double logRSV = myRSV.logIntegratedFlux(freqmin,freqmax);
  cout << "nolog int " << RSV    << endl; 
  cout << "log int   " << logRSV << endl;
  cout << "min et max " << myRSV.minFreq() << " :: " << myRSV.maxFreq() << endl;
  cout << "full integration no log  " << myRSV.integratedFlux() << endl;
  cout << "full integration log     " << myRSV.logIntegratedFlux() << endl;

  cout << "....Testing SpecRespVec..." << endl;
  int SRVmaxVal = 100;
  Vector vecOfNuRSV(SRVmaxVal);
  Vector vecOfFDeNuRSV(SRVmaxVal);
  for (int i=0; i<SRVmaxVal; i++)
    {
      vecOfNuRSV(i) = (double)i+130.;
      vecOfFDeNuRSV(i) = 10*(double)i+1;
      //      cout << "entry values  " <<  vecOfNuRSV(i) << " " << vecOfFDeNuRSV(i) << endl;
    }
  freqmin = vecOfNuRSV(0);
  freqmax = vecOfNuRSV(SRVmaxVal-1);
  SpecRespVec mySRV(vecOfNuRSV, vecOfFDeNuRSV);
  double SRV    = mySRV.IntegratedSpect(freqmin,freqmax);
  double logSRV = mySRV.logIntegratedSpect(freqmin,freqmax);
  cout << "nolog " << SRV    << endl; 
  cout << "log   " << logSRV << endl;
  cout << "min et max " << mySRV.minFreq() << " :: " << mySRV.maxFreq() << endl;
  cout << "full integration no log " << mySRV.IntegratedSpect() << endl;
  cout << "full integration log    " << mySRV.logIntegratedSpect() << endl;
  
  cout << "----------------------------------------------------" << endl;
  cout << "...Testing filter and integrate !" << endl;

  cout << " BBSF nolog " << myBB.filteredIntegratedFlux(mySF,200.,400.) << endl;
  cout << " BBSF   log " << myBB.filteredLogIntFlux(mySF,200.,400.) << endl;
  cout << "full integration no log  " << myBB.integratedFlux(200.,400.) << endl;
  cout << "full integration log     " << myBB.logIntegratedFlux(200.,400.) << endl;
  cout << "SF" << endl;
  cout << "full integration no log  " << mySF.IntegratedSpect(200.,400.) << endl;
  cout << "full integration log     " << mySF.logIntegratedSpect(200.,400.) << endl;

  cout << " BBTF nolog " << myBB.filteredIntegratedFlux(myTF,200.,400.) << endl;
  cout << " BBTF   log " << myBB.filteredLogIntFlux(myTF,200.,400.) << endl;
  cout << "TF" << endl;
  cout << "full integration no log  " << myTF.IntegratedSpect(200.,400.) << endl;
  cout << "full integration log     " << myTF.logIntegratedSpect(200.,400.) << endl;

  /*
  cout << " SZSF nolog " << mySZ.filteredIntegratedFlux(mySF,30.,100.) << endl;
  cout << " SZSF  log " << mySZ.filteredLogIntFlux(mySF,30.,100.) << endl;
  cout << "full integration no log  " << mySZ.integratedFlux(30.,100.) << endl;
  cout << "full integration log     " << mySZ.logIntegratedFlux(30.,100.) << endl;

  cout << " SZTF nolog " << mySZ.filteredIntegratedFlux(myTF,30.,100.) << endl;
  cout << " SZTF   log " << mySZ.filteredLogIntFlux(myTF,30.,100.) << endl;
			   */
  cout << "********" << endl;
  double min, max;
  min=232;
  max=235;

  cout << " RSVSF nolog " << myRSV.filteredIntegratedFlux(mySF,min,max) << endl;
  cout << " RSVSF   log " << myRSV.filteredLogIntFlux(mySF,min,max) << endl;
  cout << "full integration no log  " << myRSV.integratedFlux(230.,500.) << endl;
  cout << "full integration log     " << myRSV.logIntegratedFlux(230.,500.) << endl;
  cout << "full integration no log min max " << myRSV.integratedFlux(min,max) << endl;
  cout << "full integration log  min max   " << myRSV.logIntegratedFlux(min,max) << endl;

  cout << " RSVTF nolog " << myRSV.filteredIntegratedFlux(myTF,230.,500.) << endl;
  cout << " RSVTF   log " << myRSV.filteredLogIntFlux(myTF,230.,500.) << endl;
  
//   cout << "New TESTS USING IOBJS!" << endl;
//   POutPersist out("out");
//   TriangleFilter* myTF2 = new TriangleFilter(10,200,20,40);
//   SR_WriteSelf(myTF2,out);

//   POutPersist outV("outV");
//   cout << "check before anything" << vecOfNu.NElts()<< endl;
//   SpecRespVec* mySRV2 = new SpecRespVec(vecOfNu, vecOfFDeNu);
//   SR_WriteSelf(mySRV2,outV);
  
//   Vector myVec(10);
//   myVec.ReSize(10);
//   cout << myVec.NElts();
//   return 1;

  cout << "read and write things in file...ppersist!" << endl;
  TriangleFilter myTF2(10,200,20,40);
  POutPersist outTF("outTF");
  myTF2.WriteSelf(outTF);
//   PInPersist inTF("outTF");
//   myTF2.ReadSelf(inTF);
  

} 
