#ifndef BRUIT_H_SEEN
#define BRUIT_H_SEEN

class NoiseGenerator {
public :
			NoiseGenerator(float sigma=1.); 
  virtual		~NoiseGenerator();
  virtual float		Noise();
  inline  unsigned long int           NCoups() { return(mNCoups); }

protected :
unsigned long  int mNCoups;
  float mSigma;
};

class  RWalkNoise : public NoiseGenerator {
public :
			RWalkNoise(float sigma=1.);
  virtual		~RWalkNoise();
  virtual float		Noise();

protected:
  float mState;
};

class OOFNoise : public NoiseGenerator {
public :
  enum {
     ACF_Def = 0,
     ACF_Exp = 1
  };
			OOFNoise(float sigma=1., int typacf=ACF_Exp, 
                                 int mem=128, float tau=1.);
  virtual		~OOFNoise();
  virtual float         Noise();
  void                  Print();

protected:
  int mTypACF;
  int mMemL;
  float mTau; 
  double* mState;
  double* mDyn;
};

class EXPNoise : public NoiseGenerator {
public :
  enum {
     ACF_Def = 0,
     ACF_Exp = 1
  };
			EXPNoise(float sigma=1., int typacf=ACF_Exp, 
                                 int mem=128, float tau=1.);
  virtual		~EXPNoise();
  virtual float         Noise();
  void                  Print();

protected:
  int mTypACF;
long  int mMemL;
  float mTau; 
  double* mState;
  double* mDyn;
};

class MemNoise : public NoiseGenerator {
public :
  enum {
     ACF_Def = 0,
     ACF_Exp = 1
  };
			MemNoise(float sigma=1., int mem=128, float tau=1., int ava=4096);
  virtual		~MemNoise();
  virtual float         Noise();
  virtual float         Avance(long Asauter);
  int                   Print();
 
protected:
  int mTypACF;
  int mMemL; int mCoupHaut;
unsigned long   mNappel;
unsigned long   mNappLast;
  float mTeappel;
  float mTau;
  float mduree;
  float mTdernier;
  int mNtirage;
  int mMemPos;
  int mMemNeg;
  float* mStPos;
  float* mTePos;
  float* mStNeg;
  float* mTeNeg;
};

class  SumNoise : public NoiseGenerator {
public :
			SumNoise(float fknee, float sig=1., int mem=32, float tau=10.);
  virtual		~SumNoise();
  virtual float		Noise();

protected:
  MemNoise* mn;
};


#endif

