#ifndef SPHERICALMAP_SEEN
#define SPHERICALMAP_SEEN

// valeurs de Pi, 2*Pi, etc                                              
#include "nbmath.h"
#include <math.h>
#include "pixelmap.h"
#include "tvector.h" 

// Map of pixels on a whole sphere.
// Class hierarchy :
//   PixelMap
//      SphericalMap
//         SphereThetaPhi
//         SphereGorski
//         SphereIco
//      LocalMap

template<class T>
class SphericalMap : public PixelMap<T> 
{
  
public :

SphericalMap() {};
virtual	 ~SphericalMap() {};

// Overloading of () to access pixel number k.
inline T& operator()(int k) {return(PixVal(k));}
inline T  const& operator()(int k) const {return(PixVal(k));}
inline T& operator()(double theta,double phi) {return(PixValSph(theta,phi));};
inline T  const& operator()(double theta,double phi) const {return(PixValSph(theta,phi));};

// index characterizing the size pixelization : m for SphereThetaPhi
// nside for Gorski sphere...
virtual void Resize(int_4 m)=0;
virtual int_4 NbThetaSlices() const=0;
virtual void GetThetaSlice(int_4 index,double& theta, TVector<double>& phi, TVector<T>& value) const=0; 
};
#endif






