//
// Simulation de memoire partagee pour mac
//

#include <stdio.h>
#include "macshm.h"

int shmget(int key, size_t size, int flags)
{
  char fn[256];
  sprintf(fn, "shm.%d", key);
  c2pstr(fn);
  OSErr err = 0;
  if (flags & IPC_CREAT) err = Create((StringPtr)fn, 0,'MMCC','TEXT');
  if ((flags & IPC_EXCL) && (err == dupFNErr)) return -1;
  short fRefNum;
  FSOpen((StringPtr)fn, 0, &fRefNum);
  long sz;
  GetEOF(fRefNum, &sz);
  if (size > sz) SetEOF(fRefNum, size);
  FSClose(fRefNum);
  return key;
}

void* shmat(int shmid, void*, int)
{
  char fn[256];
  sprintf(fn, "shm.%d", shmid);
  c2pstr(fn);
  short fRefNum;
  FSOpen((StringPtr)fn, 0, &fRefNum);
  long sz;
  GetEOF(fRefNum, &sz);
  char* p = new char[sz + sizeof(int)];
  *(int*)p = shmid;
  p += sizeof(int);
  FSRead(fRefNum, &sz, p);
  FSClose(fRefNum);
  return (void*) p;
}

int shmctl(int shmid, int cmd, struct shmid_ds* buf)
{
  char fn[256];
  sprintf(fn, "shm.%d", shmid);
  c2pstr(fn);
  switch(cmd) {
    case IPC_STAT:
      short fRefNum;
      FSOpen((StringPtr)fn, 0, &fRefNum);
      long sz;
      GetEOF(fRefNum, &sz);
      buf->shm_segsz = sz;
      FSClose(fRefNum);
      return 0;
    case IPC_RMID:
      FSDelete((StringPtr)fn, 0);
      return 0;
  }
  return -1;
}
int shmdt(const	void *addr)
{
  char* p = (char*)addr - sizeof(int);
  int shmid = *(int*)p;
  
  char fn[256];
  sprintf(fn, "shm.%d", shmid);
  c2pstr(fn);
  short fRefNum;
  FSOpen((StringPtr)fn, 0, &fRefNum);
  long sz;
  GetEOF(fRefNum, &sz);
  FSWrite(fRefNum, &sz, addr);
  FSClose(fRefNum);
  
  delete[] p;
  return 0;
}

