#include <stdio.h>

#include <LString.h>
#include "pibwdgmac.h"
#include "piupdattachment.h"
#include <algobase.h>
#include <string.h>

// Les methodes de la classe  PIBWdgGen
 
/* --Methode-- */
PIBaseWdgMac::PIBaseWdgMac(PIContainerGen *par, char *nom,
                       int sx, int sy, int px, int py) :
PIBaseWdgGen(par, nom, sx, sy, px, py), 
mFCol(PI_Black), mBCol(PI_White)
{
    mAdapter->AddAttachment(new PIUpdAttachment(this));
    mPane->AddAttachment(new PIUpdAttachment(this));
    cursor = NULL;
}


/* --Methode-- */
PIBaseWdgMac::~PIBaseWdgMac()
{
}

/* --Methode-- */
void PIBaseWdgMac::ActivatePtrCross()
{
// toujours actif pour le moment
}

/* --Methode-- */
void PIBaseWdgMac::ActivateButton(int /*bid*/)
{
}

/* --Methode-- */
void PIBaseWdgMac::ActivateMove(int /*bid*/)
{
}

/* --Methode-- */
void PIBaseWdgMac::ActivateKeyboard()
{
}

/* --Methode-- */
void PIBaseWdgMac::EraseWindow(int x0, int y0, int dx, int dy)
{
  if (mPane->FocusDraw()) {
     GrafPtr p = mPane->GetMacPort();
     if (p) EraseRgn(p->visRgn);
//	   Rect r;
//	   mPane->CalcPortFrameRect(r);
//       EraseRect(&r);
  }
}

/* --Methode-- */
void PIBaseWdgMac::DrawString(int x, int y, char* s, int /*pos*/)
{
  if (mPane->FocusDraw()) {
    LocalToMacPortPoint(x, y, x, y);
    ::MoveTo(x, y);
    LStr255 ps = s;
    ::TextFont(applFont);
    ::DrawString(ps);
  }
}

/* --Methode-- */
void PIBaseWdgMac::DrawOpaqueString(int x, int y, char* s, int /*pos*/)
{
  if (mPane->FocusDraw()) {
    LocalToMacPortPoint(x, y, x, y);
    ::MoveTo(x, y);
    LStr255 ps = s;
    ::TextFont(applFont);
	Rect box;
	box.left = x;
	box.bottom = y;
	int iWidth = TextWidth(s,0,strlen(s));
	box.right = box.left + iWidth;
	int z;
	box.top = box.bottom + GetFontHeight(z,z);
    ::TETextBox(s,strlen(s),&box,teForceLeft);
  }
}

/* --Methode-- */
void PIBaseWdgMac::DrawMarker(int x0, int y0)
{
int hmsz = mMrkSz/2;
int dmsz = mMrkSz-hmsz;
int x[4],y[4];
PILineAtt clatt;

if (mMrk == PI_DotMarker) {
    LocalToMacPortPoint(x0, y0, x0, y0);
  ::MoveTo( x0, y0);
  ::Line(0,0);
}

else
  {
  clatt = mLAtt;
  SelLine(PI_ThinLine);
  switch (mMrk)
    {
    case  PI_PlusMarker :
      DrawLine(x0-hmsz, y0, x0+dmsz, y0);
      DrawLine(x0, y0-hmsz, x0, y0+dmsz);
      break;
    case  PI_CrossMarker :
      DrawLine(x0-hmsz, y0-hmsz, x0+dmsz, y0+dmsz);
      DrawLine(x0-hmsz, y0+dmsz, x0+dmsz, y0-hmsz);
      break;  
    case PI_CircleMarker :
      DrawCircle(x0, y0, hmsz);
      break;
    case PI_FCircleMarker :
      DrawFCircle(x0, y0, hmsz);
      break;
    case PI_BoxMarker :
      DrawBox(x0-hmsz, y0-hmsz, mMrkSz, mMrkSz);
      break;
    case PI_FBoxMarker :
      DrawFBox(x0-hmsz, y0-hmsz, mMrkSz, mMrkSz);
      break;
    case  PI_TriangleMarker :
      x[1] = mMrkSz; y[1] = 0; x[2] = -hmsz; y[2] = -mMrkSz; 
      x[3] = -dmsz; y[3] = +mMrkSz; x[0] = x0-hmsz; y[0] = y0+hmsz;  
      DrawPolygon(x, y, 4);
      break;
    case  PI_FTriangleMarker :
      x[1] = mMrkSz; y[1] = 0; x[2] = -hmsz; y[2] = -mMrkSz; 
      x[3] = -dmsz; y[3] = +mMrkSz; x[0] = x0-hmsz; y[0] = y0+hmsz;  
      DrawFPolygon(x, y, 4);
      break;
    default :
      ::MoveTo( x0, y0);
      ::Line(0,0);
      break;
    }
  SelLine(clatt);
  }
return;
}

/* --Methode-- */
void PIBaseWdgMac::DrawMarkers(int *x, int *y, int n)
{
int i;

if (n <= 0)  return;
for(i=0; i<n; i++) DrawMarker(x[i], y[i]);
}

/* --Methode-- */
int PIBaseWdgMac::CalcStringWidth(char const* s)
{
  if (mPane->FocusDraw())
    ::TextFont(applFont);
  return ::TextWidth(s,0,strlen(s));
}

void PIBaseWdgMac::LocalToMacPortPoint(int x, int y, int& xm, int& ym)
{
    Point pt = {y,x};
    //mPane->LocalToPortPoint(pt);
//	SPoint32 loc;
//	mPane->GetFrameLocation(loc);
//    xm = pt.h + loc.h;
//    ym = pt.v + loc.v;  // Ou bien ne pas utiliser de Pane, que des View ?
    xm = pt.h;
    ym = pt.v;
}


/* --Methode-- */
void PIBaseWdgMac::DrawLine(int x1, int y1, int x2, int y2)
{
  if (mPane->FocusDraw()) {
    int x,y;
    LocalToMacPortPoint(x1, y1, x, y);
    ::MoveTo(x,y);
    LocalToMacPortPoint(x2, y2, x, y);
    ::LineTo(x,y);
  }
}

/* --Methode-- */
void PIBaseWdgMac::DrawBox(int x0, int y0, int dx, int dy)
{
  if (mPane->FocusDraw()) {
    int x,y;
    LocalToMacPortPoint(x0, y0, x, y);
    Rect r = {y, x, y+dy, x+dx};
    if (r.top  > r.bottom) swap(r.top,  r.bottom);
    if (r.left > r.right)  swap(r.left, r.right);
    r.right++; r.bottom++;
    ::FrameRect(&r);
  }
}


/* --Methode-- */
void PIBaseWdgMac::DrawFBox(int x0, int y0, int dx, int dy)
{
  if (mPane->FocusDraw()) {
    int x,y;
    LocalToMacPortPoint(x0, y0, x, y);
    Rect r = {y, x, y+dy, x+dx};
    if (r.top  > r.bottom) swap(r.top,  r.bottom);
    if (r.left > r.right)  swap(r.left, r.right);
    r.right++; r.bottom++;
    ::PaintRect(&r);
  }
}

/* --Methode-- */
void PIBaseWdgMac::DrawCircle(int x0, int y0, int r) 
{
  if (mPane->FocusDraw()) {
    int x,y;
    LocalToMacPortPoint(x0, y0, x, y);
    Rect rr = {y-r, x-r, y+r, x+r};
    if (rr.top  > rr.bottom) swap(rr.top,  rr.bottom);
    if (rr.left > rr.right)  swap(rr.left, rr.right);
    ::FrameOval(&rr);
  }
}

/* --Methode-- */
void PIBaseWdgMac::DrawFCircle(int x0, int y0, int r) 
{
  if (mPane->FocusDraw()) {
    int x,y;
    LocalToMacPortPoint(x0, y0, x, y);
    Rect rr = {y-r, x-r, y+r, x+r};
    if (rr.top  > rr.bottom) swap(rr.top,  rr.bottom);
    if (rr.left > rr.right)  swap(rr.left, rr.right);
    ::PaintOval(&rr);
  }
}

/* --Methode-- */
void PIBaseWdgMac::DrawPolygon(int *x, int *y, int n)
{
  PolyHandle h = MakePoly(x,y,n);
  if (h) {
    ::FramePoly(h);
    ::KillPoly(h);
  }
}


/* --Methode-- */
void PIBaseWdgMac::DrawFPolygon(int *x, int *y, int n)
{
  PolyHandle h = MakePoly(x,y,n);
  if (h) {
    ::PaintPoly(h);
    ::KillPoly(h);
  }
}
/* --Methode-- */
PolyHandle PIBaseWdgMac::MakePoly(int *x, int *y, int n)
{
  if (mPane->FocusDraw()) {
    PolyHandle h = ::OpenPoly();
    int xx,yy;
    LocalToMacPortPoint(x[0], y[0], xx, yy);
    ::MoveTo(xx, yy);
    for (int i=1; i<n; i++) {
      LocalToMacPortPoint(x[i], y[i], xx, yy);
      ::LineTo(xx, yy);
    }
    LocalToMacPortPoint(x[0], y[0], xx, yy);
    ::MoveTo(xx, yy);
    ClosePoly();
    return h;
  }
  return NULL;
}


/* --Methode-- */
void PIBaseWdgMac::SelForeground(PIColors col) 
{
  if (mPane->FocusDraw()) {
    long color;
    switch (col) {
      case PI_Black:
        color = blackColor;
        break;
      case PI_White:
        color = whiteColor;
        break;
      case PI_Red:
        color = redColor;
        break;
      case PI_Blue:
        color = blueColor;
        break;
      case PI_Green:
        color = greenColor;
        break;
      case PI_Yellow:
        color = yellowColor;
        break;
      default:
        color = blackColor;
    }
    ::ForeColor(color);
    mFCol = col;
  }
}

/* --Methode-- */
void PIBaseWdgMac::SelBackground(PIColors col) 
{
  if (mPane->FocusDraw()) {
    long color;
    switch (col) {
      case PI_Black:
        color = blackColor;
        break;
      case PI_White:
        color = whiteColor;
        break;
      case PI_Red:
        color = redColor;
        break;
      case PI_Blue:
        color = blueColor;
        break;
      case PI_Green:
        color = greenColor;
        break;
      case PI_Yellow:
        color = yellowColor;
        break;
      default:
        color = blackColor;
    }
    mBCol = col;
    ::BackColor(color);
  }
}

/* --Methode-- */
void PIBaseWdgMac::SelGOMode(PIGOMode mod)
{
if (mod == mGOm)  return;
  if (mPane->FocusDraw())
    switch (mod)
    {
      case PI_GOCopy :
        ::PenMode(patCopy);
        mGOm = mod;
        break;
      case PI_GOXOR :
        ::PenMode(patXor);
        mGOm = mod;
        break;
    }
return;
}


/* --Methode-- */
void PIBaseWdgMac::SelFont(PIFontSize sz, PIFontAtt att)
{
  switch(sz) {
      case PI_SmallSizeFont:
        SelFontSzPt(9, att);
        break;
      case PI_NormalSizeFont:
        SelFontSzPt(12, att);
        break;
      case PI_BigSizeFont:
        SelFontSzPt(14, att);
        break;
  }
}

/* --Methode-- */
void PIBaseWdgMac::SelFontSzPt(int npt, PIFontAtt att)
{
  if (mPane->FocusDraw()) {
    ::TextFont(applFont);
    ::TextSize(npt);
    switch(att) {
      case PI_RomanFont:
        ::TextFace(0);
        break;
      case PI_BoldFont:
        ::TextFace(bold);
        break;
      case PI_ItalicFont:
        ::TextFace(italic);
        break;
    }
  }
  mFSize = npt;
  mFAtt  = att;
}

/* --Methode-- */
void PIBaseWdgMac::SelLine(PILineAtt att)
{
  if (mPane->FocusDraw()) {
    switch(att) {
      case PI_NormalLine:
        ::PenSize(1,1);
        break;
      case PI_ThinLine:
        ::PenSize(1,1);  // Mettre en pointille, ou bien commentaire pour Laser ?
        break;
      case PI_ThickLine:
        ::PenSize(2,2);
        break;
    }
  }
  mLAtt = att;
}

/* --Methode-- */
void PIBaseWdgMac::SelPointerShape(PIPointer ptr)
{
  CursHandle c;
  if (mPane->FocusDraw()) {
    switch(ptr) {
      case PI_ArrowPointer:
        cursor = &qd.arrow;
        break;
      case PI_CrossPointer:
        c = GetCursor(crossCursor);
        HLock((Handle)c);
        cursor = c ? *c : NULL;
        break;
      case PI_HandPointer:
        c = GetCursor(128);
        HLock((Handle)c);
        cursor = c ? *c : NULL;
        break;
    }
  }
  mPtrS = ptr;
}

/* --Methode-- */
void PIBaseWdgMac::SelMarker(int msz, PIMarker mrk)
{
if (msz > 1)  { mMrk = mrk;  mMrkSz = msz; }
else  { mMrk = PI_DotMarker;  mMrkSz = 1; }
return;
}

/* --Methode-- */
PIColors  PIBaseWdgMac::GetForeground() 
{
return (mFCol);
}

/* --Methode-- */
PIColors  PIBaseWdgMac::GetBackground() 
{
return (mBCol);
}


/* --Methode-- */
PIGOMode   PIBaseWdgMac::GetGOMode()
{
return (mGOm);
}

/* --Methode-- */
PIFontAtt  PIBaseWdgMac::GetFontAtt()
{
return (mFAtt);
}

/* --Methode-- */
int        PIBaseWdgMac::GetFontSize()
{
return (mFSize);
}

/* --Methode-- */
PILineAtt  PIBaseWdgMac::GetLineAtt()
{
return (mLAtt);
}

/* --Methode-- */
PIPointer  PIBaseWdgMac::GetPointerShape()
{
return (mPtrS);
}

/* --Methode-- */
PIMarker   PIBaseWdgMac::GetMarker()
{
return (mMrk);
}

/* --Methode-- */
int        PIBaseWdgMac::GetMarkerSize()
{
return (mMrkSz);
}



/* --Methode-- */
bool PIBaseWdgMac::AdjustCursor()
{
  if (cursor) {
    ::SetCursor(cursor);
    return true;
  }
  return false;
}

/* --Methode-- 
void PIBaseWdgMac::Refresh()
{
if (mPane->IsVisible())
  Draw();
}
   J'ai mis cette fonction ds PIWdgMac::IsVisible()    Reza $CHECK$  01/12/97 
*/



void PIBaseWdgMac::DrawPixmap(int x, int y, unsigned char *pix, 
                            int sx, int sy, PIColorMap* cmap)
{
  Rect	frame;
  SetRect(&frame, 0, 0, sx, sy);
  Rect dstFrame;
  SetRect(&dstFrame, x, y, sx, sy);
  GWorldPtr gWorld;
  ThrowIfOSErr_(NewGWorld(&gWorld, 8, &frame, cmap->GetCTab(), nil, 0));
  PixMapHandle pmh = GetGWorldPixMap(gWorld);
  ::LockPixels (pmh);
  Ptr pmap = GetPixBaseAddr(pmh);
  memcpy(pmap, pix, sx*sy);
  ::ForeColor (blackColor);
  ::BackColor (whiteColor);
  ::CopyBits((BitMap *) (*pmh),
				&mPane->GetMacPort()->portBits,
				&frame, &dstFrame, srcCopy, nil);
  ::UnlockPixels (pmh);
  DisposeGWorld(gWorld);
}

void PIBaseWdgMac::SetClipRectangle(int x0, int y0, int dx, int dy)
{  // $CHECK$
}

void PIBaseWdgMac::ClearClipRectangle()
{ // $CHECK$
}

/* --Methode-- */
int PIBaseWdgMac::GetFontHeight(int& asc, int& desc)   
{
  if (mPane->FocusDraw()) {
    FontInfo info;
    GetFontInfo(&info);
    asc = info.ascent;
    desc = info.descent;
    return (asc + desc);
  } else {
    return 0;
  }
}
