#include <LString.h>
#include "pimenumac.h"
#include <algorithm>
#include <iostream>

int PIMenuMac::lastId = 1024;
vector<PIMenuMac::menuInfo> mMenuInfos;

/* --Methode-- */
PIMenuMac::PIMenuMac(PIWdg* par, const char *nom, PIMenuType pdpu) 
: PIMenuGen(par, nom, pdpu)
{
   macMenu = new LMenu(lastId, LStr255(nom));
   menuInfo info;
   info.mId = lastId;
   info.pimenu = this;
   mMenuInfos.push_back(info);
   lastId++;
}


/* --Methode-- */
PIMenuMac::~PIMenuMac()
{
  LMenuBar::GetCurrentMenuBar()->RemoveMenu(macMenu);
  mMenuInfos.erase(mMenuInfos.begin() + GetMenuNum());
  delete macMenu;
}

/* --Methode-- */
void PIMenuMac::AppendItem(const char* nom, PIMessage msg, char* sc)
{
  AddItem(nom, msg, 0, sc, NULL);
}

/* --Methode-- */
void PIMenuMac::AppendCheckItem(const char* nom, PIMessage msg, char* sc)
{
  AddItem(nom, msg, 1, sc, NULL);
}

/* --Methode-- */
void PIMenuMac::AppendPDMenu(PIMenuGen *pdm, char* sc)
{
  if (pdm->MType() !=  k_PulldownMenu) {
    cerr << "PIMenuX::AppendPDMenu()/Erreur: PullDownMenu seulement ... " << endl;
    return;
  }
  AddItem(NULL, pdm->Msg(), 2, sc, (PIMenuMac*)pdm);
}

/* --Methode-- */
void PIMenuMac::AddItem(const char* nom, PIMessage msg, int tog, char* sc, PIMenuMac *pdm)
{
  macMenu->InsertCommand("\ptemp", -2000, 1000);
  MenuHandle mh = GetMacMenuHandle();
  short i = ::CountMenuItems(mh);
  LStr255 titre(nom);
  ::SetMenuItemText(mh, i, titre);

  // Gestion menus hirarchiques
  if (tog == 2 && pdm != NULL) {
    ::SetItemCmd(mh, i, hMenuCmd);
    ::SetItemMark(mh, i, pdm->GetMacMenuID());
  }
  // Le menu hierarchique sera "insere" au moment de l'insertion dans la
  // menubar...
  
  itemInfo info;
  info.pimsg  = msg;
  info.name   = nom;
  mItemInfos.push_back(info);
}

/* --Methode-- */
int PIMenuMac::GetItemNum(const char *nom)
{
  int j=0;
  for (vector<itemInfo>::iterator i = mItemInfos.begin(); i != mItemInfos.end(); i++,j++)
    if ((*i).name == nom) return j;
  return(-1);
}

/* --Methode-- */
int PIMenuMac::GetItemNumMsg(PIMessage msg)
{
  int j=0;
  for (vector<itemInfo>::iterator i = mItemInfos.begin(); i != mItemInfos.end(); i++,j++)
    if ((*i).pimsg == msg) return j;
  return(-1);
}

/* --Methode-- */
int PIMenuMac::GetMenuNum()
{
  int j=0;
  for (vector<menuInfo>::iterator i = mMenuInfos.begin(); i != mMenuInfos.end(); i++,j++)
    if ((*i).pimenu == this) return j;
  return(-1);
}

/* --Methode-- */
int PIMenuMac::GetMenuNum(short menuId)
{
  int j=0;
  for (vector<menuInfo>::iterator i = mMenuInfos.begin(); i != mMenuInfos.end(); i++,j++)
    if ((*i).mId == menuId) return j;
  return(-1);
}

/* --Methode-- */
PIMenu* PIMenuMac::GetMenu(short menuId)
{
  int j=0;
  for (vector<menuInfo>::iterator i = mMenuInfos.begin(); i != mMenuInfos.end(); i++,j++)
    if ((*i).mId == menuId) return (*i).pimenu;
  return(NULL);
}


/* --Methode-- */
void
PIMenuMac::SetStateNum(int n, bool st)
{
  if (n<0 || n >= mItemInfos.size()) return; // $CHECK$ exception ?
  ::CheckItem(macMenu->GetMacMenuH(), n, st);
}

/* --Methode-- */
void
PIMenuMac::SetStateMsg(PIMessage msg, bool st)
{
  int i = GetItemNumMsg(msg);
  if (i>=0)
    SetStateNum(i, st);
}

/* --Methode-- */
void
PIMenuMac::SetState(const char* nom, bool st)
{
  int i = GetItemNum(nom);
  if (i>=0)
    SetStateNum(i, st);
}

void
PIMenuMac::DeleteItemNum(int n)
{
  if (n<0 || n >= mItemInfos.size()) return; // $CHECK$ exception ?
  macMenu->RemoveItem(n+1);
  mItemInfos.erase(mItemInfos.begin()+n);
}

void
PIMenuMac::DeleteItemMsg(PIMessage msg)
{
  int i = GetItemNumMsg(msg);
  if (i>=0)
    DeleteItemNum(i);
}

void
PIMenuMac::DeleteItem(const char* nom)
{
  int i = GetItemNum(nom);
  if (i>=0)
    DeleteItemNum(i);
}

void
PIMenuMac::ItemSelected(int item)
{
  if (item<0 || item >= mItemInfos.size()) return; // $CHECK$ exception ?
  Send(mItemInfos[item].pimsg, PIMsg_Click, (void*) mItemInfos[item].name.c_str());
}

string
PIMenuMac::GetMenuItemText(int item)
{
  if (item<0 || item >= mItemInfos.size()) return ""; // $CHECK$ exception ?
  return mItemInfos[item].name;
}

PIMessage
PIMenuMac::GetMenuItemMsg(int item)
{
  if (item<0 || item >= mItemInfos.size()) return -1; // $CHECK$ exception ?
  return mItemInfos[item].pimsg;
}



void
PIMenuMac::Show()
{}

void
PIMenuMac::Show(PIWdg *w, int px, int py)
{}


MenuHandle
PIMenuMac::GetMacMenuHandle()
{
  return macMenu->GetMacMenuH();
}

ResIDT
PIMenuMac::GetMacMenuID()
{
  return macMenu->GetMenuID();
}


