#include "pistdwdggen.h"

/************* PILabelGen ************/

//++
// Class	PILabel
// Lib		PI
// include	pistdwdggen.h
//
//	Composant graphique simple permettant d'afficher une tiquette (texte).
//	"PILabelGen" dfinit l'interface (classe virtuelle pure). Les objets 
//	instancis doivent tre de la classe "PILabel" dclare dans le fichier
//	entte "PISTDWDG_H".
//--
//++
// Links	Parents
// PIWdg
//--

//++
// Titre	Constructeur, mthodes
//--
//++
// PILabel(PIContainerGen* par, const char* nom, int sx=10, int sy=10, int px=0, int py=0)
//	Cration d'un objet PILabel ayant un contenu (tiquette) identique  "nom".
// void SetLabel(string const& lab)
//	Modifie l'tiquette affiche par l'objet 
//--




PILabelGen::PILabelGen(PIContainerGen *par, const char *nom,
                         int sx, int sy, int px, int py)
: PIWdg(par, nom, sx, sy, px, py)
{}

PILabelGen::~PILabelGen()
{}

/************* PIButtonGen ************/
//++
// Class	PIButton
// Lib		PI
// include	pistdwdggen.h
//
//	Composant graphique de type bouton .
//	"PIButtonGen" dfinit l'interface (classe virtuelle pure). Les objets 
//	instancis doivent tre de la classe "PIButton" dclare dans le fichier
//	entte "PISTDWDG_H". Lors de l'activation, le message de l'objet complt
//	par le modifier "PIMsg_Click" est envoy ("Send()"). Le champ "data" 
//	contient le pointeur "NULL".
//--
//++
// Links	Parents
// PIWdg
//--

//++
// Titre	Constructeur, mthodes
//--
//++
// PIButton(PIContainerGen* par, const char* nom, PIMessage msg, int sx=10, int sy=10, int px=0, int py=0)
//	Cration d'un objet PIButton avec une tiquette identique  "nom".
// void SetLabel(string const& lab)
//	Modifie l'tiquette affiche par l'objet bouton.
//--



PIButtonGen::PIButtonGen(PIContainerGen *par, const char *nom, PIMessage msg,
                         int sx, int sy, int px, int py)
: PIWdg(par, nom, sx, sy, px, py)
{
SetMsg(msg);
}

PIButtonGen::~PIButtonGen()
{}



/************* PITextGen ************/
//++
// Class	PIText
// Lib		PI
// include	pistdwdggen.h
//
//	Composant graphique de type champ texte.
//	"PITextGen" dfinit l'interface (classe virtuelle pure). Les objets 
//	instancis doivent tre de la classe "PIText" dclare dans le fichier
//	entte "PISTDWDG_H". Si un message non nul a t associ a l'objet 
//	par "PIWdg::SetMsg(PIMessage msg)", le message correspondant complt
//	par le modifier "PIMsg_DataChanged" est envoy ("Send()") lors de 
//	de la validation du champ texte (touche Retour-Chariot). Le champ "data" 
//	contient le pointeur "NULL".
//--
//++
// Links	Parents
// PIWdg
//--

//++
// Titre	Constructeur, mthodes
//--
//++
//  PIText(PIContainerGen* par, const char* nom, int sx=10, int sy=10, int px=0, int py=0)
//	Cration d'un objet PIText.
//  PIText(PIContainerGen* par, const char* nom, bool vsb, bool hsb, -
//  int sx=10, int sy=10, int px=0, int py=0)
//	Cration d'un objet PIText multiligne, muni d'ascenseurs 
//	Vertical si "vsb == true", horizontal si "hsb == true".
// void SetText(string const& txt)
//	Modifie  le contenu du champ texte.
// string  GetText() const
//	Renvoie le contenu du champ texte.
// void  SetMutiLineMode(bool mlm=false)
//	Active ("mlm=true") ou dsactive ("mlm=false") la possibilit d'dition multiligne.
// void  SetTextEditable(bool te=true)
//	Permet de rendre le contenu du champ texte non-ditable ("te=false")
//--

PITextGen::PITextGen(PIContainerGen *par, const char *nom,
                         int sx, int sy, int px, int py)
: PIWdg(par, nom, sx, sy, px, py)
{}

PITextGen::PITextGen(PIContainerGen *par, const char *nom, bool vsb, bool hsb, 
                         int sx, int sy, int px, int py)
: PIWdg(par, nom, sx, sy, px, py)
{}

PITextGen::~PITextGen()
{}




/************* PICheckBoxGen ************/

PICheckBoxGen::PICheckBoxGen(PIContainerGen *par, const char *nom, PIMessage msg,
                         int sx, int sy, int px, int py)
: PIWdg(par, nom, sx, sy, px, py)
{
SetMsg(msg);
}

PICheckBoxGen::~PICheckBoxGen()
{}

//++
// Class	PICheckBox
// Lib		PI
// include	pistdwdggen.h
//
//	Composant graphique de type CheckBox.
//	"PICheckBoxGen" dfinit l'interface (classe virtuelle pure). Les objets 
//	instancis doivent tre de la classe "PICheckBox" dclare dans le fichier
//	entte "PISTDWDG_H". Lors du changement d'tat, le message de l'objet  
//	complt par le modifier "PIMsg_DataChanged" est envoy ("Send()").
//	Le champ "data" contient un pointeur sur une variable de type "bool"
//	qui contient l'tat de l'objet lors de l'appel  "Send()".
//--
//++
// Links	Parents
// PIWdg
//--

//++
// Titre	Constructeur, mthodes
//--
//++
// PICheckBox(PIContainerGen* par, const char* nom,  PIMessage msg, int sx=10, int sy=10, int px=0, int py=0);
//	Cration d'un objet PICheckBox.
// void SetState(bool st=false)
//	Modifie l'tat de l'objet.
// bool GetState()
//	Renvoie l'tat de l'objet.
//--


/************* PIScaleGen ************/
//++
// Class	PIScale
// Lib		PI
// include	pistdwdggen.h
//
//	Composant graphique de type chelle ou curseur. (La valeur reprsente 
//	par l'objet peut tre modifie  l'aide d'un curseur).
//	"PIScaleGen" dfinit l'interface (classe virtuelle pure). Les objets 
//	instancis doivent tre de la classe "PIScale" dclare dans le fichier
//	entte "PISTDWDG_H". Lors du changement de valeur, le message de l'objet  
//	complt par le modifier "PIMsg_DataChanged" est envoy ("Send()").
//	Le champ "data" contient un pointeur sur une variable de type "int"
//	qui contient la valeur associe   l'objet lors de l'appel  "Send()".
//--
//++
// Links	Parents
// PIWdg
//--

//++
// Titre	Constructeur, mthodes
//--
//++
// PIScale(PIContainerGen* par, const char* nom, PIMessage msg, int dir=kSDirLtoR, int sx=100, int sy=10, int px=0, int py=0)
//	Cration d'un objet PIScale. "dir" indique la direction et le sens d'affichage et peut
//	prendre les valeurs "kSDirLtoR" (gauche  droite), "kSDirRtoL" (droite  gauche),
//	"kSDirDownUp" (bas vers haut) et "kSDirUpDown" (de haut en bas).
// void  SetMinMax(int min, int max)
//	Modifie les valeurs extrmes de l'chelle. L'objet est cr avec des bornes par dfaut de 1  100.
// void GetMinMax(int& min, int& max)
//	Renvoie les valeurs extrmes de l'chelle.
// void SetValue(int v)
//	Modifie la valeur courante de l'chelle.
// int GetValue()
//	Renvoie la valeur courante de l'chelle.
//--


PIScaleGen::PIScaleGen(PIContainerGen *par, const char *nom, PIMessage msg, 
                       int /*dir*/, int sx, int sy, int px, int py)
: PIWdg(par, nom, sx, sy, px, py) 
{
SetMsg(msg);
}

PIScaleGen::~PIScaleGen()
{}

/************* PIScrollBarGen ************/
//++
// Class	PIScrollBar
// Lib		PI
// include	pistdwdggen.h
//
//	Composant graphique de type ascenseur. 
//	"PIScrollBarGen" dfinit l'interface (classe virtuelle pure). Les objets 
//	instancis doivent tre de la classe "PIScrollBar" dclare dans le fichier
//	entte "PISTDWDG_H". Lors du changement de valeur, le message de l'objet  
//	complt par le modifier "PIMsg_DataChanged" est envoy ("Send()").
//	La mthode "ActivateDrag()" permet d'activer l'envoi de message en 
//	cours de dplacement du curseur. Dans ce cas, le modifier 
//	"PIMsg_Drag" est appliqu.
//	Le champ "data" contient un pointeur sur une variable de type "int"
//	qui contient la position courante du curseur.
//--
//++
// Links	Parents
// PIWdg
//--

//++
// Titre	Constructeur, mthodes
//--
//++
// PIScrollBar(PIContainerGen* par, const char* nom, PIMessage msg, int dir=kSDirUpDown, int sx=10, int sy=100, int px=0, int py=0)
//	Cration d'un objet PIScrollBar. "dir" indique la direction et le sens d'affichage et peut
//	prendre les valeurs "kSDirLtoR" (gauche  droite), "kSDirRtoL" (droite  gauche),
//	"kSDirDownUp" (bas vers haut) et "kSDirUpDown" (de haut en bas).
// void  ActivateDrag(bool acd=false)
//	Active ("acd=true") ou dsactive ("mlm=false") l'envoi de messages lors du mouvement du curseur.
// void SetMinMax(int min, int max)
//	Modifie les valeurs extrmes de l'ascenseur. L'objet est cr avec des bornes par dfaut de 1  100.
//	La valeur "max" correspond  la position extrme taille du curseur comprise ("max=posmax+taille").
// void GetMinMax(int& min, int& max)
//	Renvoie les valeurs extrmes de l'ascenseur. 
// void SetValue(int v)
//	Modifie la position courante de l'ascenseur.
// int GetValue()
//	Renvoie la position courante de l'ascenseur.
// void  SetSlSize(int sz)
//	Modifie la taille de l'ascenseur.
// int  GetSlSize()
//	Renvoie la taille de l'ascenseur.
//--

PIScrollBarGen::PIScrollBarGen(PIContainerGen *par, const char *nom, PIMessage msg, 
                       int /*dir*/, int sx, int sy, int px, int py)
: PIWdg(par, nom, sx, sy, px, py) 
{
SetMsg(msg);
}

PIScrollBarGen::~PIScrollBarGen()
{}

