#include <stdio.h>
#include "piapplx.h"
#include "picontainerx.h"


#define DEBUG_APPLX

/* --Methode-- */
PIApplicationX::PIApplicationX(int sx, int sy, int narg, char *arg[])
: PIApplicationGen()
{
int sxt, syt;

#ifdef DEBUG_APPLX
puts("PIApplicationX::PIApplicationX()_info : App creation");
#endif
mStop = true;
topwdg = new PIWdgX(narg, arg);

intcont = new PIContainerX((PIMsgHandler *)this, topwdg, "MBCont", 
                            10, 10, 0, 0);
menubar = new PIMenubar(this, "DefMenubar");
Menubar()->SetBinding(true, true, true, false);
sxt = ( sx > Menubar()->XSize() ) ? sx : Menubar()->XSize();
syt = ( sy > 0 ) ? sy : 0;
//syt += Menubar()->YSize();
syt += 40;
MBCont()->SetSize(sxt, syt);
if ( (sx > 0) && (sy > 0) )
  {
  topcont = new PIContainerX(MBCont(), "TopLevelCont", 
                             sx, sy, 0, 40);
  topcont->SetBinding(true, true, true, true);
  topcont->Show();
  }
else topcont = MBCont();

MBCont()->Show();
topwdg->Manage();
}

/* --Methode-- */
PIApplicationX::~PIApplicationX()
{
#ifdef DEBUG_APPLX
puts("PIApplicationX::~PIApplicationX()_info : App delete");
#endif
topwdg->Unmanage();
delete menubar;
if (topcont != MBCont())  delete topcont;
delete intcont;
delete topwdg;
exit(0);
}

/* --Methode-- */
void PIApplicationX::Run()
{
XEvent evt;
#ifdef DEBUG_APPLX
puts("PIApplicationX::Run()_info : App Run ");
#endif

topwdg->SetSize(MBCont()->XSize(), MBCont()->YSize());

while (mStop)
  {
  XtNextEvent(&evt);
  XtDispatchEvent(&evt);
  }
return;
}
