#include <stdio.h>

#include "pibwdggen.h"
#include "pidrawer.h"
#include "pigraphps.h"

// Les methodes de la classe  PIBWdgGen
 
/* --Methode-- */
PIBaseWdgGen::PIBaseWdgGen(PIContainerGen *par, char *nom,
                       int sx, int sy, int px, int py) :
PIWdg(par, nom, sx, sy, px, py)
{
mDrwId=0;   // Compteur des numeros sequentiel des PIDrawer
mAdfg=false;    // Pour controle d'appel de RemoveDrawer()
mWGrC = NULL;   // PIGraphic (Contexte graphique) associe a la fenetre}
                // Doit etre cree par PIBaseWdgX/Mac/... 
}

/* --Methode-- */
PIBaseWdgGen::~PIBaseWdgGen()
{
delete mWGrC;
DeleteDrawers();
}
 

/* --Methode-- */
void PIBaseWdgGen::Refresh()
{
if ( IsVisible() )  { 
  Draw(mWGrC);
  CallDrawers(mWGrC); 
}
return;
}

/* --Methode-- */
void PIBaseWdgGen::Draw(PIGraphicGen* g, int /*x0*/, int /*y0*/, int /*dx*/, int /*dy*/)
{
this->Draw(g);
return;
}

/* --Methode-- */
void PIBaseWdgGen::Draw(PIGraphicGen* g)
{
#ifdef DEBUG_RZXB
puts("Debug_PIBaseWdgGen::Draw() Efface la fenetre par defaut ! ");
#endif
this->EraseWindow();
return;
}


/* --Methode-- */
void PIBaseWdgGen::Resize()
{
#ifdef DEBUG_RZXB
puts("Debug_PIBaseWdgGen::Resize()  resize notify ");
#endif
return;
}


/* --Methode-- */
void PIBaseWdgGen::Enter()
{
#ifdef DEBUG_RZXB
puts("Debug_PIBaseWdgGen::Enter() enter notify ");
#endif
return;
}

/* --Methode-- */
void PIBaseWdgGen::Leave()
{
#ifdef DEBUG_RZXB
puts("Debug_PIBaseWdgGen::Leave() leave notify ");
#endif
return;
}


/* --Methode-- */
void PIBaseWdgGen::But1Press(int /*x*/, int /*y*/)
{
Send(Msg(), PIMsg_Active);
#ifdef DEBUG_RZXB
printf ("PIBaseWdgGen::But1Press PosX,Y= %d %d \n", x, y);
#endif
return;
}

/* --Methode-- */
void PIBaseWdgGen::But1Release(int /*x*/, int /*y*/)
{
#ifdef DEBUG_RZXB
printf ("PIBaseWdgGen::ButReleasePosX,Y= %d %d \n", x, y);
#endif
return;
}

/* --Methode-- */
void PIBaseWdgGen::But2Press(int /*x*/, int /*y*/)
{
return;
}

/* --Methode-- */
void PIBaseWdgGen::But2Release(int /*x*/, int /*y*/)
{
return;
}

/* --Methode-- */
void PIBaseWdgGen::But3Press(int /*x*/, int /*y*/)
{
return;
}

/* --Methode-- */
void PIBaseWdgGen::But3Release(int /*x*/, int /*y*/)
{
return;
}


/* --Methode-- */
void PIBaseWdgGen::Ptr1Move(int /*x*/, int /*y*/)
{
#ifdef DEBUG_RZXB
printf ("Debug_PIBaseWdgGen::Ptr1Move PosX,Y= %d %d \n", x, y);
#endif
return;
}

/* --Methode-- */
void PIBaseWdgGen::Ptr2Move(int /*x*/, int /*y*/)
{
return;
}


/* --Methode-- */
void PIBaseWdgGen::Ptr3Move(int /*x*/, int /*y*/)
{
return;
}

/* --Methode-- */
void PIBaseWdgGen::Keyboard(int /*key*/, PIKeyModifier /*kmod*/)
{
#ifdef DEBUG_RZXB
printf("PIBaseWdgGen::Keyboard: Key= %d (%c)  Mod= %d \n", key, (char)key, (int)kmod); 
#endif
return;
}


/* --Methode-- */
void PIBaseWdgGen::PSPrint(PSFile * psf, int ofx, int ofy)
{
if (!psf) return;
PIGraphicPS grpsf(psf, (PIWdg *)this, ofx, ofy);
Draw(&grpsf);
CallDrawers(&grpsf); 
return;
}


/* --Methode-- */
int PIBaseWdgGen::AddDrawer(PIDrawer* drw, int x0, int y0, int dx, int dy, bool ad)
{
if (drw == NULL)   return(0);
mDrwId++;
BWDrwId did;
did.x0 = x0;  did.y0 = y0;
did.dx = dx;  did.dy = dy;
did.id = mDrwId;  did.ad = ad; 
did.drw = drw;
mDrwList.push_back(did);
drw->Attach(this, mDrwId);
return(mDrwId);
}

/* --Methode-- */
void PIBaseWdgGen::MoveResizeDrawer(int id, int x0, int y0, int dx, int dy)
{
list<BWDrwId>::iterator it;
for(it = mDrwList.begin(); it != mDrwList.end(); it++)  
  if ((*it).id == id) { 
    (*it).x0 = x0;  (*it).y0 = y0;
    (*it).dx = dx;  (*it).dy = dy;
    break;
  }
return;
}

/* --Methode-- */
void PIBaseWdgGen::RemoveDrawer(int id)
{
if (mAdfg)  return;
list<BWDrwId>::iterator it;
for(it = mDrwList.begin(); it != mDrwList.end(); it++)
  if ((*it).id == id) 
    { (*it).drw->Detach(this, id); mDrwList.erase(it); break; }
return;
}

/* --Methode-- */
void PIBaseWdgGen::DeleteDrawers()
{
mAdfg = true;
list<BWDrwId>::iterator it;
for(it = mDrwList.begin(); it != mDrwList.end(); it++)  
  if ((*it).ad)  delete (*it).drw;
mDrwList.erase(mDrwList.begin(), mDrwList.end() );
mAdfg = false;
return;
}


/* --Methode-- */
void PIBaseWdgGen::CallDrawers(PIGraphicGen* g, int x0, int y0, int dx, int dy)
{
float xmin,ymin, xmax, ymax;
PIGraphicUC* guc;

bool sxy = false;
if ((dx > 0) && (dy > 0))  sxy = true;

list<BWDrwId>::iterator it;
bool fgc=false;
for(it = mDrwList.begin(); it != mDrwList.end(); it++) {
  g->SaveGraphicAtt();
  guc = (*it).drw->SetDrwWdg(this, (*it).x0, (*it).y0, (*it).dx, (*it).dy, g);
  g->SetClipRectangle((*it).x0, (*it).y0, (*it).dx , (*it).dy);
  fgc = true;
  if (sxy) {
    guc->GrC2UC(x0, y0, xmin, ymin);
    guc->GrC2UC(x0+dx, y0+dy, xmax, ymax);
    if (xmin > xmax)  swap(xmin,xmax);
    if (ymin > ymax)  swap(ymin,ymax);
    (*it).drw->Draw(guc, xmin, ymin, xmax, ymax);
  }
  else (*it).drw->Draw(guc);
  g->RestoreGraphicAtt();
  }
if (fgc)  g->ClearClipRectangle();

return;
}

/* --Methode-- */
void PIBaseWdgGen::CallDrawer(PIGraphicGen* g, int id)
{
PIGraphicUC* guc;
list<BWDrwId>::iterator it;
for(it = mDrwList.begin(); it != mDrwList.end(); it++) 
  if ((*it).id == id) {
    g->SaveGraphicAtt();
    guc = (*it).drw->SetDrwWdg(this, (*it).x0, (*it).y0, (*it).dx, (*it).dy, g);
    g->SetClipRectangle((*it).x0, (*it).y0, (*it).dx , (*it).dy);
    (*it).drw->Draw(guc);
    g->RestoreGraphicAtt();    
    g->ClearClipRectangle();
    break;
  }
return;
}


/* --Methode-- */
PIGraphic* PIBaseWdgGen::WindowGraphic()
{
return(mWGrC);
}
