#ifndef PIBWDGGEN_H_SEEN
#define PIBWDGGEN_H_SEEN


#include "pisysdep.h"
#include PIWDG_H
#include PICMAP_H
#include PIGRAPHIC_H
#include "psfile.h"

// Mettre dans cet ordre, sinon g++ a des problemes   
#include <list>   

enum PIKeyModifier { PIKM_Blank = 0, PIKM_Shift = 1, PIKM_Alt = 2, PIKM_Cntl = 4 } ; 

enum PIKeyValues { PIK_Return = 1+0x2000, PIK_Enter = 2+0x2000 , 
                   PIK_BackSpace = 3+0x2000, PIK_Delete = 4+0x2000,
                   PIK_Tab = 5+0x2000, PIK_Escape = 6+0x2000, 
                   PIK_Up = 11+0x2000, PIK_Down = 12+0x2000, 
                   PIK_Right = 13+0x2000, PIK_Left = 14+0x2000,
                   PIK_Previous = 21+0x2000, PIK_Next = 22+0x2000  } ; 


enum PIPointer { PI_ArrowPointer = 1, PI_CrossPointer = 2, 
                 PI_HandPointer = 3, PI_TDLRArrowPointer = 4 };


class PIBaseWdgGen : public PIWdg
{
public:
  enum {ClassId = 5000};

// Les methodes ...

                     PIBaseWdgGen(PIContainerGen *par, char *nom,
                                   int sx=10, int sy=10, int px=0, int py=0);
  virtual            ~PIBaseWdgGen();

  virtual long       kind() {return ClassId; }

//  Activation des evenements
  virtual void       ActivatePtrCross()        = 0;
  virtual void       ActivateButton(int bid)   = 0;
  virtual void       ActivateMove(int bid)     = 0;
  virtual void       ActivateKeyboard()        = 0;

//  Divers : couleur de fond, Effacement fenetre,  forme de la souris
  virtual void       SetBackgroundColor(PIColors col=PI_White)               = 0;
  virtual void       EraseWindow(int x0=0, int y0=0, int dx=0, int dy=0)     = 0;
  virtual void       SelPointerShape(PIPointer ptr=PI_ArrowPointer)          = 0;
  virtual PIColors   GetBackgroundColor()                                    = 0;
  virtual PIPointer  GetPointerShape()                                       = 0;

//  Fonction qui doit etre appelee pour rafraichir la fenetre 
  virtual void       Refresh();

//  Fonctions qui doivent contenir le dessin du contenu du widget lui-meme
  virtual void       Draw(PIGraphicGen* g);
  virtual void       Draw(PIGraphicGen* g, int x0, int y0, int dx, int dy);
  
// Traitement des evenements   
  virtual void       Resize();
  virtual void       Enter();
  virtual void       Leave();  
  virtual void       But1Press(int x, int y);  
  virtual void       But1Release(int x, int y); 
  virtual void       But2Press(int x, int y);
  virtual void       But2Release(int x, int y);
  virtual void       But3Press(int x, int y);
  virtual void       But3Release(int x, int y);
  virtual void       Ptr1Move(int x, int y);
  virtual void       Ptr2Move(int x, int y);
  virtual void       Ptr3Move(int x, int y);
  virtual void       Keyboard(int key, PIKeyModifier kmod);

// PostScript output
  virtual void       PSPrint(PSFile* psf, int ofx = 0, int ofy = 0);

// Gestion des Drawers 
  friend class PIDrawer;
          int        AddDrawer(PIDrawer* drw, int x0, int y0, int dx, int dy, 
                               bool ad=false);
          void       MoveResizeDrawer(int id, int x0, int y0, int dx, int dy);
          void       RemoveDrawer(int id);       // Ote un drawer de la liste
          void       DeleteDrawers();            // Ote et detruit tous les drawers

//  Trace des Drawers ...          
  virtual void       CallDrawers(PIGraphicGen* g, int x0=0, int y0=0, int dx=0, int dy=0); 
  virtual void       CallDrawer(PIGraphicGen* g, int id);

// Devrait etre protected - mis ici a cause de cxx  11/07/97  Reza
  struct BWDrwId { int x0, y0; int dx, dy; int id; bool ad; PIDrawer* drw; };

  virtual PIGraphic*  WindowGraphic();

protected:
  PIGraphic* mWGrC;  // PIGraphic (Contexte graphique) associe a la fenetre
  bool mAdfg;
  int mDrwId;
  list<BWDrwId> mDrwList;

};


#endif /* PIBWDGGEN_H_SEEN */

