#include <stdio.h>
#include "pihisto.h"

PIHisto::PIHisto(Histo* histo, bool ad)
: PIScDrawer(), mHisto(histo)
{
  mAdDO = ad;     // Flag pour suppression automatique de mHisto
}

PIHisto::~PIHisto()
{
  if (mAdDO)
    delete mHisto;
}



void
PIHisto::UpdateSize()
{
  if (!mDrawer) return;
  if (mDrawer->LimitsFixed()) return;
  // Commencer par trouver nos limites
  
  float xmin = mHisto->XMin();
  float xmax = (mHisto->XMax());

  float ymax = mHisto->VMax()*1.2;
  float ymin = mHisto->VMin();
  
  if (mDrawWdg) 
    mDrawWdg->SetLimits(xmin, xmax, ymin, ymax);
  else 
    mDrawer->SetLimits(xmin, xmax, ymin, ymax);

  mDrawer->SetAxesFlags(kBoxAxes | kExtTicks | kLabels);
}


void
PIHisto::Draw(PIGraphicUC* g, float /*xmin*/, float /*ymin*/, float /*xmax*/, float /*ymax*/)
{
  for (int i=0; i<mHisto->NBins(); i++) {
		float left   = mHisto->BinLowEdge(i);
		float width  = mHisto->BinWidth();
		float bottom = 0;
		float height = (*mHisto)(i);
		g->DrawFBox(left,bottom,width,height);
		g->DrawLine(left, bottom, left, bottom + height); // Au moins une ligne...
	}
  DrawStats(g);
}

void
PIHisto::DrawStats(PIGraphicUC* g)
{
  if (!mDrawWdg) return;
  // Une boite dans le coin superieur droit
  float cellHeight = (mDrawWdg->YMax() - mDrawWdg->YMin()) * 0.05;
  float cellWidth  = (mDrawWdg->XMax() - mDrawWdg->XMin()) * 0.23;
  g->DrawLine(mDrawWdg->XMax() - cellWidth, mDrawWdg->YMax(),
                       mDrawWdg->XMax() - cellWidth, mDrawWdg->YMax() - cellHeight);
  g->DrawLine(mDrawWdg->XMax() - cellWidth, mDrawWdg->YMax() - cellHeight,
                       mDrawWdg->XMax()            , mDrawWdg->YMax() - cellHeight);
  char label[50];
  sprintf(label, "N = %.6g", mHisto->NData());
  g->SelFontSz((mDrawWdg->YMax() - mDrawWdg->YMin())/30);
  g->DrawString(mDrawWdg->XMax() - cellWidth*0.9, mDrawWdg->YMax() - cellHeight*0.8, label);
                       
}
