#include "fftservintf.h"



/* --Methode-- */
FFTServerInterface::FFTServerInterface(string info)
{
  _info = info;
  _fgnorm = false;
}

/* --Methode-- */
FFTServerInterface::~FFTServerInterface()
{
}

/* --Methode-- */
void FFTServerInterface::FFTForward(TVector< complex<r_8> > const &, TVector< complex<r_8> > &)
{
  throw ForbiddenError("FFTServer::FFTForward(TVector...) Unsupported operation !");
}

/* --Methode-- */
void FFTServerInterface::FFTBackward(TVector< complex<r_8> > const &, TVector< complex<r_8> > &)
{
  throw ForbiddenError("FFTServer::FFTBackward(TVector...) Unsupported operation !");
}

/* --Methode-- */
void FFTServerInterface::FFTForward(TVector< r_8 > const &, TVector< complex<r_8> > &)
{
  throw ForbiddenError("FFTServer::FFTForward(TVector...) Unsupported operation !");
}

/* --Methode-- */
void FFTServerInterface::FFTBackward(TVector< complex<r_8> > const &, TVector< r_8 > &)
{
  throw ForbiddenError("FFTServer::FFTBackward(TVector...) Unsupported operation !");
}

/* --Methode-- */
void FFTServerInterface::FFTForward(TMatrix< complex<r_8> > const &, TMatrix< complex<r_8> > &)
{
  throw ForbiddenError("FFTServer::FFTForward(TMatrix...) Unsupported operation !");
}

/* --Methode-- */
void FFTServerInterface::FFTBackward(TMatrix< complex<r_8> > const &, TMatrix< complex<r_8> > &)
{
  throw ForbiddenError("FFTServer::FFTBackward(TMatrix...) Unsupported operation !");
}

/* --Methode-- */
void FFTServerInterface::FFTForward(TMatrix< r_8 > const &, TMatrix< complex<r_8> > &)
{
  throw ForbiddenError("FFTServer::FFTForward(TMatrix...) Unsupported operation !");
}

/* --Methode-- */
void FFTServerInterface::FFTBackward(TMatrix< complex<r_8> > const &, TMatrix< r_8 > &)
{
  throw ForbiddenError("FFTServer::FFTBackward(TMatrix...) Unsupported operation !");
}


// ----------------- Transforme pour les float -------------------

/* --Methode-- */
void FFTServerInterface::FFTForward(TVector< complex<r_4> > const &, TVector< complex<r_4> > &)
{
  throw ForbiddenError("FFTServer::FFTForward(TVector r_4 ... ) Unsupported operation !");
}

/* --Methode-- */
void FFTServerInterface::FFTBackward(TVector< complex<r_4> > const &, TVector< complex<r_4> > &)
{
  throw ForbiddenError("FFTServer::FFTBackward(TVector r_4 ... ) Unsupported operation !");
}

/* --Methode-- */
void FFTServerInterface::FFTForward(TVector< r_4 > const &, TVector< complex<r_4> > &)
{
  throw ForbiddenError("FFTServer::FFTForward(TVector r_4 ... ) Unsupported operation !");
}

/* --Methode-- */
void FFTServerInterface::FFTBackward(TVector< complex<r_4> > const &, TVector< r_4 > &)
{
  throw ForbiddenError("FFTServer::FFTBackward(TVector r_4 ... ) Unsupported operation !");
}

/* --Methode-- */
void FFTServerInterface::FFTForward(TMatrix< complex<r_4> > const &, TMatrix< complex<r_4> > &)
{
  throw ForbiddenError("FFTServer::FFTForward(TMatrix r_4 ... ) Unsupported operation !");
}

/* --Methode-- */
void FFTServerInterface::FFTBackward(TMatrix< complex<r_4> > const &, TMatrix< complex<r_4> > &)
{
  throw ForbiddenError("FFTServer::FFTBackward(TMatrix r_4 ... ) Unsupported operation !");
}

/* --Methode-- */
void FFTServerInterface::FFTForward(TMatrix< r_4 > const &, TMatrix< complex<r_4> > &)
{
  throw ForbiddenError("FFTServer::FFTForward(TMatrix r_4 ... ) Unsupported operation !");
}

/* --Methode-- */
void FFTServerInterface::FFTBackward(TMatrix< complex<r_4> > const &, TMatrix< r_4 > &)
{
  throw ForbiddenError("FFTServer::FFTBackward(TMatrix r_4 ... ) Unsupported operation !");
}


// Methodes pour reordonner les donnees 

/* --Methode-- */
void FFTServerInterface::ReShapetoReal( TVector< complex<r_8> > const & in, TVector< r_8 >  & out)
{
  int N = in.NElts();
  out.ReSize(in.NElts()*2);
  out(0) = in(0).real();
  if (in(in.NElts()-1).imag() == 0)  {
    for(int i=1; i<in.NElts(); i++)
      out(i) = in(i).real();

    for(int i=1; i<in.NElts(); i++)
      out(i+in.NElts()-1) = in(in.NElts()-i-1).imag();

  }
  else    {
    for(int i=1; i<in.NElts(); i++)
      out(i) = in(i).real();
    for(int i=1; i<in.NElts(); i++)
      out(i+in.NElts()-1) = in(in.NElts()-i).imag();
  }
}
/* --Methode-- */
void FFTServerInterface::ReShapetoReal( TVector< complex<r_4> > const & in, TVector< r_4 >  & out)
{
  int N = in.NElts();
  out.ReSize(in.NElts()*2);
  out(0) = in(0).real();
  if (in(in.NElts()-1).imag() == 0)  {
    for(int i=1; i<in.NElts(); i++)
      out(i) = in(i).real();

    for(int i=1; i<in.NElts(); i++)
      out(i+in.NElts()-1) = in(in.NElts()-i-1).imag();

  }
  else    {
    for(int i=1; i<in.NElts(); i++)
      out(i) = in(i).real();
    for(int i=1; i<in.NElts(); i++)
      out(i+in.NElts()-1) = in(in.NElts()-i).imag();
  }
}


/* --Methode-- */
void FFTServerInterface::ReShapetoCompl(TVector< r_8 > const & in, TVector< complex<r_8> > & out)
{
  int N = in.NElts();
  out.ReSize(N/2+1);
  out(0) = complex<r_8> (in(0),0.);

  if(in.NElts()%2 !=0) {
    for(int k=1;k<=N/2+1;k++) {
      out(k) =  complex<r_8> (in(k),in(N-k));
    }
  }
  else  {
    for(int k=1;k<N/2;k++)  {
      out(k) =  complex<r_8> (in(k),in(N-k));
    }
    out(N/2) = complex<r_8> (in(N/2),0.);
  }

}

/* --Methode-- */
void FFTServerInterface::ReShapetoCompl(TVector< r_4 > const & in, TVector< complex<r_4> > & out)
{
  int N = in.NElts();
  out.ReSize(N/2+1);
  out(0) = complex<r_4> (in(0),0.);

  if(in.NElts()%2 !=0) {
    for(int k=1;k<=N/2+1;k++) {
      out(k) =  complex<r_4> (in(k),in(N-k));
    }
  }
  else  {
    for(int k=1;k<N/2;k++)  {
      out(k) =  complex<r_4> (in(k),in(N-k));
    }
    out(N/2) = complex<r_4> (in(N/2),0.);
  }

}

