#ifndef  FFTServerIntf_H_SEEN
#define  FFTServerIntf_H_SEEN

#include "machdefs.h"
#include "pexceptions.h"
#include <complex>
#include "tmatrix.h"
#include "tvector.h"

// Classe definissant l'interface pour les transformees de Fourier 
// L'implementation par defaut est vide et lance une exception 

namespace SOPHYA {

class FFTServerInterface {
 public:

// Methodes de la classe 
  FFTServerInterface(string info);
  virtual ~FFTServerInterface();

  
  virtual FFTServerInterface * Clone() = 0;

  inline void setNormalize(bool fg=false) { _fgnorm = fg; }
  inline bool getNormalize() const { return(_fgnorm); } 
  inline string getInfo() const { return _info; }

  // Transforme unidimensionnel sur des doubles
  virtual void FFTForward(TVector< complex<r_8> > const & in, TVector< complex<r_8> > & out);
  virtual void FFTBackward(TVector< complex<r_8> > const & in, TVector< complex<r_8> > & out);
  virtual void FFTForward(TVector< r_8 > const & in, TVector< complex<r_8> > & out);
  virtual void FFTBackward(TVector< complex<r_8> > const & in, TVector< r_8 > & out);

  // Transforme unidimensionnel sur des float
  virtual void FFTForward(TVector< complex<r_4> > const & in, TVector< complex<r_4> > & out);
  virtual void FFTBackward(TVector< complex<r_4> > const & in, TVector< complex<r_4> > & out);
  virtual void FFTForward(TVector< r_4 > const & in, TVector< complex<r_4> > & out);
  virtual void FFTBackward(TVector< complex<r_4> > const & in, TVector< r_4 > & out);


  //---------------------------------------------------
  // Transforme 2D sur des doubles
  virtual void FFTForward(TMatrix< complex<r_8> > const & in, TMatrix< complex<r_8> > & out);
  virtual void FFTBackward(TMatrix< complex<r_8> > const & in, TMatrix< complex<r_8> > & out);
  virtual void FFTForward(TMatrix< r_8 > const & in, TMatrix< complex<r_8> > & out);
  virtual void FFTBackward(TMatrix< complex<r_8> > const & in, TMatrix< r_8 > & out);

  // Transforme 2D sur des float
  virtual void FFTForward(TMatrix< complex<r_4> > const & in, TMatrix< complex<r_4> > & out);
  virtual void FFTBackward(TMatrix< complex<r_4> > const & in, TMatrix< complex<r_4> > & out);
  virtual void FFTForward(TMatrix< r_4 > const & in, TMatrix< complex<r_4> > & out);
  virtual void FFTBackward(TMatrix< complex<r_4> > const & in, TMatrix< r_4 > & out);

// Methodes statiques pour reordonner les donnees 
  virtual  void ReShapetoReal( TVector< complex<r_8> > const & in, TVector< r_8 >  & out);
  virtual  void ReShapetoReal( TVector< complex<r_4> > const & in, TVector< r_4 >  & out);

  virtual void ReShapetoCompl(TVector< r_8 > const & in, TVector< complex<r_8> > & out);
  virtual void ReShapetoCompl(TVector< r_4 > const & in, TVector< complex<r_4> > & out);


 protected:
  bool _fgnorm;
  string _info;
};

} // Fin du namespace

#endif
