#ifndef FFTPACK_H_SEEN
#define FFTPACK_H_SEEN

#include "machdefs.h"
/* #include "f2c.h" -- Remplace par ce qui suit */
#ifdef __cplusplus
extern "C" {
#endif

typedef int integer;
typedef unsigned uinteger;
typedef char *address;
typedef short int shortint;
  // typedef float real;
  // typedef double doublereal;
  //typedef struct { float r, i; } complex;
  //typedef struct { double r, i; } doublecomplex;

/* typedef int_4 logical;
typedef short int shortlogical;
typedef char logical1;
typedef char integer1; */

/* ---------------------- */

extern int cfftb_(integer *n, float *c__, float *wsave);
extern int cfftb1_(integer *n, float *c__, float *ch, float *wa, integer *ifac);
extern int cfftf_(integer *n, float *c__, float *wsave);
extern int cfftf1_(integer *n, float *c__, float *ch, float *wa, integer *ifac);
extern int cffti_(integer *n, float *wsave);
extern int cffti1_(integer *n, float *wa, integer *ifac);
extern int cosqb_(integer *n, float *x, float *wsave);
extern int cosqb1_(integer *n, float *x, float *w, float *xh);
extern int cosqf_(integer *n, float *x, float *wsave);
extern int cosqf1_(integer *n, float *x, float *w, float *xh);
extern int cosqi_(integer *n, float *wsave);
extern int cost_(integer *n, float *x, float *wsave);
extern int costi_(integer *n, float *wsave);
extern int ezfft1_(integer *n, float *wa, integer *ifac);
extern int ezfftb_(integer *n, float *r__, float *azero, float *a, float *b, float *wsave);
extern int ezfftf_(integer *n, float *r__, float *azero, float *a, float *b, float *wsave);
extern int ezffti_(integer *n, float *wsave);
extern int passb_(integer *nac, integer *ido, integer *ip, integer *l1, integer *idl1, float *cc, float *c1, float *c2, float *ch, float *ch2, float *wa);
extern int passb2_(integer *ido, integer *l1, float *cc, float *ch, float *wa1);
extern int passb3_(integer *ido, integer *l1, float *cc, float *ch, float *wa1, float *wa2);
extern int passb4_(integer *ido, integer *l1, float *cc, float *ch, float *wa1, float *wa2, float *wa3);
extern int passb5_(integer *ido, integer *l1, float *cc, float *ch, float *wa1, float *wa2, float *wa3, float *wa4);
extern int passf_(integer *nac, integer *ido, integer *ip, integer *l1, integer *idl1, float *cc, float *c1, float *c2, float *ch, float *ch2, float *wa);
extern int passf2_(integer *ido, integer *l1, float *cc, float *ch, float *wa1);
extern int passf3_(integer *ido, integer *l1, float *cc, float *ch, float *wa1, float *wa2);
extern int passf4_(integer *ido, integer *l1, float *cc, float *ch, float *wa1, float *wa2, float *wa3);
extern int passf5_(integer *ido, integer *l1, float *cc, float *ch, float *wa1, float *wa2, float *wa3, float *wa4);
extern int radb2_(integer *ido, integer *l1, float *cc, float *ch, float *wa1);
extern int radb3_(integer *ido, integer *l1, float *cc, float *ch, float *wa1, float *wa2);
extern int radb4_(integer *ido, integer *l1, float *cc, float *ch, float *wa1, float *wa2, float *wa3);
extern int radb5_(integer *ido, integer *l1, float *cc, float *ch, float *wa1, float *wa2, float *wa3, float *wa4);
extern int radbg_(integer *ido, integer *ip, integer *l1, integer *idl1, float *cc, float *c1, float *c2, float *ch, float *ch2, float *wa);
extern int radf2_(integer *ido, integer *l1, float *cc, float *ch, float *wa1);
extern int radf3_(integer *ido, integer *l1, float *cc, float *ch, float *wa1, float *wa2);
extern int radf4_(integer *ido, integer *l1, float *cc, float *ch, float *wa1, float *wa2, float *wa3);
extern int radf5_(integer *ido, integer *l1, float *cc, float *ch, float *wa1, float *wa2, float *wa3, float *wa4);
extern int radfg_(integer *ido, integer *ip, integer *l1, integer *idl1, float *cc, float *c1, float *c2, float *ch, float *ch2, float *wa);
extern int rfftb_(integer *n, float *r__, float *wsave);
extern int rfftb1_(integer *n, float *c__, float *ch, float *wa, integer *ifac);
extern int rfftf_(integer *n, float *r__, float *wsave);
extern int rfftf1_(integer *n, float *c__, float *ch, float *wa, integer *ifac);
extern int rffti_(integer *n, float *wsave);
extern int rffti1_(integer *n, float *wa, integer *ifac);
extern int sinqb_(integer *n, float *x, float *wsave);
extern int sinqf_(integer *n, float *x, float *wsave);
extern int sinqi_(integer *n, float *wsave);
extern int sint_(integer *n, float *x, float *wsave);
extern int sint1_(integer *n, float *war, float *was, float *xh, float *x, integer *ifac);
extern int sinti_(integer *n, float *wsave);

/* ---------------------- */

extern int cdfftb_(integer *n, double *c__, double *wsave);
extern int cdfftb1_(integer *n, double *c__, double *ch, double *wa, integer *ifac);
extern int cdfftf_(integer *n, double *c__, double *wsave);
extern int cdfftf1_(integer *n, double *c__, double *ch, double *wa, integer *ifac);
extern int cdffti_(integer *n, double *wsave);
extern int cdffti1_(integer *n, double *wa, integer *ifac);
extern int dcosqb_(integer *n, double *x, double *wsave);
extern int dcosqb1_(integer *n, double *x, double *w, double *xh);
extern int dcosqf_(integer *n, double *x, double *wsave);
extern int dcosqf1_(integer *n, double *x, double *w, double *xh);
extern int dcosqi_(integer *n, double *wsave);
extern int dcost_(integer *n, double *x, double *wsave);
extern int dcosti_(integer *n, double *wsave);
extern int dezfft1_(integer *n, double *wa, integer *ifac);
extern int dezfftb_(integer *n, double *r__, double *azero, double *a, double *b, double *wsave);
extern int dezfftf_(integer *n, double *r__, double *azero, double *a, double *b, double *wsave);
extern int dezffti_(integer *n, double *wsave);
extern int dpassb_(integer *nac, integer *ido, integer *ip, integer *l1, integer *idl1, double *cc, double *c1, double *c2, double *ch, double *ch2, double *wa);
extern int dpassb2_(integer *ido, integer *l1, double *cc, double *ch, double *wa1);
extern int dpassb3_(integer *ido, integer *l1, double *cc, double *ch, double *wa1, double *wa2);
extern int dpassb4_(integer *ido, integer *l1, double *cc, double *ch, double *wa1, double *wa2, double *wa3);
extern int dpassb5_(integer *ido, integer *l1, double *cc, double *ch, double *wa1, double *wa2, double *wa3, double *wa4);
extern int dpassf_(integer *nac, integer *ido, integer *ip, integer *l1, integer *idl1, double *cc, double *c1, double *c2, double *ch, double *ch2, double *wa);
extern int dpassf2_(integer *ido, integer *l1, double *cc, double *ch, double *wa1);
extern int dpassf3_(integer *ido, integer *l1, double *cc, double *ch, double *wa1, double *wa2);
extern int dpassf4_(integer *ido, integer *l1, double *cc, double *ch, double *wa1, double *wa2, double *wa3);
extern int dpassf5_(integer *ido, integer *l1, double *cc, double *ch, double *wa1, double *wa2, double *wa3, double *wa4);
extern int dadb2_(integer *ido, integer *l1, double *cc, double *ch, double *wa1);
extern int dadb3_(integer *ido, integer *l1, double *cc, double *ch, double *wa1, double *wa2);
extern int dadb4_(integer *ido, integer *l1, double *cc, double *ch, double *wa1, double *wa2, double *wa3);
extern int dadb5_(integer *ido, integer *l1, double *cc, double *ch, double *wa1, double *wa2, double *wa3, double *wa4);
extern int dadbg_(integer *ido, integer *ip, integer *l1, integer *idl1, double *cc, double *c1, double *c2, double *ch, double *ch2, double *wa);
extern int dadf2_(integer *ido, integer *l1, double *cc, double *ch, double *wa1);
extern int dadf3_(integer *ido, integer *l1, double *cc, double *ch, double *wa1, double *wa2);
extern int dadf4_(integer *ido, integer *l1, double *cc, double *ch, double *wa1, double *wa2, double *wa3);
extern int dadf5_(integer *ido, integer *l1, double *cc, double *ch, double *wa1, double *wa2, double *wa3, double *wa4);
extern int dadfg_(integer *ido, integer *ip, integer *l1, integer *idl1, double *cc, double *c1, double *c2, double *ch, double *ch2, double *wa);
extern int dfftb_(integer *n, double *r__, double *wsave);
extern int dfftb1_(integer *n, double *c__, double *ch, double *wa, integer *ifac);
extern int dfftf_(integer *n, double *r__, double *wsave);
extern int dfftf1_(integer *n, double *c__, double *ch, double *wa, integer *ifac);
extern int dffti_(integer *n, double *wsave);
extern int dffti1_(integer *n, double *wa, integer *ifac);
extern int dsinqb_(integer *n, double *x, double *wsave);
extern int dsinqf_(integer *n, double *x, double *wsave);
extern int dsinqi_(integer *n, double *wsave);
extern int dsint_(integer *n, double *x, double *wsave);
extern int dsint1_(integer *n, double *war, double *was, double *xh, double *x, integer *ifac);
extern int dsinti_(integer *n, double *wsave);

/* Rerunning f2c -P may change prototypes or declarations. */
#ifdef __cplusplus
}
#endif

#endif /*  FFTPACK_H_SEEN */
