#ifndef  FFTMServer_H_SEEN
#define  FFTMServer_H_SEEN

#include "fftservintf.h"

// implementation de FFTServerInterface en utilisant FFTPack 

namespace SOPHYA {

class FFTMayerServer : public FFTServerInterface {
 public:
  FFTMayerServer();
  virtual ~FFTMayerServer();

  // Implementation de l'interface FFTServerInterface

  virtual FFTServerInterface * Clone();

  // Transforme unidimensionnel sur des doubles
  virtual void FFTForward(TVector< complex<r_8> > const & in, TVector< complex<r_8> > & out);
  virtual void FFTBackward(TVector< complex<r_8> > const & in, TVector< complex<r_8> > & out);
  virtual void FFTForward(TVector< r_8 > const & in, TVector< complex<r_8> > & out);
  virtual void FFTBackward(TVector< complex<r_8> > const & in, TVector< r_8 > & out);


  // Transforme unidimensionnel sur des float
  virtual void FFTForward(TVector< complex<r_4> > const & in, TVector< complex<r_4> > & out);
  virtual void FFTBackward(TVector< complex<r_4> > const & in, TVector< complex<r_4> > & out);
  virtual void FFTForward(TVector< r_4 > const & in, TVector< complex<r_4> > & out);
  virtual void FFTBackward(TVector< complex<r_4> > const & in, TVector< r_4 > & out);


protected:
  virtual bool checkLength(int n);
};

} // Fin du namespace




#endif
