#include <stdlib.h>
#include <stdio.h>
#include <string>

#include "sc_sample.h"

static double f(double x) {return x*x;}

ScSample::ScSample(PIContainerGen *par, char *nom,
                  int sx, int sy, int px, int py)
:PIScDrawWdg(par, nom, sx, sy, px, py)

{
PIScFuncDrawer * mfd;
mfd = new PIScFuncDrawer(f);
  SetLimits(-3,3,-4,4);
AddScDrawer(mfd);
SetAxesFlags(kAxesDflt);
}

ScSample::~ScSample()
{
DeleteDrawers();
}


void
ScSample::DrawSelf(PIGraphicUC* g, float, float, float, float)
{
PIGrCoord x[5] = {-2, -1., 1., 1.7, 2.2};
PIGrCoord y[5] = {-2.5, -2.0, -1.5, -2., -2.5};

int i;
g->SelForeground(PI_Green);
g->SelMarkerSz(0.3, PI_BoxMarker);
g->DrawMarkers(x, y, 5);
g->SelForeground(PI_Magenta);
printf(" +DBG+ ScSample::DrawSelf - Marker(%g) \n", 0.3);
g->SelMarkerSz(0.3, PI_FCircleMarker);
for(i=0; i<5; i++)
   y[i] = (float)(y[i]) + 1.;
g->DrawMarkers(x, y, 5);
g->SelForeground(PI_Black);

g->DrawLine(-4, -4, 4, 4);
g->DrawLine(-2, -5, 5, 2);
g->DrawLine(-5, -4, -2, -2);
g->DrawLine(1, -10, 1, 10);
return;  
}

